/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPAllPrintParameters;
import com.helpsystems.enterprise.core.dm.sap.SAPPrintParametersDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SAPPrintParametersDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPPrintParametersDM {
    private static Logger logger = Logger.getLogger(SAPPrintParametersDMJdbc.class);
    private static final String objDesc = "SAP Print Parameters";
    private static final String SAP_PRINT_PARAMETERS_TABLE = "sap_print_parameters";
    private String sapPrintParametersTable;

    public SAPPrintParametersDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPPrintParametersDM");
        this.sapPrintParametersTable = string2 + "." + SAP_PRINT_PARAMETERS_TABLE;
    }

    @Override
    public SAPAllPrintParameters get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public SAPAllPrintParameters get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block8: {
            SAPAllPrintParameters sAPAllPrintParameters;
            block10: {
                block9: {
                    SAPAllPrintParameters sAPAllPrintParameters2;
                    String string = "SELECT id, output_device, number_of_copies, spool_request_name, cover_page_text, print_immediately, delete_after_printing, new_spool_request, spool_retention_period, page_length_of_list, line_width_of_list, print_format, cover_page_selection, print_sap_cover_page, recipient, cover_page_department, sap_authorization, name_of_spool_file, type_of_spool_request, archiving_mode, spool_request_priority, print_host_cover_page, archive_object, archive_document, archive_information, archive_text FROM " + this.sapPrintParametersTable + " WHERE id=?";
                    SAPAllPrintParametersGenerator sAPAllPrintParametersGenerator = new SAPAllPrintParametersGenerator(26);
                    connection2 = connection;
                    preparedStatement = null;
                    resultSet = null;
                    if (connection2 == null) {
                        connection2 = super.getConnectionOrFail();
                    }
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block8;
                    sAPAllPrintParameters = sAPAllPrintParameters2 = (SAPAllPrintParameters)((Object)sAPAllPrintParametersGenerator.generateObject(resultSet));
                    if (connection != null) break block9;
                    SAPPrintParametersDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block10;
                }
                SAPPrintParametersDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return sAPAllPrintParameters;
        }
        try {
            try {
                throw new NoDataException("SAP Print Parameters not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                logger.error((Object)sQLException);
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            if (connection == null) {
                SAPPrintParametersDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, resultSet);
            } else {
                SAPPrintParametersDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    private class SAPAllPrintParametersGenerator
    extends AbstractBusObjGenerator {
        public SAPAllPrintParametersGenerator(int n) {
            super(n, SAPPrintParametersDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPAllPrintParameters();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPAllPrintParameters sAPAllPrintParameters = (SAPAllPrintParameters)((Object)object);
            switch (n) {
                case 1: {
                    sAPAllPrintParameters.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("output_device");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PDEST, string);
                    break;
                }
                case 3: {
                    int n2 = resultSet.getInt("number_of_copies");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRCOP, n2);
                    break;
                }
                case 4: {
                    String string = resultSet.getString("spool_request_name");
                    if (string == null) break;
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PLIST, string);
                    break;
                }
                case 5: {
                    String string = resultSet.getString("cover_page_text");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRTXT, string);
                    break;
                }
                case 6: {
                    boolean bl = resultSet.getBoolean("print_immediately");
                    sAPAllPrintParameters.setBooleanField(SAPAllPrintParameters.PrintParameterField.PRIMM, bl);
                    break;
                }
                case 7: {
                    boolean bl = resultSet.getBoolean("delete_after_printing");
                    sAPAllPrintParameters.setBooleanField(SAPAllPrintParameters.PrintParameterField.PRREL, bl);
                    break;
                }
                case 8: {
                    boolean bl = resultSet.getBoolean("new_spool_request");
                    sAPAllPrintParameters.setBooleanField(SAPAllPrintParameters.PrintParameterField.PRNEW, bl);
                    break;
                }
                case 9: {
                    int n3 = resultSet.getInt("spool_retention_period");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PEXPI, n3);
                    break;
                }
                case 10: {
                    int n4 = resultSet.getInt("page_length_of_list");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.LINCT, n4);
                    break;
                }
                case 11: {
                    int n5 = resultSet.getInt("line_width_of_list");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.LINSZ, n5);
                    break;
                }
                case 12: {
                    String string = resultSet.getString("print_format");
                    if (string == null) break;
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PAART, string);
                    break;
                }
                case 13: {
                    boolean bl = resultSet.getBoolean("cover_page_selection");
                    sAPAllPrintParameters.setBooleanField(SAPAllPrintParameters.PrintParameterField.PRBIG, bl);
                    break;
                }
                case 14: {
                    String string = resultSet.getString("print_sap_cover_page");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRSAP, SAPAllPrintParameters.SAP_PRSAP_Setting.persistanceCodeToEnum(string));
                    break;
                }
                case 15: {
                    String string = resultSet.getString("recipient");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRREC, string);
                    break;
                }
                case 16: {
                    String string = resultSet.getString("cover_page_department");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRABT, string);
                    break;
                }
                case 17: {
                    String string = resultSet.getString("sap_authorization");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRBER, string);
                    break;
                }
                case 18: {
                    String string = resultSet.getString("name_of_spool_file");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRDSN, string);
                    break;
                }
                case 19: {
                    String string = resultSet.getString("type_of_spool_request");
                    if (string == null) break;
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PTYPE, string);
                    break;
                }
                case 20: {
                    int n6 = resultSet.getInt("archiving_mode");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.ARMOD, n6);
                    break;
                }
                case 21: {
                    int n7 = resultSet.getInt("spool_request_priority");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.PRIOT, n7);
                    break;
                }
                case 22: {
                    boolean bl = resultSet.getBoolean("print_host_cover_page");
                    sAPAllPrintParameters.setBooleanField(SAPAllPrintParameters.PrintParameterField.PRUNX, bl);
                    break;
                }
                case 23: {
                    String string = resultSet.getString("archive_object");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.SAP_OBJECT, string);
                    break;
                }
                case 24: {
                    String string = resultSet.getString("archive_document");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.AR_OBJECT, string);
                    break;
                }
                case 25: {
                    String string = resultSet.getString("archive_information");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.INFO, string);
                    break;
                }
                case 26: {
                    String string = resultSet.getString("archive_text");
                    sAPAllPrintParameters.setField(SAPAllPrintParameters.PrintParameterField.ARCTEXT, string);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

