/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobClass;
import com.helpsystems.enterprise.core.busobj.sap.SAPRecipientStatusSetting;
import com.helpsystems.enterprise.core.busobj.sap.SAPSpoolListRecipientType;
import com.helpsystems.enterprise.core.dm.sap.SAPABAPStepSetsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPJobDefinitionsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SAPJobDefinitionsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPJobDefinitionsDM {
    private static Logger logger = Logger.getLogger(SAPJobDefinitionsDMJdbc.class);
    private static final String objDesc = "SAP Executable Job";
    private static final String SAP_JOB_DEFINITIONS_TABLE = "sap_job_definitions";
    private static final String SAP_JOB_COMMANDS_TABLE = "sap_job_commands";
    private static final String COMMON_SQL_SELECT = "SELECT id, name, sap_abap_step_set_id, sap_system_environment_id, sap_job_class, sap_exec_target, sap_spool_list_recipient, sap_recipient_type, sap_deliver, sap_recipient_attributes, copy_spool_files, start_immediately, wait_for_child_jobs";
    private static final int NUMBER_OF_PASSES = 13;
    private String sapJobDefinitionsTable;
    private String sapJobCommandsTable;
    private SAPABAPStepSetsDM sapABAPStepSetsDM;

    public SAPJobDefinitionsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, SAPABAPStepSetsDM sAPABAPStepSetsDM) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPJobDefinitionsDM");
        this.sapABAPStepSetsDM = sAPABAPStepSetsDM;
        this.sapJobDefinitionsTable = string2 + "." + SAP_JOB_DEFINITIONS_TABLE;
        this.sapJobCommandsTable = string2 + "." + SAP_JOB_COMMANDS_TABLE;
    }

    @Override
    public SAPExecutableJob get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPExecutableJob sAPExecutableJob;
            SAPExecutableJobGenerator sAPExecutableJobGenerator = new SAPExecutableJobGenerator();
            String string = "SELECT id, name, sap_abap_step_set_id, sap_system_environment_id, sap_job_class, sap_exec_target, sap_spool_list_recipient, sap_recipient_type, sap_deliver, sap_recipient_attributes, copy_spool_files, start_immediately, wait_for_child_jobs FROM " + this.sapJobDefinitionsTable + " WHERE id=?";
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPExecutableJob sAPExecutableJob2 = sAPExecutableJob = (SAPExecutableJob)sAPExecutableJobGenerator.generateObject(resultSet);
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPExecutableJob2;
        }
        try {
            try {
                throw new NoDataException("SAP Executable Job not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public SAPExecutableJob getViaSAPJobID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPExecutableJob sAPExecutableJob;
            SAPExecutableJobGenerator sAPExecutableJobGenerator = new SAPExecutableJobGenerator();
            String string = "SELECT id, name, sap_abap_step_set_id, sap_system_environment_id, sap_job_class, sap_exec_target, sap_spool_list_recipient, sap_recipient_type, sap_deliver, sap_recipient_attributes, copy_spool_files, start_immediately, wait_for_child_jobs FROM " + this.sapJobDefinitionsTable + " WHERE id=?";
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPExecutableJob sAPExecutableJob2 = sAPExecutableJob = (SAPExecutableJob)sAPExecutableJobGenerator.generateObject(resultSet);
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPExecutableJob2;
        }
        try {
            try {
                throw new NoDataException("SAP Executable Job not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    @Override
    public long getSAPJobIDViaCommandID(long l) throws NoDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            String string = "SELECT sap_job_definition_id FROM " + this.sapJobCommandsTable + " WHERE command_id=?";
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            long l2 = resultSet.getLong("sap_job_definition_id");
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return l2;
        }
        try {
            try {
                throw new NoDataException("SAP Job Definition ID for command ID " + l + " not found in " + SAP_JOB_COMMANDS_TABLE);
            }
            catch (SQLException sQLException) {
                String string = "SQL error while retrieving the SAP Job Definition ID for command_id " + l + ".";
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPJobDefinitionsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class SAPExecutableJobGenerator
    extends AbstractBusObjGenerator {
        public SAPExecutableJobGenerator() {
            super(13, SAPJobDefinitionsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPExecutableJob();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPExecutableJob sAPExecutableJob = (SAPExecutableJob)object;
            switch (n) {
                case 1: {
                    sAPExecutableJob.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPExecutableJob.setJobName(resultSet.getString("name"));
                    break;
                }
                case 3: {
                    long l = resultSet.getLong("sap_abap_step_set_id");
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        SAPABAPStepSet sAPABAPStepSet = SAPJobDefinitionsDMJdbc.this.sapABAPStepSetsDM.get(l, connection);
                        sAPExecutableJob.setAbapStepSet(sAPABAPStepSet);
                        break;
                    }
                    catch (Exception exception) {
                        String string = "Error while retrieving the SAP ABAP Step Set.";
                        logger.error((Object)string, (Throwable)exception);
                        throw new RuntimeException(string, exception);
                    }
                }
                case 4: {
                    sAPExecutableJob.setSAPSystemEnvironmentID(resultSet.getInt("sap_system_environment_id"));
                    break;
                }
                case 5: {
                    String string = resultSet.getString("sap_job_class");
                    SAPJobClass sAPJobClass = SAPJobClass.persistanceCodeToEnum(string);
                    sAPExecutableJob.setSapJobClass(sAPJobClass);
                    break;
                }
                case 6: {
                    sAPExecutableJob.setSapExecTarget(resultSet.getString("sap_exec_target"));
                    break;
                }
                case 7: {
                    sAPExecutableJob.setSapSpoolListRecipient(resultSet.getString("sap_spool_list_recipient"));
                    break;
                }
                case 8: {
                    String string = SAPSpoolListRecipientType.persistanceCodeToEnum(resultSet.getString("sap_recipient_type")).persistanceCode();
                    sAPExecutableJob.setSapSpoolListRecipientType(string);
                    break;
                }
                case 9: {
                    String string = resultSet.getString("sap_deliver");
                    if (string == null) {
                        string = "";
                    }
                    string = SAPRecipientStatusSetting.persistanceCodeToEnum(string).persistanceCode();
                    sAPExecutableJob.setDeliverStatusSetting(string);
                    break;
                }
                case 10: {
                    sAPExecutableJob.setSapRecipientAttributes(resultSet.getString("sap_recipient_attributes"));
                    break;
                }
                case 11: {
                    sAPExecutableJob.setCopySpoolFiles(resultSet.getBoolean("copy_spool_files"));
                    break;
                }
                case 12: {
                    sAPExecutableJob.setStartImmediately(resultSet.getBoolean("start_immediately"));
                    break;
                }
                case 13: {
                    sAPExecutableJob.setWaitForChildJobs(resultSet.getBoolean("wait_for_child_jobs"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

