/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.sap;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.sap.SAPEvent;
import com.helpsystems.enterprise.core.dm.sap.SAPEventsDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SAPEventsDMJdbc
extends AbstractHelpingDatabaseManager
implements SAPEventsDM {
    private static final String objDesc = "SAP Event";
    private static final String SAP_EVENTS_TABLE = "sap_events";
    private String sapEventsTable;

    public SAPEventsDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SAPEventsDM");
        this.sapEventsTable = string2 + "." + SAP_EVENTS_TABLE;
    }

    @Override
    public SAPEvent get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block8: {
            SAPEvent sAPEvent;
            block10: {
                block9: {
                    SAPEvent sAPEvent2;
                    SAPEventGenerator sAPEventGenerator = new SAPEventGenerator();
                    String string = "SELECT id, sap_system_environment_id, sap_event_identifier, sap_event_parameters FROM " + this.sapEventsTable + " WHERE id=?";
                    connection2 = connection;
                    preparedStatement = null;
                    resultSet = null;
                    if (connection2 == null) {
                        connection2 = super.getConnectionOrFail();
                    }
                    preparedStatement = this.getDefaultPreparedStmt(string, connection2);
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) break block8;
                    sAPEvent = sAPEvent2 = (SAPEvent)sAPEventGenerator.generateObject(resultSet);
                    if (connection != null) break block9;
                    SAPEventsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, (ResultSet)resultSet);
                    break block10;
                }
                SAPEventsDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
            return sAPEvent;
        }
        try {
            try {
                throw new NoDataException("SAP Event not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            if (connection == null) {
                SAPEventsDMJdbc.closeEm((Connection)connection2, (Statement)preparedStatement, resultSet);
            } else {
                SAPEventsDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
            }
            throw throwable;
        }
    }

    @Override
    public SAPEvent getViaCommandID(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            SAPEvent sAPEvent;
            SAPEventGenerator sAPEventGenerator = new SAPEventGenerator();
            String string = "SELECT id, sap_system_environment_id, sap_event_identifier, sap_event_parameters FROM " + this.sapEventsTable + " WHERE command_id=?";
            wrappedConnection = super.getConnectionOrFail();
            preparedStatement = null;
            resultSet = null;
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            SAPEvent sAPEvent2 = sAPEvent = (SAPEvent)sAPEventGenerator.generateObject(resultSet);
            SAPEventsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return sAPEvent2;
        }
        try {
            try {
                throw new NoDataException("SAP Event not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for command_id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            SAPEventsDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
            throw throwable;
        }
    }

    private class SAPEventGenerator
    extends AbstractBusObjGenerator {
        public SAPEventGenerator() {
            super(4, SAPEventsDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new SAPEvent();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            SAPEvent sAPEvent = (SAPEvent)object;
            switch (n) {
                case 1: {
                    sAPEvent.setOID(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    sAPEvent.setSAPSystemEnvironmentID(resultSet.getInt("sap_system_environment_id"));
                    break;
                }
                case 3: {
                    String string = resultSet.getString("sap_event_identifier");
                    if (string == null) {
                        string = "";
                    }
                    sAPEvent.setName(string);
                    break;
                }
                case 4: {
                    sAPEvent.setEventParameters(resultSet.getString("sap_event_parameters"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

