/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.rbtschedule;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobType;
import com.helpsystems.enterprise.core.busobj.rbtschedule.SkybotJob;
import com.helpsystems.enterprise.core.dm.rbtschedule.SkybotServerHelperDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SkybotServerHelperDMJdbc
extends AbstractHelpingDatabaseManager
implements SkybotServerHelperDM {
    private final String jobTable;
    private static final String JOB_TABLE = "jobs";

    public SkybotServerHelperDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.SkybotServerHelper");
        this.jobTable = string2 + "." + JOB_TABLE;
    }

    @Override
    public List<String> getNotifiableEventStatuses(JobType jobType) {
        ValidationHelper.checkForNull((String)"Job Type", (Object)jobType);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (jobType == JobType.JOB || jobType == JobType.SUITE || jobType == JobType.SUITE_MEMBER) {
            arrayList.add(PrereqStatusType.COMPLETED.persistanceCode());
            arrayList.add(PrereqStatusType.FAILED.persistanceCode());
            arrayList.add(PrereqStatusType.CANCELED.persistanceCode());
            arrayList.add(PrereqStatusType.RUNNING.persistanceCode());
            arrayList.add(PrereqStatusType.SKIPPED.persistanceCode());
            if (jobType != JobType.SUITE) {
                arrayList.add(PrereqStatusType.RUNNING.persistanceCode());
                arrayList.add(PrereqStatusType.CONDITION_RETRY_WAIT.persistanceCode());
            }
        }
        return arrayList;
    }

    @Override
    public List<SkybotJob> getEventList(JobType jobType) throws DataException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Job Type", (Object)jobType);
        ArrayList<SkybotJob> arrayList = new ArrayList<SkybotJob>();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = super.getConnectionOrFail();
        String string = "SELECT id, name, job_type FROM " + this.jobTable + " WHERE job_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        ResultSet resultSet = null;
        try {
            switch (jobType) {
                case JOB: {
                    preparedStatement.setInt(1, JobType.JOB.persistanceCode());
                    break;
                }
                case SUITE: {
                    preparedStatement.setInt(1, JobType.SUITE.persistanceCode());
                    break;
                }
                case SUITE_MEMBER: {
                    preparedStatement.setInt(1, JobType.SUITE_MEMBER.persistanceCode());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Job  Type {0} is not supported by this method.", (Object[])new Object[]{jobType}));
                }
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                SkybotJob skybotJob = new SkybotJob();
                skybotJob.setType(JobType.persistanceCodeToEnum(resultSet.getInt("job_type")));
                skybotJob.setId(resultSet.getLong("id"));
                skybotJob.setName(resultSet.getString("name"));
                arrayList.add(skybotJob);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the job list for job type {0}", (Object[])new Object[]{jobType});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                SkybotServerHelperDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        SkybotServerHelperDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return arrayList;
    }

    @Override
    public List<Integer> getNotifiableEventTypeList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(JobType.JOB.persistanceCode());
        arrayList.add(JobType.SUITE.persistanceCode());
        arrayList.add(JobType.SUITE_MEMBER.persistanceCode());
        return arrayList;
    }
}

