/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.oracle;

import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.oracle.OracleConcurrentRequest;
import com.helpsystems.enterprise.core.busobj.oracle.OracleParameter;
import com.helpsystems.enterprise.core.dm.oracle.OracleCRParametersDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleCRParametersDMJdbc
extends AbstractHelpingDatabaseManager
implements OracleCRParametersDM {
    private static final String objDesc = "Oracle Concurrent Request Parameter";
    private static final String ORACLE_CR_PARAMETERS_TABLE = "oracle_cr_parameters";
    private static final String COMMON_SQL_SELECT = "SELECT line_number, name, value";
    private String oracleCRParametersTable;

    public OracleCRParametersDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.OracleCRParametersDM");
        this.oracleCRParametersTable = string2 + "." + ORACLE_CR_PARAMETERS_TABLE;
    }

    @Override
    public void loadOracleParametersForRequest(OracleConcurrentRequest oracleConcurrentRequest, Connection connection) throws NoDataException, ResourceUnavailableException, BadDataException {
        String string = "SELECT line_number, name, value FROM " + this.oracleCRParametersTable + " WHERE oracle_concurrent_request_id=? ORDER BY line_number";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        ResultSet resultSet = null;
        try {
            preparedStatement.setLong(1, oracleConcurrentRequest.getOID());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                OracleParameter oracleParameter = new OracleParameter();
                oracleParameter.setLineNumber(resultSet.getInt("line_number"));
                oracleParameter.setName(resultSet.getString("name"));
                oracleParameter.setValue(resultSet.getString("value"));
                oracleConcurrentRequest.addToParameterList(oracleParameter);
            }
        }
        catch (SQLException sQLException) {
            try {
                String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for oracle concurrent request id {1}.", (Object[])new Object[]{objDesc, Long.toString(oracleConcurrentRequest.getOID())});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                OracleCRParametersDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        OracleCRParametersDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }
}

