/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.ReactivityDateObject;
import com.helpsystems.enterprise.core.busobj.TimeHelper;
import com.helpsystems.enterprise.core.busobj.WindowEndOption;
import com.helpsystems.enterprise.core.busobj.WindowStartOption;
import com.helpsystems.enterprise.core.dm.ReactivityDateObjectDM;
import com.helpsystems.enterprise.core.scheduler.DateObjectDM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class ReactivityDateObjectDMJdbc
extends AbstractDatabaseManager
implements ReactivityDateObjectDM {
    private static final String description = "Reactivity Date Object";
    private String table;
    ReactivityDateObjectGenerator boGenerator = new ReactivityDateObjectGenerator();
    DateObjectDM dateObjectDM;

    public ReactivityDateObjectDMJdbc(String string, String string2, DateObjectDM dateObjectDM) throws ResourceUnavailableException {
        super(string);
        this.table = string2 + "." + "REACTIVITY_DATE_OBJECTS";
        this.setName("ENTERPRISE.ReactivityDateObjectDM");
        this.dateObjectDM = dateObjectDM;
    }

    private String getSql() {
        return "SELECT id, job_id, date_object_id, react_after, react_before, react_after_option, react_before_option FROM " + this.table;
    }

    @Override
    public ReactivityDateObject[] get(long l) throws ResourceUnavailableException, DataException {
        String string = this.getSql() + " where job_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ReactivityDateObject[] reactivityDateObjectArray;
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<ReactivityDateObject[]> arrayList = new ArrayList<ReactivityDateObject[]>();
            while (resultSet.next()) {
                reactivityDateObjectArray = (ReactivityDateObject[])this.boGenerator.generateObject(resultSet);
                arrayList.add(reactivityDateObjectArray);
            }
            if (arrayList.size() > 1) {
                throw new IllegalArgumentException("More than one object was loaded for Job ID " + l);
            }
            reactivityDateObjectArray = new ReactivityDateObject[]{};
            ReactivityDateObject[] reactivityDateObjectArray2 = reactivityDateObjectArray = arrayList.toArray(reactivityDateObjectArray);
            return reactivityDateObjectArray2;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{description, Long.toString(l)});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class ReactivityDateObjectGenerator
    extends AbstractBusObjGenerator {
        public ReactivityDateObjectGenerator() {
            super(7, ReactivityDateObjectDMJdbc.description);
        }

        protected Object constructObject() {
            return new ReactivityDateObject();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ReactivityDateObject reactivityDateObject = (ReactivityDateObject)object;
            switch (n) {
                case 1: {
                    reactivityDateObject.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    reactivityDateObject.setJobID(resultSet.getLong("job_id"));
                    break;
                }
                case 3: {
                    long l = resultSet.getLong("date_object_id");
                    try {
                        reactivityDateObject.setDateObject(ReactivityDateObjectDMJdbc.this.dateObjectDM.get(l));
                    }
                    catch (NoDataException noDataException) {
                        reactivityDateObject.setDateObject(null);
                    }
                    break;
                }
                case 4: {
                    reactivityDateObject.setStartTime(resultSet.getInt("react_after"));
                    break;
                }
                case 5: {
                    reactivityDateObject.setEndTime(resultSet.getInt("react_before"));
                    if (!resultSet.wasNull()) break;
                    reactivityDateObject.setEndTime(TimeHelper.END_OF_DAY_TIME);
                    break;
                }
                case 6: {
                    int n2 = resultSet.getInt("react_after_option");
                    reactivityDateObject.setStartOption(WindowStartOption.persistanceCodeToEnum(n2));
                    break;
                }
                case 7: {
                    int n3 = resultSet.getInt("react_before_option");
                    reactivityDateObject.setEndOption(WindowEndOption.persistanceCodeToEnum(n3));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

