/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.PrereqEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEventSource;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SendStatusEventType;
import com.helpsystems.enterprise.core.scheduler.PrereqEventList;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PrereqEventListJdbc
implements PrereqEventList {
    private static final Logger logger = Logger.getLogger(PrereqEventListJdbc.class);
    private Connection con;
    private PreparedStatement stmt;
    private ResultSet rs;

    PrereqEventListJdbc(PreparedStatement preparedStatement) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Prepared Statement", (Object)preparedStatement);
        this.stmt = preparedStatement;
        this.con = this.extractConnectionFromStmt();
        this.rs = this.runQuery();
    }

    @Override
    public boolean next() throws ResourceUnavailableException {
        try {
            return this.rs.next();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while positioning to the next item in the list.";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    @Override
    public PrereqEvent getPrereqEvent() throws ResourceUnavailableException {
        try {
            PrereqEvent prereqEvent = new PrereqEvent();
            prereqEvent.setId(this.rs.getLong("id"));
            int n = this.rs.getInt("event_type");
            prereqEvent.setType(PrereqEventType.persistanceCodeToEnum(n));
            prereqEvent.setTimestamp(this.rs.getLong("prereq_timestamp_utc"));
            prereqEvent.setHistoryOID(this.rs.getLong("history_id"));
            String string = this.rs.getString("event_status");
            prereqEvent.setPrereqStatus(PrereqStatusType.persistanceCodeToEnum(string));
            prereqEvent.setEventSource(PrereqEventSource.persistanceCodeToEnum(this.rs.getInt("event_source")));
            prereqEvent.setSendStatusEventType(SendStatusEventType.persistanceCodeToEnum(this.rs.getInt("user_event_type")));
            prereqEvent.setUserEventDepID(this.rs.getLong("user_event_dep_id"));
            prereqEvent.setUserEventObjectID(this.rs.getLong("user_event_obj_id"));
            prereqEvent.setUserEventAttr(this.rs.getString("user_event_attr"));
            prereqEvent.setUserEventDepAgentID(this.rs.getLong("user_event_dep_agent_id"));
            prereqEvent.setUserEventPrereqAgentID(this.rs.getLong("user_event_prereq_agent_id"));
            prereqEvent.setHistoryJobID(this.rs.getLong("hist_job_id"));
            prereqEvent.setHistoryJobName(this.rs.getString("hist_job_name"));
            prereqEvent.setHistoryAgentID(this.rs.getLong("hist_agent_id"));
            prereqEvent.setHistoryAgentName(this.rs.getString("hist_agent_name"));
            prereqEvent.setHistoryScheduledTimeUTC(this.rs.getLong("hist_scheduled_time_utc"));
            prereqEvent.setHistoryJobSuiteMemberID(this.rs.getLong("hist_job_suite_member_id"));
            prereqEvent.setHistoryMovedFromScheduledDateTime(this.rs.getLong("hist_moved_from_scheduled_date_time"));
            prereqEvent.setDoneMarkingStatuses(this.rs.getBoolean("marked_statuses"));
            return prereqEvent;
        }
        catch (SQLException sQLException) {
            this.close();
            throw new ResourceUnavailableException("SQL Exception loading Prereq Event.", (Throwable)sQLException);
        }
    }

    @Override
    public void reload() throws ResourceUnavailableException {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.rs = null;
        }
        this.rs = this.runQuery();
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.stmt != null) {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private ResultSet runQuery() throws ResourceUnavailableException {
        try {
            return this.stmt.executeQuery();
        }
        catch (SQLException sQLException) {
            String string = "SQL error while retrieving the scheduled jobs list. ";
            logger.debug((Object)string, (Throwable)sQLException);
            this.close();
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
    }

    private Connection extractConnectionFromStmt() throws ResourceUnavailableException {
        try {
            return this.stmt.getConnection();
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            logger.debug((Object)"Cannot retrieve Connection from Statement.", (Throwable)sQLException);
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException3) {
                sQLException2 = sQLException3;
                logger.debug((Object)"SQL error while trying to close the Statement.", (Throwable)sQLException3);
            }
            throw new ResourceUnavailableException("SQL error while trying to build the list.", (Throwable)sQLException2);
        }
    }
}

