/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.access.jdbc.PrereqEventListJdbc;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.busobj.PrereqEventSource;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.SNMPTrapEvent;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.busobj.SendStatusEventType;
import com.helpsystems.enterprise.core.busobj.rbtschedule.RemoteEventHistory;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventHistory;
import com.helpsystems.enterprise.core.dm.PrereqEventDM;
import com.helpsystems.enterprise.core.scheduler.PrereqEventList;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class PrereqEventDMJdbc
extends AbstractDatabaseManager
implements PrereqEventDM {
    private static final Logger logger = Logger.getLogger(PrereqEventDMJdbc.class);
    private static final String TABLE = "prereq_events";
    private String table;

    public PrereqEventDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"ManagerName", (Object)string3);
        this.table = string2 + "." + TABLE;
        this.setName(string3);
    }

    @Override
    public int delete(long l) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.table + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            int n;
            preparedStatement.setLong(1, l);
            int n2 = n = preparedStatement.executeUpdate();
            return n2;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error deleting Prereq Event {0}.", (Object[])new Object[]{l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void generateEvent(JobHistory jobHistory, PrereqEventType prereqEventType) throws ResourceUnavailableException, DataException {
        long l = 0L;
        if (jobHistory.getStatusCode() == JobStatusCode.COMPLETED || jobHistory.getStatusCode() == JobStatusCode.FAILED || jobHistory.getStatusCode() == JobStatusCode.CANCELED) {
            l = jobHistory.getServerEndedTime();
        } else if (jobHistory.getStatusCode() == JobStatusCode.RUNNING) {
            l = jobHistory.getServerRunningTime();
        } else if (jobHistory.getStatusCode() == JobStatusCode.CONDITION_CHECK) {
            l = System.currentTimeMillis();
        } else if (jobHistory.getStatusCode() == JobStatusCode.CONDITION_RETRY_WAIT) {
            l = System.currentTimeMillis();
        } else if (jobHistory.getStatusCode() == JobStatusCode.SUBMITTED) {
            l = jobHistory.getServerSubmittedTime();
        } else if (jobHistory.getStatusCode() == JobStatusCode.SKIPPED) {
            l = jobHistory.getServerInitiatedTime();
        }
        this.insert(null, l, prereqEventType, jobHistory.getId(), this.mapJobStatus(jobHistory.getStatusCode()), null, jobHistory);
    }

    private PrereqStatusType mapJobStatus(JobStatusCode jobStatusCode) {
        switch (jobStatusCode) {
            case SUBMITTED: {
                return PrereqStatusType.SUBMITTED;
            }
            case CONDITION_CHECK: {
                return PrereqStatusType.CONDITION_CHECK;
            }
            case CONDITION_RETRY_WAIT: {
                return PrereqStatusType.CONDITION_RETRY_WAIT;
            }
            case RUNNING: {
                return PrereqStatusType.RUNNING;
            }
            case COMPLETED: {
                return PrereqStatusType.COMPLETED;
            }
            case FAILED: {
                return PrereqStatusType.FAILED;
            }
            case CANCELED: {
                return PrereqStatusType.CANCELED;
            }
            case SKIPPED: {
                return PrereqStatusType.SKIPPED;
            }
        }
        logger.debug((Object)("Job Status Code does not map to a Prereq Status: " + jobStatusCode));
        return PrereqStatusType.BLANK;
    }

    @Override
    public void generateEvent(Connection connection, AgentEventHistoryInfo agentEventHistoryInfo) throws ResourceUnavailableException, DataException {
        if (agentEventHistoryInfo.getSendStatusEvent() != null) {
            SendStatusEvent sendStatusEvent = agentEventHistoryInfo.getSendStatusEvent();
            this.insert(connection, sendStatusEvent.getTimeStamp(), sendStatusEvent.getPrereqEventType(), agentEventHistoryInfo.getOID(), sendStatusEvent.getPrereqStatusType(), sendStatusEvent, null);
        } else {
            this.insert(connection, agentEventHistoryInfo.getServerTimeStamp(), PrereqEventType.AGENT_EVENT, agentEventHistoryInfo.getOID(), PrereqStatusType.OCCURRED, null, null);
        }
    }

    @Override
    public void generateEvent(JobMonitorEvent jobMonitorEvent) throws ResourceUnavailableException, DataException {
        PrereqStatusType prereqStatusType = PrereqStatusType.BLANK;
        switch (jobMonitorEvent.getEventType()) {
            case 3: {
                prereqStatusType = PrereqStatusType.LATE_START;
                break;
            }
            case 2: {
                prereqStatusType = PrereqStatusType.OVER_RUN;
                break;
            }
            case 1: {
                prereqStatusType = PrereqStatusType.UNDER_RUN;
                break;
            }
            default: {
                logger.debug((Object)("Invalid Job Monitor Event Type: " + jobMonitorEvent.getEventType()));
            }
        }
        PrereqEventType prereqEventType = jobMonitorEvent.determinePrereqEventType();
        this.insert(null, jobMonitorEvent.getTimeDetected(), prereqEventType, jobMonitorEvent.getID(), prereqStatusType, null, null);
    }

    @Override
    public void generateEvent(SNMPTrapEvent sNMPTrapEvent) throws ResourceUnavailableException, DataException {
        this.insert(null, sNMPTrapEvent.getTimeDetected(), PrereqEventType.SNMP_TRAP_EVENT, sNMPTrapEvent.getID(), PrereqStatusType.OCCURRED, null, null);
    }

    @Override
    public void generateEvent(Connection connection, SAPEventHistory sAPEventHistory) throws ResourceUnavailableException, DataException {
        if (sAPEventHistory.getSendStatusEvent() != null) {
            SendStatusEvent sendStatusEvent = sAPEventHistory.getSendStatusEvent();
            this.insert(null, sAPEventHistory.getEventTimestampUTC(), sendStatusEvent.getPrereqEventType(), sAPEventHistory.getOID(), sendStatusEvent.getPrereqStatusType(), sendStatusEvent, null);
        } else {
            this.insert(null, sAPEventHistory.getEventTimestampUTC(), PrereqEventType.SAP_MONITOR_EVENT, sAPEventHistory.getOID(), PrereqStatusType.OCCURRED, null, null);
        }
    }

    @Override
    public void generateEvent(SendStatusEvent sendStatusEvent) throws ResourceUnavailableException, DataException {
        this.insert(null, sendStatusEvent.getTimeStamp(), sendStatusEvent.getPrereqEventType(), 0L, sendStatusEvent.getPrereqStatusType(), sendStatusEvent, null);
    }

    @Override
    public void generateEvent(RemoteEventHistory remoteEventHistory) throws ResourceUnavailableException, DataException {
        if (remoteEventHistory.getSendStatusEvent() != null) {
            SendStatusEvent sendStatusEvent = remoteEventHistory.getSendStatusEvent();
            this.insert(null, remoteEventHistory.getServerTime(), sendStatusEvent.getPrereqEventType(), remoteEventHistory.getId(), sendStatusEvent.getPrereqStatusType(), sendStatusEvent, null);
        } else {
            this.insert(null, remoteEventHistory.getServerTime(), PrereqEventType.REMOTE_EVENT, remoteEventHistory.getId(), remoteEventHistory.getStatus(), null, null);
        }
    }

    private void insert(Connection connection, long l, PrereqEventType prereqEventType, long l2, PrereqStatusType prereqStatusType, SendStatusEvent sendStatusEvent, JobHistory jobHistory) throws NotSavedException, ResourceUnavailableException {
        long l3 = 0L;
        long l4 = l;
        if (l4 == 0L) {
            l4 = System.currentTimeMillis();
        }
        String string = "INSERT INTO " + this.table + " (prereq_timestamp_utc, event_type, history_id, event_status, " + "event_source, user_event_type, user_event_attr, " + "user_event_dep_id, user_event_obj_id, " + "user_event_dep_agent_id, user_event_prereq_agent_id, " + "hist_job_id, hist_job_name, " + "hist_agent_id, hist_agent_name, " + "hist_scheduled_time_utc, hist_moved_from_scheduled_date_time, " + "hist_job_suite_member_id" + ") VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Connection connection2 = connection == null ? this.getConnectionOrFail() : connection;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
        try {
            preparedStatement.setLong(1, l4);
            preparedStatement.setInt(2, prereqEventType.persistanceCode());
            preparedStatement.setLong(3, l2);
            if (prereqStatusType != null) {
                preparedStatement.setString(4, prereqStatusType.persistanceCode());
            } else {
                preparedStatement.setNull(4, 1);
            }
            if (sendStatusEvent == null) {
                preparedStatement.setInt(5, PrereqEventSource.SYSTEM.persistanceCode());
                preparedStatement.setInt(6, SendStatusEventType.NOT_APPLICABLE.persistanceCode());
                preparedStatement.setNull(7, 1);
                preparedStatement.setLong(8, 0L);
                preparedStatement.setLong(9, 0L);
                preparedStatement.setLong(10, 0L);
                preparedStatement.setLong(11, 0L);
            } else {
                preparedStatement.setInt(5, PrereqEventSource.USER.persistanceCode());
                preparedStatement.setInt(6, sendStatusEvent.getSendStatusEventType().persistanceCode());
                preparedStatement.setString(7, "");
                preparedStatement.setLong(8, sendStatusEvent.getDependencyID());
                l3 = sendStatusEvent.getSendStatusEventType() == SendStatusEventType.SEND_JOB_CHANGE_EVENT ? sendStatusEvent.getDepJobID() : sendStatusEvent.getPrereqObjectID();
                preparedStatement.setLong(9, l3);
                preparedStatement.setLong(10, sendStatusEvent.getDepAgentID());
                preparedStatement.setLong(11, sendStatusEvent.getPrereqAgentID());
            }
            if (jobHistory == null) {
                preparedStatement.setLong(12, 0L);
                preparedStatement.setNull(13, 1);
                preparedStatement.setLong(14, 0L);
                preparedStatement.setNull(15, 1);
                preparedStatement.setLong(16, 0L);
                preparedStatement.setLong(17, 0L);
                preparedStatement.setLong(18, 0L);
            } else {
                preparedStatement.setLong(12, jobHistory.getJobID());
                preparedStatement.setString(13, jobHistory.getJobName());
                preparedStatement.setLong(14, jobHistory.getAgentID());
                preparedStatement.setString(15, jobHistory.getAgentName());
                preparedStatement.setLong(16, jobHistory.getScheduledTime());
                preparedStatement.setLong(17, jobHistory.getMovedFromScheduledDateTime());
                preparedStatement.setLong(18, jobHistory.getJobSuiteMemberID());
            }
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                String string2 = "Unable to add the Prereq Event.";
                throw new NotSavedException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while inserting the Prereq Event.";
            logger.debug((Object)string3, (Throwable)sQLException);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            PrereqEventDMJdbc.closeEm(null, (Statement)preparedStatement, null);
            if (connection == null) {
                PrereqEventDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    @Override
    public PrereqEventList getPrereqEventList() throws ResourceUnavailableException {
        String string = "SELECT id, prereq_timestamp_utc, event_type, history_id, event_status, event_source, user_event_type, user_event_attr, user_event_dep_id, user_event_obj_id, user_event_dep_agent_id, user_event_prereq_agent_id, hist_job_id, hist_job_name, hist_agent_id, hist_agent_name, hist_scheduled_time_utc, hist_moved_from_scheduled_date_time, hist_job_suite_member_id, marked_statuses FROM " + this.table + " ORDER BY prereq_timestamp_utc";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        return new PrereqEventListJdbc(preparedStatement);
    }

    @Override
    public void updateMarkedStatuses(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.table + " SET marked_statuses = TRUE WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error updating Prereq Event {0}.", (Object[])new Object[]{l});
            logger.debug((Object)string2, (Throwable)sQLException);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }
}

