/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EmailContact;
import com.helpsystems.enterprise.core.busobj.NotificationList;
import com.helpsystems.enterprise.core.busobj.User;
import com.helpsystems.enterprise.core.dm.EmailContactDM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.UserDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class NotificationListDMJdbc
extends AbstractDatabaseManager
implements NotificationListDM {
    private static final String objDesc = "Notification List";
    private static Logger logger = Logger.getLogger(NotificationListDMJdbc.class);
    private static final String NOTIFICATION_LISTS_TABLE = "notification_lists";
    private String notificationListsTable;
    private static final String NOTIFICATION_LIST_USERS_TABLE = "notification_list_users";
    private String notificationListUsersTable;
    private UserDM userDM;
    private EmailContactDM emailContactDM;

    public NotificationListDMJdbc(String string, String string2, UserDM userDM, EmailContactDM emailContactDM) {
        super(string);
        this.setName("ENTERPRISE.NotificationListDM");
        this.notificationListsTable = string2 + "." + NOTIFICATION_LISTS_TABLE;
        this.notificationListUsersTable = string2 + "." + NOTIFICATION_LIST_USERS_TABLE;
        this.userDM = userDM;
        this.emailContactDM = emailContactDM;
    }

    public NotificationListDMJdbc(String string, String string2, UserDM userDM) {
        this(string, string2, userDM, null);
    }

    @Override
    public NotificationList get(long l) throws NoDataException, BadDataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public NotificationList get(long l, Connection connection) throws NoDataException, BadDataException, ResourceUnavailableException {
        boolean bl = false;
        Connection connection2 = null;
        NotificationListGenerator notificationListGenerator = new NotificationListGenerator();
        String string = "SELECT id, name, public_list FROM " + this.notificationListsTable + " WHERE id=?";
        try {
            if (connection == null) {
                connection2 = this.getConnection();
            } else {
                connection2 = connection;
                bl = true;
            }
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            Object object = preparedStatement.executeQuery();
            if (object.next()) {
                NotificationList notificationList;
                NotificationList notificationList2 = notificationList = (NotificationList)((Object)notificationListGenerator.generateObject((ResultSet)object));
                return notificationList2;
            }
            try {
                throw new NoDataException("Notification List not found.");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                NotificationListDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
    }

    private void loadUsers(NotificationList notificationList, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, notify_contact_id, notify_contact_type  FROM " + this.notificationListUsersTable + " WHERE notification_list_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, notificationList.getOid());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    long l = resultSet.getLong("notify_contact_id");
                    String string2 = resultSet.getString("notify_contact_type");
                    if (string2 != null && string2.equalsIgnoreCase("user")) {
                        notificationList.addUser(this.getUser(l, connection));
                        continue;
                    }
                    if (string2 != null && string2.equalsIgnoreCase("emailcontact")) {
                        EmailContact emailContact = this.getEmailContact(l, connection);
                        if (emailContact == null || emailContact.getEmailAddress() == null) continue;
                        notificationList.addEmailContact(emailContact.getEmailAddress());
                        continue;
                    }
                    logger.debug((Object)("Unsupported notify type was found: " + string2));
                }
                catch (Exception exception) {
                    String string3 = "Error while retrieving the users.";
                    logger.debug((Object)string3, (Throwable)exception);
                }
            }
            notificationList.sortUserListByName();
        }
        catch (Exception exception) {
            String string4 = "Error while retrieving the users.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new RuntimeException(string4, exception);
        }
    }

    private User getUser(long l, Connection connection) throws SQLException, DataException, ResourceUnavailableException {
        return this.userDM.get(l, connection);
    }

    private EmailContact getEmailContact(long l, Connection connection) throws SQLException, DataException, ResourceUnavailableException {
        if (this.emailContactDM == null) {
            return null;
        }
        return this.emailContactDM.get(l, connection);
    }

    @Override
    public NotificationList getNotificationListByName(String string) throws NoDataException, BadDataException, ResourceUnavailableException {
        boolean bl = false;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string2 = "SELECT id, name, public_list FROM " + this.notificationListsTable + " WHERE name=?";
        try {
            wrappedConnection = this.getConnection();
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2, (Connection)wrappedConnection);
            preparedStatement.setString(1, string);
            Object object = preparedStatement.executeQuery();
            NotificationListGenerator notificationListGenerator = new NotificationListGenerator();
            if (object.next()) {
                NotificationList notificationList;
                NotificationList notificationList2 = notificationList = (NotificationList)((Object)notificationListGenerator.generateObject((ResultSet)object));
                return notificationList2;
            }
            try {
                throw new NoDataException("Notification List not found.");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for name {1}.", (Object[])new Object[]{objDesc, string});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                NotificationListDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            }
        }
    }

    private class NotificationListGenerator
    extends AbstractBusObjGenerator {
        public NotificationListGenerator() {
            super(4, NotificationListDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new NotificationList();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            NotificationList notificationList = (NotificationList)((Object)object);
            switch (n) {
                case 1: {
                    notificationList.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    Connection connection = resultSet.getStatement().getConnection();
                    NotificationListDMJdbc.this.loadUsers(notificationList, connection);
                    break;
                }
                case 3: {
                    notificationList.setPubliList(resultSet.getBoolean("public_list"));
                    break;
                }
                case 4: {
                    notificationList.setName(resultSet.getString("name"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

