/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo_Validated;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class EnterpriseLicenseInfoAMJdbc
extends AbstractDatabaseManager
implements EnterpriseLicenseInfoAM {
    private static final Logger logger = Logger.getLogger(EnterpriseLicenseInfoAMJdbc.class);
    private static final String TABLE = "licenses";
    private String table;

    public EnterpriseLicenseInfoAMJdbc(String string, String string2) throws ResourceUnavailableException {
        super(string);
        this.setName("ENTERPRISE.EnterpriseLicenseInfoAM");
        this.table = string2 + "." + TABLE;
    }

    @Override
    public String getLastNotifiedDate(int n) throws ActionFailedException, ResourceUnavailableException {
        String string = null;
        String string2 = "SELECT notify_date FROM " + this.table + " WHERE license_type=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    string = resultSet.getString("notify_date");
                }
                catch (Exception exception) {
                    String string3 = "Error while retrieving the last notification date.";
                    logger.debug((Object)string3, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            String string4 = "Error while retrieving the last notification date.";
            logger.debug((Object)string4, (Throwable)exception);
            throw new RuntimeException(string4, exception);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
        return string;
    }

    @Override
    public EnterpriseLicenseInfo getLicenseInfo() throws ActionFailedException, ResourceUnavailableException {
        EnterpriseLicenseInfo enterpriseLicenseInfo = new EnterpriseLicenseInfo();
        EnterpriseProductLicense enterpriseProductLicense = null;
        EnterpriseProductLicense enterpriseProductLicense2 = null;
        EnterpriseProductLicense[] enterpriseProductLicenseArray = this.getAllPrimaryLicenses();
        enterpriseLicenseInfo.setAllPrimaryLicenses(enterpriseProductLicenseArray);
        TreeSet<EnterpriseProductLicense> treeSet = this.getLicenseSetFromArray(enterpriseProductLicenseArray);
        enterpriseProductLicense = this.getMasterLicenseCode(treeSet);
        try {
            enterpriseProductLicense2 = this.getTrialLicenseCode();
        }
        catch (NoDataException noDataException) {
            String string = "Temporary license code does not exist.";
            logger.debug((Object)string);
        }
        catch (Exception exception) {
            String string = "Error while retrieving the temporary license code.";
            logger.debug((Object)string, (Throwable)exception);
        }
        if (enterpriseProductLicense2 == null) {
            try {
                enterpriseProductLicense2 = new EnterpriseProductLicense("");
                logger.debug((Object)"Setting blank Temporary license key - Unlicensed.");
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        enterpriseLicenseInfo.setPrimaryLicense(enterpriseProductLicense);
        enterpriseLicenseInfo.setTrialLicense(enterpriseProductLicense2);
        return enterpriseLicenseInfo;
    }

    private TreeSet<EnterpriseProductLicense> getLicenseSetFromArray(EnterpriseProductLicense[] enterpriseProductLicenseArray) {
        TreeSet<EnterpriseProductLicense> treeSet = new TreeSet<EnterpriseProductLicense>(new Comparator<EnterpriseProductLicense>(){

            @Override
            public int compare(EnterpriseProductLicense enterpriseProductLicense, EnterpriseProductLicense enterpriseProductLicense2) {
                int n;
                int n2 = enterpriseProductLicense.getLicenseKeyVersion();
                int n3 = enterpriseProductLicense2.getLicenseKeyVersion();
                int n4 = -1;
                int n5 = -1;
                if (n2 > -1) {
                    n4 = n2;
                }
                if (n3 > -1) {
                    n5 = n3;
                }
                if ((n = n5 - n4) == 0) {
                    n = (int)(enterpriseProductLicense2.getUpdatedMS() - enterpriseProductLicense.getUpdatedMS());
                }
                return n;
            }
        });
        for (int i = 0; i < enterpriseProductLicenseArray.length; ++i) {
            treeSet.add(enterpriseProductLicenseArray[i]);
        }
        return treeSet;
    }

    private EnterpriseProductLicense getMasterLicenseCode(TreeSet<EnterpriseProductLicense> treeSet) {
        EnterpriseProductLicense enterpriseProductLicense = null;
        EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
        String string = enterpriseServerAM.getHardwareKey();
        for (EnterpriseProductLicense enterpriseProductLicense2 : treeSet) {
            if (!enterpriseProductLicense2.isValidAndValidOn(string)) continue;
            return enterpriseProductLicense2;
        }
        if (enterpriseProductLicense == null) {
            try {
                enterpriseProductLicense = new EnterpriseProductLicense("");
            }
            catch (Exception exception) {
                logger.error((Object)"Error setting blank license.", (Throwable)exception);
            }
            logger.debug((Object)"Setting blank Permanent license key - Unlicensed.");
        }
        return enterpriseProductLicense;
    }

    private EnterpriseProductLicense[] getAllPrimaryLicenses() {
        EnterpriseProductLicense[] enterpriseProductLicenseArray = new EnterpriseProductLicense[]{};
        EnterpriseProductLicense enterpriseProductLicense = null;
        try {
            LicenseCodeRecord[] licenseCodeRecordArray = this.getLicenseCodeList(1);
            enterpriseProductLicenseArray = new EnterpriseProductLicense[licenseCodeRecordArray.length];
            for (int i = 0; i < licenseCodeRecordArray.length; ++i) {
                enterpriseProductLicenseArray[i] = enterpriseProductLicense = new EnterpriseProductLicense(licenseCodeRecordArray[i].id, licenseCodeRecordArray[i].updatedMS, licenseCodeRecordArray[i].licenseCode);
            }
        }
        catch (NoDataException noDataException) {
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining all Primary Licenses.", (Throwable)exception);
        }
        return enterpriseProductLicenseArray;
    }

    @Override
    public EnterpriseLicenseInfo getStandbyLicenseInfo() throws ActionFailedException, ResourceUnavailableException {
        Object object;
        EnterpriseProductLicense enterpriseProductLicense = null;
        try {
            object = this.getStandbyLicenseCode();
            if (object != null) {
                enterpriseProductLicense = new EnterpriseProductLicense(((LicenseCodeRecord)object).id, ((LicenseCodeRecord)object).updatedMS, ((LicenseCodeRecord)object).licenseCode);
            }
        }
        catch (NoDataException noDataException) {
            String string = "Primary license code does not exist for standby.";
            logger.debug((Object)string);
        }
        catch (Exception exception) {
            String string = "Error while retrieving the primary license code for standby.";
            logger.debug((Object)string, (Throwable)exception);
        }
        if (enterpriseProductLicense == null) {
            try {
                enterpriseProductLicense = new EnterpriseProductLicense("");
            }
            catch (Exception exception) {
                logger.error((Object)"Error setting blank license.", (Throwable)exception);
            }
        }
        object = new EnterpriseLicenseInfo();
        ((EnterpriseLicenseInfo)object).setPrimaryLicense(enterpriseProductLicense);
        return object;
    }

    @Override
    public EnterpriseLicenseInfo_Validated getValidatedLicenseInfo(long l) throws ActionFailedException, ResourceUnavailableException {
        String string;
        EnterpriseLicenseInfo_Validated enterpriseLicenseInfo_Validated = new EnterpriseLicenseInfo_Validated();
        EnterpriseProductLicense enterpriseProductLicense = null;
        EnterpriseProductLicense enterpriseProductLicense2 = null;
        EnterpriseProductLicense[] enterpriseProductLicenseArray = this.getAllPrimaryLicenses();
        enterpriseLicenseInfo_Validated.setAllPrimaryLicenses(enterpriseProductLicenseArray);
        TreeSet<EnterpriseProductLicense> treeSet = this.getLicenseSetFromArray(enterpriseProductLicenseArray);
        enterpriseProductLicense = this.getMasterLicenseCode(treeSet);
        try {
            enterpriseProductLicense2 = this.getTrialLicenseCode();
        }
        catch (NoDataException noDataException) {
            string = "Temporary license code does not exist.";
            logger.debug((Object)string);
        }
        catch (Exception exception) {
            string = "Error while retrieving the temporary license code.";
            logger.debug((Object)string, (Throwable)exception);
        }
        if (enterpriseProductLicense2 == null) {
            try {
                enterpriseProductLicense2 = new EnterpriseProductLicense("");
            }
            catch (Exception exception) {
                logger.error((Object)"Error setting blank license.", (Throwable)exception);
            }
        }
        char[] cArray = String.valueOf(l).toCharArray();
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        for (int i = 0; i < cArray.length; ++i) {
            int n = cArray.length - 1 - i;
            String string2 = String.valueOf(cArray[n]);
            l4 += Long.parseLong(string2);
            if (n % 2 == 1) {
                l2 += (long)Integer.parseInt(string2) * (long)Math.pow(10.0, n / 2);
                continue;
            }
            l3 += (long)Integer.parseInt(string2) * (long)Math.pow(10.0, n / 2);
        }
        long l5 = EnterpriseLicenseInfoAMJdbc.reverseNumber(l4);
        long l6 = 0L;
        long l7 = 0L;
        long l8 = (l3 + l2 + l6 + l7) * l5;
        String string3 = String.valueOf(EnterpriseLicenseInfoAMJdbc.reverseNumber(l8));
        enterpriseLicenseInfo_Validated.setLicenseSeed(l);
        enterpriseLicenseInfo_Validated.setPrimaryLicenseKey(string3);
        enterpriseLicenseInfo_Validated.setPrimaryLicense(enterpriseProductLicense);
        enterpriseLicenseInfo_Validated.setTrialLicenseKey(string3);
        enterpriseLicenseInfo_Validated.setTrialLicense(enterpriseProductLicense2);
        return enterpriseLicenseInfo_Validated;
    }

    private static final long reverseNumber(long l) {
        char[] cArray = String.valueOf(l).toCharArray();
        char[] cArray2 = new char[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray2[cArray.length - 1 - i] = cArray[i];
        }
        return Long.parseLong(String.valueOf(cArray2));
    }

    private LicenseCodeRecord[] getLicenseCodeList(int n) throws NoDataException, ResourceUnavailableException {
        ArrayList<LicenseCodeRecord> arrayList = new ArrayList<LicenseCodeRecord>();
        String string = "SELECT id, updated_at, license_code FROM " + this.table + " WHERE license_type=? ORDER BY id";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong("id");
                Timestamp timestamp = resultSet.getTimestamp("updated_at");
                String string2 = Convert.trimR((String)resultSet.getString("license_code"));
                LicenseCodeRecord licenseCodeRecord = new LicenseCodeRecord(l, timestamp.getTime(), string2);
                arrayList.add(licenseCodeRecord);
            }
            if (!arrayList.isEmpty()) {
                LicenseCodeRecord[] licenseCodeRecordArray = arrayList.toArray(new LicenseCodeRecord[arrayList.size()]);
                return licenseCodeRecordArray;
            }
            try {
                String string3 = MessageUtil.formatMsg((String)"License code for type {0} was not found.", (Object[])new Object[]{n});
                throw new NoDataException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = MessageUtil.formatMsg((String)"SQL error while retrieving license code for type {0}.", (Object[])new Object[]{n});
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void saveLastNotifiedDate(int n, Date date) throws ActionFailedException, ResourceUnavailableException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string = simpleDateFormat.format(date);
        String string2 = "UPDATE " + this.table + " SET notify_date=? WHERE license_type=?";
        int n2 = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                String string3 = MessageUtil.formatMsg((String)"License Type {0} was not found while updating the last notification date.", (Object[])new Object[]{n});
                throw new ResourceUnavailableException(string3);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string4 = MessageUtil.formatMsg((String)"Error updating last notification date for license type {0}.", (Object[])new Object[]{n});
            throw new ResourceUnavailableException(string4, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public EnterpriseProductLicense getTrialLicenseCode() throws Exception {
        EnterpriseProductLicense enterpriseProductLicense = null;
        LicenseCodeRecord[] licenseCodeRecordArray = this.getLicenseCodeList(2);
        enterpriseProductLicense = new EnterpriseProductLicense(licenseCodeRecordArray[0].id, licenseCodeRecordArray[0].updatedMS, licenseCodeRecordArray[0].licenseCode);
        return enterpriseProductLicense;
    }

    public LicenseCodeRecord getStandbyLicenseCode() throws Exception {
        LicenseCodeRecord[] licenseCodeRecordArray = this.getLicenseCodeList(1);
        EnterpriseProductLicense enterpriseProductLicense = null;
        EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
        String string = enterpriseServerAM.getHardwareKey();
        for (int i = 0; i < licenseCodeRecordArray.length; ++i) {
            enterpriseProductLicense = new EnterpriseProductLicense(licenseCodeRecordArray[i].id, licenseCodeRecordArray[i].updatedMS, licenseCodeRecordArray[i].licenseCode);
            if (enterpriseProductLicense.isValidAndValidOn(string)) continue;
            return licenseCodeRecordArray[i];
        }
        return null;
    }

    @Override
    public boolean hasValidLicenseForHardware(String string) throws Exception {
        LicenseCodeRecord[] licenseCodeRecordArray = this.getLicenseCodeList(1);
        EnterpriseProductLicense enterpriseProductLicense = null;
        for (int i = 0; i < licenseCodeRecordArray.length; ++i) {
            enterpriseProductLicense = new EnterpriseProductLicense(licenseCodeRecordArray[i].id, licenseCodeRecordArray[i].updatedMS, licenseCodeRecordArray[i].licenseCode);
            if (!enterpriseProductLicense.isValidAndValidOn(string)) continue;
            return true;
        }
        return false;
    }

    private class LicenseCodeRecord {
        private long id;
        private long updatedMS;
        private String licenseCode;

        LicenseCodeRecord(long l, long l2, String string) {
            this.id = l;
            this.updatedMS = l2;
            this.licenseCode = string;
        }
    }
}

