/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.EmailTargetAttachment;
import com.helpsystems.enterprise.core.dm.EmailTargetAttachmentDM;
import com.helpsystems.enterprise.core.util.FileHandler;
import com.helpsystems.enterprise.core.util.SQLUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class EmailTargetAttachmentDMJdbc
extends AbstractHelpingDatabaseManager
implements EmailTargetAttachmentDM {
    private static final Logger logger = Logger.getLogger(EmailTargetAttachmentDMJdbc.class);
    private static final String objDesc = "EmailTargetAttachment";
    private static final String TABLE_NAME = "email_target_attachments";
    private static final int PURGE_IN_ONE_CYCLE = 1000;

    public EmailTargetAttachmentDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.EmailTargetAttachmentDM");
    }

    @Override
    public EmailTargetAttachment get(long l) throws ResourceUnavailableException, DataException {
        return this.get(l, null);
    }

    @Override
    public EmailTargetAttachment get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        EmailTargetAttachment emailTargetAttachment = new EmailTargetAttachment();
        emailTargetAttachment.setOid(l);
        emailTargetAttachment = connection == null ? (EmailTargetAttachment)super.get((Object)emailTargetAttachment) : (EmailTargetAttachment)super.get(connection, (Object)emailTargetAttachment);
        if (emailTargetAttachment == null) {
            throw new NoDataException("The requested EmailTargetAttachment was not found.");
        }
        return emailTargetAttachment;
    }

    @Override
    public EmailTargetAttachment[] getByEmailStatus(int n) throws DataException, ResourceUnavailableException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("getEmailStatus", n);
        return (EmailTargetAttachment[])super.search((Object)new EmailTargetAttachment(), hashMap);
    }

    @Override
    public EmailTargetAttachment[] getByNotificationListId(int n) throws DataException, ResourceUnavailableException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("getNotificationListId", n);
        return (EmailTargetAttachment[])super.search((Object)new EmailTargetAttachment(), hashMap);
    }

    @Override
    public EmailTargetAttachment[] getByResend(boolean bl) throws DataException, ResourceUnavailableException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("getResend", bl);
        return (EmailTargetAttachment[])super.search((Object)new EmailTargetAttachment(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmailTargetAttachment[] getByJobHistoryId(long l) throws DataException, ResourceUnavailableException {
        EmailTargetAttachment[] emailTargetAttachmentArray = new EmailTargetAttachment[]{};
        EmailTargetAttachmentGenerator emailTargetAttachmentGenerator = new EmailTargetAttachmentGenerator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT * FROM ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" WHERE job_history_id = ?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<EmailTargetAttachment> arrayList = new ArrayList<EmailTargetAttachment>();
            while (resultSet.next()) {
                EmailTargetAttachment emailTargetAttachment = (EmailTargetAttachment)emailTargetAttachmentGenerator.generateObject(resultSet);
                arrayList.add(emailTargetAttachment);
            }
            emailTargetAttachmentArray = arrayList.toArray(new EmailTargetAttachment[arrayList.size()]);
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error getting output distribution history.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
                    throw throwable;
                }
            }
            EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, resultSet);
        }
        EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
        return emailTargetAttachmentArray;
    }

    @Override
    public EmailTargetAttachment[] getByJobHistoryAndNotificationListId(long l, long l2) throws DataException, ResourceUnavailableException {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        hashMap.put("getJobHistoryId", l);
        hashMap.put("getNotificationListId", l2);
        return (EmailTargetAttachment[])super.search((Object)new EmailTargetAttachment(), hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getNotificationListByJobHistoryId(long l) throws DataException, ResourceUnavailableException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT DISTINCT notification_list_id FROM ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" WHERE job_history_id=?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("notification_list_id"));
            }
        }
        catch (Exception exception) {
            block5: {
                try {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)"Error getting email target attachment.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmailTargetAttachment save(EmailTargetAttachment emailTargetAttachment) throws ResourceUnavailableException, DataException {
        EmailTargetAttachment emailTargetAttachment2 = null;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            emailTargetAttachment2 = (EmailTargetAttachment)super.save((Connection)wrappedConnection, (Object)emailTargetAttachment);
        }
        catch (SQLException sQLException) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Error saving email target attachment", (Throwable)sQLException);
            }
        }
        finally {
            EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
        return emailTargetAttachment2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEmailStatus(long l, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET email_status=?, resend=? WHERE id=?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setInt(1, n);
            preparedStatement.setBoolean(2, bl);
            preparedStatement.setLong(3, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the email target attachment's email status.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateResend(long l, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("UPDATE ");
        stringBuilder.append(TABLE_NAME);
        stringBuilder.append(" SET resend=? WHERE id=?");
        String string = stringBuilder.toString();
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            wrappedConnection = this.getConnection();
            preparedStatement = wrappedConnection.prepareStatement(string);
            preparedStatement.setBoolean(1, bl);
            preparedStatement.setLong(2, l);
            preparedStatement.executeUpdate();
        }
        catch (Exception exception) {
            block4: {
                try {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)"Error updating the email target attachment's resend flag.", (Throwable)exception);
                }
                catch (Throwable throwable) {
                    EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, null);
                    throw throwable;
                }
            }
            EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        EmailTargetAttachmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
    }

    @Override
    public void purgeAttachmentsDir(EmailTargetAttachment[] emailTargetAttachmentArray) throws DataException {
        for (EmailTargetAttachment emailTargetAttachment : emailTargetAttachmentArray) {
            this.updateEmailStatus(emailTargetAttachment.getOid(), 3, false);
        }
    }

    @Override
    public void purgeEmailTargetAttachment() throws DataException, ResourceUnavailableException {
        try {
            EmailTargetAttachment[] emailTargetAttachmentArray = this.getByEmailStatus(3);
            int n = emailTargetAttachmentArray.length;
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(emailTargetAttachmentArray[i].getOid());
            }
            this.limitedDelete(null, arrayList);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while checking if email has been completed.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void purgeEmailTargetAttachment(Connection connection, long l) throws DataException, ResourceUnavailableException {
        try {
            EmailTargetAttachment[] emailTargetAttachmentArray = this.getByJobHistoryId(l);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            int n = emailTargetAttachmentArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(emailTargetAttachmentArray[i].getOid());
            }
            this.purgeAttachmentsWithParentDir(emailTargetAttachmentArray);
            this.limitedDelete(connection, arrayList);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new ResourceUnavailableException("Error while getting email target attachment with job history id: " + l, (Throwable)resourceUnavailableException);
        }
    }

    public void purgeAttachmentsWithParentDir(EmailTargetAttachment[] emailTargetAttachmentArray) throws DataException {
        for (EmailTargetAttachment emailTargetAttachment : emailTargetAttachmentArray) {
            File file = new File(emailTargetAttachment.getFileName());
            File file2 = file.getParentFile();
            boolean bl = true;
            if (file.exists()) {
                bl = file.delete();
            }
            FileHandler.deleteEmptyParentFoldersUntilGivenFolder(file2.getName(), "attachments");
            if (bl) {
                this.updateEmailStatus(emailTargetAttachment.getOid(), 3, false);
                continue;
            }
            String string = "Error deleting email attachment " + file.getPath();
            logger.error((Object)string);
        }
    }

    @Override
    public int massDelete(Connection connection, List<Long> list) throws ResourceUnavailableException, DataException {
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        int n = 0;
        try {
            if (list != null && !list.isEmpty()) {
                connection2 = connection != null ? connection : super.getConnection();
                StringBuilder stringBuilder = new StringBuilder("DELETE FROM email_target_attachments WHERE  ");
                String string = SQLUtil.createWhereClauseWithINStatment(list, "id");
                stringBuilder.append(string);
                logger.trace((Object)("Constructed SQL for massDelete: " + stringBuilder.toString()));
                preparedStatement = connection2.prepareStatement(stringBuilder.toString());
                int n2 = 1;
                for (Long l : list) {
                    preparedStatement.setLong(n2, l);
                    ++n2;
                }
                n = preparedStatement.executeUpdate();
            }
        }
        catch (SQLException sQLException) {
            String string = "Error Deleting Email Target Attachments";
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            String string = "Error Deleting Email Target Attachments";
            logger.debug((Object)string, throwable);
            throw new ResourceUnavailableException(string, throwable);
        }
        finally {
            EmailTargetAttachmentDMJdbc.closeEm(null, preparedStatement, null);
            if (connection == null) {
                EmailTargetAttachmentDMJdbc.closeEm((Connection)connection2, null, null);
            }
        }
        return n;
    }

    public int limitedDelete(Connection connection, List<Long> list) throws ResourceUnavailableException, DataException {
        int n = list.size();
        int n2 = 0;
        int n3 = 0;
        if (n > 1000) {
            n2 = (int)Math.ceil((double)n / 1000.0);
            for (int i = 0; i < n2; ++i) {
                int n4 = (i + 1) * 1000;
                if (n4 > n) {
                    n4 = n;
                }
                int n5 = i * 1000;
                ArrayList<Long> arrayList = new ArrayList<Long>();
                for (int j = n5; j < n4; ++j) {
                    arrayList.add(list.get(j));
                }
                n3 = this.massDelete(connection, arrayList);
            }
        } else {
            n3 = this.massDelete(connection, list);
        }
        return n3;
    }

    private class EmailTargetAttachmentGenerator
    extends AbstractBusObjGenerator {
        public EmailTargetAttachmentGenerator() {
            super(7, EmailTargetAttachmentDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new EmailTargetAttachment();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            EmailTargetAttachment emailTargetAttachment = (EmailTargetAttachment)object;
            switch (n) {
                case 1: {
                    emailTargetAttachment.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    emailTargetAttachment.setJobHistoryId(resultSet.getLong("job_history_id"));
                    break;
                }
                case 3: {
                    emailTargetAttachment.setFileName(resultSet.getString("file_name"));
                    break;
                }
                case 4: {
                    emailTargetAttachment.setNotificationListId(resultSet.getInt("notification_list_id"));
                    break;
                }
                case 5: {
                    emailTargetAttachment.setEmailStatus(resultSet.getInt("email_status"));
                    break;
                }
                case 6: {
                    emailTargetAttachment.setResend(resultSet.getBoolean("resend"));
                    break;
                }
                case 7: {
                    emailTargetAttachment.setDeleteOnSent(resultSet.getBoolean("delete_on_sent"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

