/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.AgentReturnCodeText;
import com.helpsystems.enterprise.core.dm.AgentReturnCodeDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AgentReturnCodeDMJdbc
extends AbstractDatabaseManager
implements AgentReturnCodeDM {
    private static final String OBJDESC = "Agent Return Code";
    private static final Logger logger = Logger.getLogger(AgentReturnCodeDMJdbc.class);
    private static final String TABLE = "return_codes";
    private static final String RETURN_CODE_TEXT_TABLE = "return_code_texts";
    private String table;
    private String returnCodeTextTable;

    public AgentReturnCodeDMJdbc(String string, String string2) {
        super(string);
        this.table = string2 + "." + TABLE;
        this.returnCodeTextTable = string2 + "." + RETURN_CODE_TEXT_TABLE;
        this.setName("ENTERPRISE.AgentReturnCodeDM");
    }

    @Override
    public AgentReturnCode get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        boolean bl;
        PreparedStatement preparedStatement;
        AgentReturnCode agentReturnCode = null;
        AgentReturnCodeGenerator agentReturnCodeGenerator = new AgentReturnCodeGenerator();
        String string = "select ID, name, description, return_code_type, success_type_list, action_list, text_matching_type from " + this.table + " where ID = ?";
        ResultSet resultSet = null;
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string);
            bl = false;
        }
        try {
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                AgentReturnCode agentReturnCode2 = agentReturnCode = (AgentReturnCode)((Object)agentReturnCodeGenerator.generateObject(resultSet));
                return agentReturnCode2;
            }
            try {
                String string2 = "Return Code " + l + " was not found.";
                logger.debug((Object)string2);
                throw new NoDataException(string2);
            }
            catch (SQLException sQLException) {
                String string3 = MessageUtil.formatMsg((String)"SQL error while retrieving {0}.", (Object[])new Object[]{OBJDESC});
                logger.debug((Object)string3, (Throwable)sQLException);
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            } else {
                AgentReturnCodeDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    @Override
    public AgentReturnCode getStandard(Connection connection) throws NoDataException, DataException, ResourceUnavailableException {
        return this.getByName("STANDARD", connection);
    }

    @Override
    public AgentReturnCode getByName(String string, Connection connection) throws NoDataException, DataException, ResourceUnavailableException {
        boolean bl;
        PreparedStatement preparedStatement;
        AgentReturnCode agentReturnCode = null;
        AgentReturnCodeGenerator agentReturnCodeGenerator = new AgentReturnCodeGenerator();
        String string2 = "select id, name, description, return_code_type, success_type_list, action_list, text_matching_type from " + this.table + " where name = ?";
        ResultSet resultSet = null;
        if (connection != null) {
            preparedStatement = this.getDefaultPreparedStmt(string2, connection);
            bl = true;
        } else {
            preparedStatement = this.getDefaultPreparedStmt(string2);
            bl = false;
        }
        try {
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                AgentReturnCode agentReturnCode2 = agentReturnCode = (AgentReturnCode)((Object)agentReturnCodeGenerator.generateObject(resultSet));
                return agentReturnCode2;
            }
            try {
                String string3 = "Return Code named " + string + " was not found.";
                logger.debug((Object)string3);
                throw new NoDataException(string3);
            }
            catch (SQLException sQLException) {
                String string4 = MessageUtil.formatMsg((String)"SQL error while retrieving {0}.", (Object[])new Object[]{OBJDESC});
                logger.debug((Object)string4, (Throwable)sQLException);
                throw new ResourceUnavailableException(string4, (Throwable)sQLException);
            }
        }
        finally {
            if (!bl) {
                this.closeConnection(preparedStatement);
            } else {
                AgentReturnCodeDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            }
        }
    }

    private void loadReturnCodeTexts(AgentReturnCode agentReturnCode, Connection connection) throws SQLException, ResourceUnavailableException {
        String string = "SELECT id, contains, text_to_match, use_regexp FROM " + this.returnCodeTextTable + " WHERE return_code_id=? order by text_to_match";
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, connection);
        try {
            preparedStatement.setLong(1, agentReturnCode.getOid());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                AgentReturnCodeText agentReturnCodeText = new AgentReturnCodeText();
                try {
                    long l = resultSet.getLong("id");
                    agentReturnCodeText.setOid(l);
                    int n = resultSet.getInt("contains");
                    agentReturnCodeText.setContains(n);
                    String string2 = resultSet.getString("text_to_match");
                    agentReturnCodeText.setTextToMatch(string2);
                    boolean bl = resultSet.getBoolean("use_regexp");
                    agentReturnCodeText.setUseRegExp(bl);
                }
                catch (Exception exception) {
                    String string3 = "Error while retrieving the return code text.";
                    logger.debug((Object)string3, (Throwable)exception);
                }
                agentReturnCode.addReturnCodeText(agentReturnCodeText);
            }
        }
        catch (Exception exception) {
            try {
                String string4 = "Error while retrieving the return code text.";
                logger.debug((Object)string4, (Throwable)exception);
                throw new RuntimeException(string4, exception);
            }
            catch (Throwable throwable) {
                AgentReturnCodeDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                throw throwable;
            }
        }
        AgentReturnCodeDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
    }

    private class AgentReturnCodeGenerator
    extends AbstractBusObjGenerator {
        public AgentReturnCodeGenerator() {
            super(8, AgentReturnCodeDMJdbc.OBJDESC);
        }

        protected Object constructObject() {
            return new AgentReturnCode();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentReturnCode agentReturnCode = (AgentReturnCode)((Object)object);
            switch (n) {
                case 1: {
                    agentReturnCode.setOid(resultSet.getInt("ID"));
                    break;
                }
                case 2: {
                    String string = resultSet.getString("name");
                    if (string == null) {
                        string = "";
                    }
                    agentReturnCode.setName(string.trim());
                    break;
                }
                case 3: {
                    String string = resultSet.getString("description");
                    if (string == null) {
                        string = "";
                    }
                    agentReturnCode.setDescription(string.trim());
                    break;
                }
                case 4: {
                    agentReturnCode.setType(resultSet.getInt("return_code_type"));
                    break;
                }
                case 5: {
                    agentReturnCode.setSuccessTypeList(resultSet.getBoolean("success_type_list"));
                    break;
                }
                case 6: {
                    String string = resultSet.getString("action_list");
                    if (string == null) {
                        string = "";
                    }
                    agentReturnCode.setActionList(string);
                    break;
                }
                case 7: {
                    int n2 = resultSet.getInt("text_matching_type");
                    agentReturnCode.setTextMatchType(n2);
                    break;
                }
                case 8: {
                    Connection connection = resultSet.getStatement().getConnection();
                    AgentReturnCodeDMJdbc.this.loadReturnCodeTexts(agentReturnCode, connection);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
        }
    }
}

