/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentGroup;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgent;
import com.helpsystems.enterprise.core.busobj.AgentGroupAgentWithName;
import com.helpsystems.enterprise.core.busobj.AgentGroupProxy;
import com.helpsystems.enterprise.core.busobj.AgentGroupType;
import com.helpsystems.enterprise.core.busobj.PriorityBasedAgentGroup;
import com.helpsystems.enterprise.core.busobj.UtilizationBalancedAgentGroup;
import com.helpsystems.enterprise.core.dm.AgentGroupDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class AgentGroupDMJdbc
extends AbstractHelpingDatabaseManager
implements AgentGroupDM {
    private static Logger logger = Logger.getLogger(AgentGroupDMJdbc.class);
    private Calendar cloneOnly_GMTCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private String group_table;
    private String agents_table;
    private String agentMasterTable;
    private BusinessObjectGenerator<AgentGroupProxy> proxyGenerator = new AgentGroupProxyGenerator();
    private BusinessObjectGenerator objectGenerator = new AgentGroupGenerator();
    private BusinessObjectGenerator agentGenerator = new AgentGroupAgentGenerator();

    public AgentGroupDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AgentGroupDM");
        this.group_table = string2 + "." + "agent_groups";
        this.agents_table = string2 + "." + "agent_group_agents";
        this.agentMasterTable = string2 + "." + "agents";
    }

    private String getAgentGroupSql() {
        return "SELECT id, name, description, group_type FROM " + this.group_table;
    }

    private String getAgentsSql() {
        return "SELECT id, agent_group_id, agent_id, ignore_in_group, ignore_until, sequence FROM " + this.agents_table;
    }

    @Override
    public AgentGroupProxy getProxy(long l) throws DataException, ResourceUnavailableException {
        return this.getProxy(l, null);
    }

    @Override
    public AgentGroupProxy getProxy(long l, Connection connection) throws DataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block8: {
            connection2 = connection;
            preparedStatement = null;
            resultSet = null;
            if (connection2 == null) {
                connection2 = super.getConnectionOrFail();
            }
            String string = this.getAgentGroupSql() + " WHERE id = ?";
            preparedStatement = super.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block8;
            AgentGroupProxy agentGroupProxy = (AgentGroupProxy)((Object)this.proxyGenerator.generateObject(resultSet));
            AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
            }
            return agentGroupProxy;
        }
        try {
            try {
                throw new NoDataException("Agent Group not found for agent group ID: " + l);
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("SQL Error retrieving agent group (" + l + ").", (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            AbstractHelpingDatabaseManager.closeEm(null, preparedStatement, resultSet);
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
            }
            throw throwable;
        }
    }

    @Override
    public AgentGroup get(long l) throws DataException, ResourceUnavailableException {
        return this.get(l, null);
    }

    @Override
    public AgentGroup get(long l, Connection connection) throws ResourceUnavailableException, DataException {
        AgentGroup agentGroup;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (connection2 == null) {
                connection2 = super.getConnectionOrFail();
            }
            String string = this.getAgentGroupSql() + " WHERE id = ?";
            preparedStatement = super.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            AgentGroup agentGroup2 = null;
            if (!resultSet.next()) {
                throw new NoDataException("Agent Group not found for agent group ID: " + l);
            }
            agentGroup2 = (AgentGroup)((Object)this.objectGenerator.generateObject(resultSet));
            agentGroup2.setAgents(this.getAgentGroupAgents(l, connection2));
            if (agentGroup2.getAgentGroupType() == AgentGroupType.UTILIZATION_BALANCED) {
                agentGroup2 = new UtilizationBalancedAgentGroup(agentGroup2);
            } else if (agentGroup2.getAgentGroupType() == AgentGroupType.PREFERRED_AGENT) {
                agentGroup2 = new PriorityBasedAgentGroup(agentGroup2);
            }
            agentGroup = agentGroup2;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL Error retrieving agent group (" + l + ").", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractHelpingDatabaseManager.closeEm(null, preparedStatement, resultSet);
                if (connection == null) {
                    AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
                }
                throw throwable;
            }
        }
        AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        if (connection == null) {
            AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
        }
        return agentGroup;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AgentGroupAgent[] getAgentGroupAgents(long l, Connection connection) throws ResourceUnavailableException {
        AgentGroupAgent[] agentGroupAgentArray;
        if (connection == null) {
            throw new NullPointerException("A connection is required for getAgentGroupAgents.");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = this.getAgentsSql() + " WHERE agent_group_id = ?";
            preparedStatement = super.getDefaultPreparedStmt(string, connection);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            agentGroupAgentArray = (AgentGroupAgent[])this.agentGenerator.generateObjectArray(resultSet);
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL Error retrieving agent group agents (" + l + ").", (Throwable)sQLException);
                catch (BadDataArrayException badDataArrayException) {
                    throw new ResourceUnavailableException("Error retrieving agent group agents(" + l + ").", (Throwable)badDataArrayException);
                }
            }
            catch (Throwable throwable) {
                AgentGroupDMJdbc.closeEm(null, preparedStatement, resultSet);
                throw throwable;
            }
        }
        AgentGroupDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        return agentGroupAgentArray;
    }

    @Override
    public AgentGroupAgentWithName[] getAgentsInGroup(long l) throws ResourceUnavailableException {
        AgentGroupAgentWithNameGenerator agentGroupAgentWithNameGenerator = new AgentGroupAgentWithNameGenerator();
        String string = "SELECT g.id, agent_group_id, agent_id, ignore_in_group, ignore_until, name, sequence FROM " + this.agents_table + " g JOIN " + this.agentMasterTable + " a ON agent_id = a.id WHERE agent_group_id =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            AgentGroupAgentWithName[] agentGroupAgentWithNameArray = (AgentGroupAgentWithName[])agentGroupAgentWithNameGenerator.generateObjectArray(resultSet);
            return agentGroupAgentWithNameArray;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the agents in agent group {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        catch (BadDataArrayException badDataArrayException) {
            String string3 = MessageUtil.formatMsg((String)"Bad data encountered while retrieving the agents in agent group {0}.", (Object[])new Object[]{l});
            throw new IllegalStateException(string3, badDataArrayException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public long[] getAgentsIDsInGroup(long l, Connection connection) throws ResourceUnavailableException {
        long[] lArray;
        Connection connection2 = connection;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (connection2 == null) {
                connection2 = super.getConnectionOrFail();
            }
            String string = this.getAgentsSql() + " WHERE agent_group_id = ?";
            preparedStatement = super.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("agent_id"));
            }
            long[] lArray2 = new long[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                lArray2[i] = (Long)arrayList.get(i);
            }
            lArray = lArray2;
        }
        catch (SQLException sQLException) {
            try {
                throw new ResourceUnavailableException("SQL Error retrieving agent group agent ids (" + l + ").", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                AbstractHelpingDatabaseManager.closeEm(null, preparedStatement, resultSet);
                if (connection == null) {
                    AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
                }
                throw throwable;
            }
        }
        AbstractHelpingDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        if (connection == null) {
            AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
        }
        return lArray;
    }

    @Override
    public AgentGroupAgent getAgentGroupAgent(long l, long l2, Connection connection) throws ResourceUnavailableException, NoDataException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection2;
        block9: {
            connection2 = connection;
            preparedStatement = null;
            resultSet = null;
            if (connection2 == null) {
                connection2 = super.getConnectionOrFail();
            }
            String string = this.getAgentsSql() + " WHERE agent_group_id = ? AND agent_id = ?";
            preparedStatement = super.getDefaultPreparedStmt(string, connection2);
            preparedStatement.setLong(1, l);
            preparedStatement.setLong(2, l2);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block9;
            AgentGroupAgent agentGroupAgent = (AgentGroupAgent)this.agentGenerator.generateObject(resultSet);
            AgentGroupDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
            }
            return agentGroupAgent;
        }
        try {
            try {
                throw new NoDataException("Agent (" + l2 + ") not defined in Agent Group (" + l + ").");
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("SQL Error retrieving agent (" + l2 + ") for agent group (" + l + ").", (Throwable)sQLException);
            }
            catch (BadDataException badDataException) {
                throw new ResourceUnavailableException("Error retrieving agent (" + l2 + ") for agent group (" + l + ").", (Throwable)badDataException);
            }
        }
        catch (Throwable throwable) {
            AgentGroupDMJdbc.closeEm(null, preparedStatement, resultSet);
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm((Connection)connection2, null, null);
            }
            throw throwable;
        }
    }

    @Override
    public void releaseIfHeldExpired(AgentGroupAgent agentGroupAgent, TimeZone timeZone) {
        if (agentGroupAgent.getIgnoreInGroup() == 2 && agentGroupAgent.getIgnoreUntilTimestamp() != 0L) {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(agentGroupAgent.getIgnoreUntilTimestamp());
            Calendar calendar3 = this.getHoldUntilAgent(timeZone, calendar2);
            if (calendar.after(calendar2) && calendar.after(calendar3)) {
                try {
                    this.release(agentGroupAgent.getOid());
                }
                catch (Throwable throwable) {
                    String string = MessageUtil.formatMsg((String)"Error releasing held Agent Group Agent {0}.", (Object[])new Object[]{String.valueOf(agentGroupAgent.getOid())});
                    logger.error((Object)string, throwable);
                }
            }
        }
    }

    private Calendar getHoldUntilAgent(TimeZone timeZone, Calendar calendar) {
        Calendar calendar2 = null;
        calendar2 = Calendar.getInstance(timeZone);
        calendar2.setTimeInMillis(0L);
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        return calendar2;
    }

    @Override
    public void release(long l) throws ResourceUnavailableException {
        try {
            this.updateHeldInfo(l, 0, 0L);
        }
        catch (Exception exception) {
            String string = MessageUtil.formatMsg((String)"Error releasing Agent Group Agent {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string, (Throwable)exception);
        }
    }

    @Override
    public void updateHeldInfo(long l, int n, long l2) throws ResourceUnavailableException {
        String string = "UPDATE agent_group_agents SET ignore_in_group=?, ignore_until=? WHERE id=?";
        int n2 = 0;
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            Object object;
            preparedStatement.setInt(1, n);
            if (l2 == 0L) {
                preparedStatement.setNull(2, 93);
            } else {
                object = (Calendar)this.cloneOnly_GMTCalendar.clone();
                Timestamp timestamp = new Timestamp(l2);
                preparedStatement.setTimestamp(2, timestamp, (Calendar)object);
            }
            preparedStatement.setLong(3, l);
            n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                object = MessageUtil.formatMsg((String)"Agent Group Agent {0} was not found while updating hold information.", (Object[])new Object[]{l});
                throw new ResourceUnavailableException((String)object);
            }
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw resourceUnavailableException;
        }
        catch (Exception exception) {
            String string2 = MessageUtil.formatMsg((String)"Error updating hold information for Agent Group Agent {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)exception);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private class AgentGroupAgentWithNameGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 7;

        AgentGroupAgentWithNameGenerator() {
            super(7, AgentGroupAgentWithName.class.getName());
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentGroupAgentWithName agentGroupAgentWithName = (AgentGroupAgentWithName)object;
            switch (n) {
                case 1: {
                    agentGroupAgentWithName.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    agentGroupAgentWithName.setAgentID(resultSet.getLong("agent_id"));
                    break;
                }
                case 3: {
                    agentGroupAgentWithName.setAgentGroupID(resultSet.getLong("agent_group_id"));
                    break;
                }
                case 4: {
                    agentGroupAgentWithName.setIgnoreInGroup(resultSet.getInt("ignore_in_group"));
                    break;
                }
                case 5: {
                    Calendar calendar = (Calendar)AgentGroupDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("ignore_until", calendar);
                    if (timestamp != null) {
                        agentGroupAgentWithName.setIgnoreUntilTimestamp(timestamp.getTime());
                        break;
                    }
                    agentGroupAgentWithName.setIgnoreUntilTimestamp(0L);
                    break;
                }
                case 6: {
                    agentGroupAgentWithName.setSequence(resultSet.getInt("sequence"));
                    break;
                }
                case 7: {
                    agentGroupAgentWithName.setAgentName(Convert.trimR((String)resultSet.getString("name")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected Object constructObject() {
            return new AgentGroupAgentWithName();
        }
    }

    private class AgentGroupAgentGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 6;

        AgentGroupAgentGenerator() {
            super(6, AgentGroupAgent.class.getName());
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentGroupAgent agentGroupAgent = (AgentGroupAgent)object;
            switch (n) {
                case 1: {
                    agentGroupAgent.setOid(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    agentGroupAgent.setAgentID(resultSet.getLong("agent_id"));
                    break;
                }
                case 3: {
                    agentGroupAgent.setAgentGroupID(resultSet.getLong("agent_group_id"));
                    break;
                }
                case 4: {
                    agentGroupAgent.setIgnoreInGroup(resultSet.getInt("ignore_in_group"));
                    break;
                }
                case 5: {
                    Calendar calendar = (Calendar)AgentGroupDMJdbc.this.cloneOnly_GMTCalendar.clone();
                    Timestamp timestamp = resultSet.getTimestamp("ignore_until", calendar);
                    if (timestamp != null) {
                        agentGroupAgent.setIgnoreUntilTimestamp(timestamp.getTime());
                        break;
                    }
                    agentGroupAgent.setIgnoreUntilTimestamp(0L);
                    break;
                }
                case 6: {
                    agentGroupAgent.setSequence(resultSet.getInt("sequence"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected Object constructObject() {
            return new AgentGroupAgent();
        }
    }

    private class AgentGroupGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 4;

        AgentGroupGenerator() {
            super(4, AgentGroup.class.getName());
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentGroup agentGroup = (AgentGroup)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    agentGroup.setName(string);
                    break;
                }
                case 2: {
                    agentGroup.setOid(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    agentGroup.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    agentGroup.setAgentGroupType(AgentGroupType.persistanceCodeToEnum(resultSet.getInt("group_type")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected Object constructObject() {
            return new AgentGroup();
        }
    }

    private class AgentGroupProxyGenerator
    extends AbstractBusObjGenerator {
        static final int numPassesToMake = 4;

        AgentGroupProxyGenerator() {
            super(4, AgentGroupProxy.class.getName());
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentGroupProxy agentGroupProxy = (AgentGroupProxy)((Object)object);
            switch (n) {
                case 1: {
                    String string = resultSet.getString("name").trim();
                    agentGroupProxy.setName(string);
                    break;
                }
                case 2: {
                    agentGroupProxy.setOid(resultSet.getLong("id"));
                    break;
                }
                case 3: {
                    agentGroupProxy.setDescription(resultSet.getString("description"));
                    break;
                }
                case 4: {
                    agentGroupProxy.setAgentGroupType(AgentGroupType.persistanceCodeToEnum(resultSet.getInt("group_type")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected Object constructObject() {
            return new AgentGroupProxy();
        }
    }
}

