/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.AbstractHelpingDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.EventHistoryXRef;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.dm.AgentEventHistoryInfoDM;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.EventHistoryXRefDM;
import com.helpsystems.enterprise.core.dm.ReactivityAM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.PrereqDM;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AgentEventHistoryInfoDMJdbc
extends AbstractHelpingDatabaseManager
implements AgentEventHistoryInfoDM {
    private static final Logger logger = Logger.getLogger(AgentEventHistoryInfoDM.class);
    public static final String TABLE_NAME = "AGENT_EVENT_HISTORIES";
    private ReactivityAM reactivityAM;
    private AgentEventMonitorDM agentEventMonitorDM;
    private PrereqDM prereqDM;
    private EventHistoryXRefDM eventHistoryXRefDM;
    private String table;

    public AgentEventHistoryInfoDMJdbc(String string, String string2, SQLManagerHelper sQLManagerHelper, AgentEventMonitorDM agentEventMonitorDM, PrereqDM prereqDM, EventHistoryXRefDM eventHistoryXRefDM) {
        super(string, string2, sQLManagerHelper);
        this.setName("ENTERPRISE.AgentEventHistoryInfoDM");
        this.agentEventMonitorDM = agentEventMonitorDM;
        this.prereqDM = prereqDM;
        this.eventHistoryXRefDM = eventHistoryXRefDM;
        this.table = string2 + "." + TABLE_NAME;
    }

    @Override
    public AgentEventHistoryInfo get(long l) throws ResourceUnavailableException, DataException {
        AgentEventHistoryInfo agentEventHistoryInfo = new AgentEventHistoryInfo();
        agentEventHistoryInfo.setOID(l);
        return (AgentEventHistoryInfo)((Object)super.get((Object)agentEventHistoryInfo));
    }

    @Override
    public List<AgentEventHistoryInfo> getRelatedAgentEventHistory(JobHistory jobHistory) throws ResourceUnavailableException {
        ArrayList<AgentEventHistoryInfo> arrayList = new ArrayList<AgentEventHistoryInfo>(5);
        long l = jobHistory.getId();
        if (jobHistory.isJobSuiteMember()) {
            l = jobHistory.getJobSuiteHistoryID();
        }
        try {
            EventHistoryXRef[] eventHistoryXRefArray = this.eventHistoryXRefDM.getListForJobHistory(l, PrereqEventType.AGENT_EVENT);
            if (eventHistoryXRefArray != null && eventHistoryXRefArray.length > 0) {
                for (int i = 0; i < eventHistoryXRefArray.length; ++i) {
                    long l2 = eventHistoryXRefArray[i].getEventHistoryID();
                    AgentEventHistoryInfo agentEventHistoryInfo = this.get(l2);
                    arrayList.add(agentEventHistoryInfo);
                }
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException(exception.getMessage(), (Throwable)exception);
        }
        return arrayList;
    }

    @Override
    public long save(Connection connection, AgentEventHistoryInfo agentEventHistoryInfo) throws ResourceUnavailableException, DataException {
        AgentEventHistoryInfo agentEventHistoryInfo2 = (AgentEventHistoryInfo)((Object)super.save(connection, (Object)agentEventHistoryInfo));
        if (agentEventHistoryInfo2.getErrorStatus() == 0) {
            this.reactivityAM.notifyAgentEvent(connection, agentEventHistoryInfo2);
        }
        return agentEventHistoryInfo.getAgentTimeStamp();
    }

    public void setReactivityAM(ReactivityAM reactivityAM) {
        ValidationHelper.checkForNull((String)"ReactivityAM", (Object)reactivityAM);
        this.reactivityAM = reactivityAM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int purgeHistory(int n) throws ResourceUnavailableException, SQLException {
        Object object;
        Object[] objectArray;
        int n2 = 0;
        long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
        long l2 = 0L;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnection();
        PreparedStatement preparedStatement = null;
        String string = "DELETE FROM AGENT_EVENT_HISTORIES WHERE event_monitor_id=? AND server_timestamp_utc < ? AND id NOT IN (SELECT history_id from prerequisite_statuses where prereq_type = 1 and history_id != 0 and history_id is not null ORDER BY prereq_type)";
        preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
        String string2 = RosettaMsg.PURGE_AGENT_EVENT_LOG_NAME.newLogEntry().getMessageText();
        String[] stringArray = new String[]{string2};
        ScheduleLogEntry scheduleLogEntry = RosettaMsg.HISTORY_PURGE.newLogEntry(stringArray);
        logger.debug((Object)scheduleLogEntry.getMessageText());
        ScheduleLogger.write((Connection)wrappedConnection, scheduleLogEntry);
        try {
            int n3;
            objectArray = null;
            try {
                objectArray = this.agentEventMonitorDM.getList();
            }
            catch (DataException dataException) {
                logger.debug((Object)"Error retrieving list of Agent Event Monitors", (Throwable)dataException);
            }
            if (objectArray != null && objectArray.length > 0) {
                try {
                    for (int i = 0; i < objectArray.length; ++i) {
                        try {
                            if (objectArray[i].isUseDefaultsForHistoryPurge()) {
                                l2 = l;
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Purging Agent Event History older than " + n + " days for Agent Event Monitor " + objectArray[i].getName()));
                                }
                            } else {
                                l2 = DateTranslator.getDaysOldAsMilliseconds((long)objectArray[i].getDaysToRetainHistory());
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Purging Agent Event History older than " + objectArray[i].getDaysToRetainHistory() + " days for Agent Event Monitor " + objectArray[i].getName()));
                                }
                            }
                            n3 = this.purgeHistoryForMonitor(l2, preparedStatement, objectArray[i].getOID());
                            n2 += n3;
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Purged " + n3 + " Agent Event History records for " + objectArray[i].getName()));
                            continue;
                        }
                        catch (Exception exception) {
                            logger.debug((Object)("Error purging Agent Event History for Agent Event Monitor " + objectArray[i].getName()), (Throwable)exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error purging Agent Event Histories", (Throwable)exception);
                }
            }
            try {
                object = this.getOrphanedHistoryMonitorIDs();
                if (object != null && ((Long[])object).length > 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Purging orphaned Agent Event History older than " + n + " days."));
                    }
                    for (n3 = 0; n3 < ((Long[])object).length; ++n3) {
                        try {
                            int n4 = this.purgeHistoryForMonitor(l, preparedStatement, object[n3]);
                            n2 += n4;
                            continue;
                        }
                        catch (Exception exception) {
                            logger.debug((Object)("Error purging Agent Event History for Agent Event Monitor " + object[n3]), (Throwable)exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                logger.debug((Object)"Error purging orphaned Agent Event Histories", (Throwable)exception);
            }
        }
        finally {
            AgentEventHistoryInfoDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, null);
        }
        if (n2 > 0) {
            objectArray = new String[]{String.valueOf(n2), string2};
            object = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry((String[])objectArray);
            ScheduleLogger.write((ScheduleLogEntry)object);
            logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
        }
        return n2;
    }

    private int purgeHistoryForMonitor(long l, PreparedStatement preparedStatement, long l2) throws SQLException, ResourceUnavailableException {
        preparedStatement.setLong(1, l2);
        preparedStatement.setLong(2, l);
        int n = 0;
        try {
        }
        catch (SQLException sQLException) {
            String string = MessageUtil.formatMsg((String)"SQL error while deleting the history for event {1}.", (Object[])new Object[]{l2});
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        return n += preparedStatement.executeUpdate();
    }

    private Long[] getOrphanedHistoryMonitorIDs() throws ResourceUnavailableException {
        Long[] longArray = new Long[]{};
        String string = "SELECT DISTINCT event_monitor_id FROM agent_event_histories LEFT JOIN agent_event_monitors ON event_monitor_id = agent_event_monitors.id WHERE agent_event_monitors.id IS NULL";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("event_monitor_id"));
            }
            longArray = arrayList.toArray(new Long[arrayList.size()]);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("SQL error while retrieving orphaned Agent Event History Monitor IDs.", (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return longArray;
    }
}

