/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.jdbc;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.busobj.AgentEnvironment;
import com.helpsystems.enterprise.core.busobj.AgentEnvironmentVariable;
import com.helpsystems.enterprise.core.dm.AgentEnvironmentDM;
import com.helpsystems.enterprise.core.dm.SkybotVariableDM;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class AgentEnvironmentDMJdbc
extends AbstractDatabaseManager
implements AgentEnvironmentDM {
    private static final Logger logger = Logger.getLogger(AgentEnvironmentDMJdbc.class);
    private static final String objDesc = "Agent Environment";
    private String ENVIRONMENTS_TABLE = "agent_environments";
    private String VARIABLES_TABLE = "agent_environment_variables";
    private final String JOBS_TABLE = "jobs";
    private String environmentTable;
    private String variablesTable;
    private String jobsTable;
    private SkybotVariableDM skybotVariableDM = null;

    public AgentEnvironmentDMJdbc(String string, String string2, SkybotVariableDM skybotVariableDM) throws ResourceUnavailableException {
        super(string);
        this.skybotVariableDM = skybotVariableDM;
        this.setName("ENTERPRISE.AgentEnvironmentDM");
        this.environmentTable = string2 + "." + this.ENVIRONMENTS_TABLE;
        this.variablesTable = string2 + "." + this.VARIABLES_TABLE;
        this.jobsTable = string2 + "." + "jobs";
    }

    @Override
    public AgentEnvironment get(long l) throws DataException, ResourceUnavailableException {
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        AgentEnvironmentGenerator agentEnvironmentGenerator = new AgentEnvironmentGenerator();
        String string = "SELECT";
        string = string + "  id ";
        string = string + ", coalesce( name, '')";
        string = string + ", coalesce( description, '')";
        string = string + ", environment_type";
        string = string + ", user_profile";
        string = string + ", working_path";
        string = string + ", coalesce( referenced_shared_id, 0)";
        string = string + ", encrypted_password";
        string = string + ", run_type_option";
        string = string + " from " + this.environmentTable + " where id=?";
        try {
            wrappedConnection = this.getConnection();
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            logger.trace((Object)("Running " + string + " with " + l));
            preparedStatement.setLong(1, l);
            Object object = preparedStatement.executeQuery();
            if (object.next()) {
                AgentEnvironment agentEnvironment;
                AgentEnvironment agentEnvironment2 = agentEnvironment = (AgentEnvironment)((Object)agentEnvironmentGenerator.generateObject((ResultSet)object));
                return agentEnvironment2;
            }
            try {
                throw new NoDataException("Agent Environment not found.");
            }
            catch (SQLException sQLException) {
                object = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException((String)object, (Throwable)sQLException);
            }
        }
        finally {
            AgentEnvironmentDMJdbc.closeEm((Connection)wrappedConnection, null, null);
        }
    }

    @Override
    public AgentEnvironment getByJobId(long l) throws DataException, ResourceUnavailableException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        AbstractDatabaseManager.WrappedConnection wrappedConnection;
        block5: {
            AgentEnvironment agentEnvironment;
            wrappedConnection = null;
            preparedStatement = null;
            resultSet = null;
            AgentEnvironmentGenerator agentEnvironmentGenerator = new AgentEnvironmentGenerator();
            String string = "SELECT";
            string = string + "  ae.id ";
            string = string + ", coalesce( ae.name, '')";
            string = string + ", coalesce( ae.description, '')";
            string = string + ", ae.environment_type";
            string = string + ", ae.user_profile";
            string = string + ", ae.working_path";
            string = string + ", coalesce( ae.referenced_shared_id, 0)";
            string = string + ", ae.encrypted_password";
            string = string + ", run_type_option";
            string = string + " from " + this.environmentTable + " as ae join " + this.jobsTable + " as j on j.agent_environment_id = ae.id where j.id=?";
            wrappedConnection = this.getConnection();
            preparedStatement = this.getDefaultPreparedStmt(string, (Connection)wrappedConnection);
            logger.trace((Object)("Running " + string + " with " + l));
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) break block5;
            AgentEnvironment agentEnvironment2 = agentEnvironment = (AgentEnvironment)((Object)agentEnvironmentGenerator.generateObject(resultSet));
            AgentEnvironmentDMJdbc.closeEm((Connection)wrappedConnection, (Statement)preparedStatement, (ResultSet)resultSet);
            return agentEnvironment2;
        }
        try {
            try {
                throw new NoDataException("Agent Environment not found.");
            }
            catch (SQLException sQLException) {
                String string = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} for id {1}.", (Object[])new Object[]{objDesc, Long.toString(l)});
                throw new ResourceUnavailableException(string, (Throwable)sQLException);
            }
        }
        catch (Throwable throwable) {
            AgentEnvironmentDMJdbc.closeEm((Connection)wrappedConnection, preparedStatement, resultSet);
            throw throwable;
        }
    }

    private String decryptPassword(String string) throws BadDataException, ResourceUnavailableException {
        String string2 = null;
        if (string != null && string.length() > 0) {
            try {
                string2 = UnacodeMash.unMash(string);
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to decode password.", (Throwable)exception);
            }
        }
        return string2;
    }

    private AgentEnvironmentVariable[] getAgentEnvironmentVariables(long l, Connection connection) throws ResourceUnavailableException, BadDataArrayException {
        AgentEnvironmentVariable[] agentEnvironmentVariableArray;
        block9: {
            PreparedStatement preparedStatement;
            ResultSet resultSet;
            block8: {
                AgentEnvironmentVariablesGenerator agentEnvironmentVariablesGenerator = new AgentEnvironmentVariablesGenerator();
                String string = "select";
                string = string + "  aev.id ";
                string = string + ", aev.agent_environment_id ";
                string = string + ", coalesce( aev.name , '' ) ";
                string = string + ", coalesce( aev.variable, '' ) ";
                string = string + ", coalesce( aev.automate_schedule_variable_id, 0 ) ";
                string = string + " from " + this.variablesTable + " aev ";
                string = string + " where aev.agent_environment_id = ? ";
                string = string + " order by upper(aev.name) ";
                resultSet = null;
                boolean bl = false;
                if (connection == null) {
                    preparedStatement = this.getDefaultPreparedStmt(string);
                } else {
                    bl = true;
                    preparedStatement = this.getDefaultPreparedStmt(string, connection);
                }
                try {
                    logger.trace((Object)("Running " + string + " with " + l));
                    preparedStatement.setLong(1, l);
                    resultSet = preparedStatement.executeQuery();
                    agentEnvironmentVariableArray = (AgentEnvironmentVariable[])agentEnvironmentVariablesGenerator.generateObjectArray(resultSet);
                    if (bl) break block8;
                }
                catch (Exception exception) {
                    try {
                        String string2 = "Error loading the list of Environment Variables.";
                        logger.error((Object)string2, (Throwable)exception);
                        throw new ResourceUnavailableException(string2, (Throwable)exception);
                    }
                    catch (Throwable throwable) {
                        if (!bl) {
                            this.closeConnection(preparedStatement);
                        } else {
                            AgentEnvironmentDMJdbc.closeEm(null, (Statement)preparedStatement, resultSet);
                        }
                        throw throwable;
                    }
                }
                this.closeConnection(preparedStatement);
                break block9;
            }
            AgentEnvironmentDMJdbc.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
        }
        return agentEnvironmentVariableArray;
    }

    private class AgentEnvironmentVariablesGenerator
    extends AbstractBusObjGenerator {
        AgentEnvironmentVariablesGenerator() {
            super(5, "Agent Environment Variables");
        }

        protected Object constructObject() {
            return new AgentEnvironmentVariable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentEnvironmentVariable agentEnvironmentVariable = (AgentEnvironmentVariable)((Object)object);
            switch (n) {
                case 1: {
                    agentEnvironmentVariable.setOid(resultSet.getLong(1));
                    break;
                }
                case 2: {
                    agentEnvironmentVariable.setParentOid(resultSet.getInt(2));
                    break;
                }
                case 3: {
                    agentEnvironmentVariable.setName(resultSet.getString(3));
                    break;
                }
                case 4: {
                    agentEnvironmentVariable.setVariable(resultSet.getString(4));
                    break;
                }
                case 5: {
                    Throwable throwable = null;
                    try {
                        long l = resultSet.getLong(5);
                        if (l == 0L) {
                            agentEnvironmentVariable.setSkybotVariable(null);
                        }
                        Connection connection = resultSet.getStatement().getConnection();
                        agentEnvironmentVariable.setSkybotVariable(AgentEnvironmentDMJdbc.this.skybotVariableDM.get(l, connection));
                    }
                    catch (DataException dataException) {
                        throwable = dataException;
                    }
                    catch (ResourceUnavailableException resourceUnavailableException) {
                        throwable = resourceUnavailableException;
                    }
                    finally {
                        if (throwable == null) break;
                        throw new ResourceUnavailableException("Automate Schedule Variable could not be retrieved", throwable);
                    }
                }
                default: {
                    throw new RuntimeException("Too many fields requested.");
                }
            }
        }
    }

    private class AgentEnvironmentGenerator
    extends AbstractBusObjGenerator {
        public AgentEnvironmentGenerator() {
            super(10, AgentEnvironmentDMJdbc.objDesc);
        }

        protected Object constructObject() {
            return new AgentEnvironment();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            AgentEnvironment agentEnvironment = (AgentEnvironment)((Object)object);
            switch (n) {
                case 1: {
                    agentEnvironment.setOid(resultSet.getLong(1));
                    break;
                }
                case 2: {
                    agentEnvironment.setName(resultSet.getString(2).trim());
                    break;
                }
                case 3: {
                    agentEnvironment.setDescription(Convert.trimR((String)resultSet.getString(3)));
                    break;
                }
                case 4: {
                    agentEnvironment.setType(resultSet.getInt(4));
                    break;
                }
                case 5: {
                    agentEnvironment.setUserProfile(Convert.trimR((String)resultSet.getString(5)));
                    break;
                }
                case 6: {
                    agentEnvironment.setWorkingPath(Convert.trimR((String)resultSet.getString(6)));
                    break;
                }
                case 7: {
                    agentEnvironment.setRefSharedOID(resultSet.getLong(7));
                    break;
                }
                case 8: {
                    try {
                        String string;
                        String string2 = string = AgentEnvironmentDMJdbc.this.decryptPassword(resultSet.getString("encrypted_password"));
                        agentEnvironment.setPassword(string2);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error loading password.", (Throwable)exception);
                    }
                    break;
                }
                case 9: {
                    agentEnvironment.setRunType(resultSet.getInt(9));
                    break;
                }
                case 10: {
                    Connection connection = resultSet.getStatement().getConnection();
                    try {
                        agentEnvironment.setVariableList(AgentEnvironmentDMJdbc.this.getAgentEnvironmentVariables(agentEnvironment.getOid(), connection));
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error loading Environment Variables.", (Throwable)exception);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

