/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.dm.IBMiJobInfoDM;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.helpsystems.enterprise.core.ibmi.IBMiJobInfo;
import com.helpsystems.enterprise.core.ibmi.IBMiJobStatus;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IBMiJobInfoDMImpl
implements IBMiJobInfoDM {
    private static final Logger logger = Logger.getLogger(IBMiJobInfoDMImpl.class);
    private static final byte[] BLANKS16 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    @Override
    public IBMiJobInfo getJobInfo(long l, IBMiJobIdentifier iBMiJobIdentifier) throws ActionFailedException {
        ValidationHelper.checkForNull((String)"Job Identifier", (Object)iBMiJobIdentifier);
        HashMap<Long, IBMiJobIdentifier> hashMap = new HashMap<Long, IBMiJobIdentifier>();
        hashMap.put(l, iBMiJobIdentifier);
        Map<Long, IBMiJobInfo> map = this.getJobInfo(hashMap);
        return map.get(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, IBMiJobInfo> getJobInfo(Map<Long, IBMiJobIdentifier> map) throws ActionFailedException {
        AS400 aS400;
        ValidationHelper.checkForNull((String)"Jobs map", map);
        try {
            aS400 = this.createAS400ObjectandValidateUser();
        }
        catch (ActionFailedException actionFailedException) {
            throw new ActionFailedException("Unable to retrieve job information.", (Throwable)actionFailedException);
        }
        try {
            Map<Long, IBMiJobInfo> map2 = this.getJobInfo(map, aS400);
            return map2;
        }
        finally {
            if (aS400 != null && aS400.isConnected()) {
                try {
                    aS400.disconnectAllServices();
                }
                catch (Exception exception) {
                    try {
                        logger.error((Object)"Error while trying to disconnect. The error will be ignored.", (Throwable)exception);
                    }
                    catch (Exception exception2) {}
                }
            }
        }
    }

    private Map<Long, IBMiJobInfo> getJobInfo(Map<Long, IBMiJobIdentifier> map, AS400 aS400) {
        CharConverter charConverter;
        HashMap<Long, IBMiJobInfo> hashMap = new HashMap<Long, IBMiJobInfo>();
        AS400Text aS400Text = new AS400Text(10, aS400);
        AS400Text aS400Text2 = new AS400Text(6, aS400);
        try {
            charConverter = new CharConverter(aS400.getCcsid(), aS400);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new IllegalArgumentException("");
        }
        byte[] byArray = new byte[]{-47, -42, -62, -55, -16, -14, -16, -16};
        int n = 226;
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(n);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray((int)n));
        programParameterArray[2] = new ProgramParameter(byArray);
        programParameterArray[4] = new ProgramParameter(BLANKS16);
        Set<Map.Entry<Long, IBMiJobIdentifier>> set = map.entrySet();
        for (Map.Entry<Long, IBMiJobIdentifier> entry : set) {
            Long l = entry.getKey();
            IBMiJobIdentifier iBMiJobIdentifier = entry.getValue();
            programParameterArray[3] = new ProgramParameter(this.createQualifiedJobName(iBMiJobIdentifier, aS400Text, aS400Text2));
            ProgramCall programCall = new ProgramCall(aS400, "/QSYS.LIB/QUSRJOBI.PGM", programParameterArray);
            try {
                IBMiJobInfo iBMiJobInfo = this.getJobInfo(programCall, charConverter);
                hashMap.put(l, iBMiJobInfo);
            }
            catch (AS400Exception aS400Exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to retrieve the job information for {0}. Cause: {1}", (Object[])new Object[]{iBMiJobIdentifier, this.concatenateAS400Messages(aS400Exception)}));
            }
            catch (Exception exception) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to retrieve the job information for {0}.", (Object[])new Object[]{iBMiJobIdentifier}), (Throwable)exception);
            }
        }
        return hashMap;
    }

    private IBMiJobInfo getJobInfo(ProgramCall programCall, CharConverter charConverter) throws AS400SecurityException, ErrorCompletingRequestException, IOException, ObjectDoesNotExistException, InterruptedException {
        boolean bl;
        boolean bl2 = bl = !programCall.run();
        if (bl) {
            AS400Message[] aS400MessageArray = programCall.getMessageList();
            if (this.isJobNotFoundMessage(aS400MessageArray)) {
                return null;
            }
            throw new AS400Exception(aS400MessageArray);
        }
        byte[] byArray = programCall.getParameterList()[0].getOutputData();
        return this.extractJobInfo(byArray, charConverter);
    }

    @Override
    public IBMiJobStatus getStatus(IBMiJobIdentifier iBMiJobIdentifier) {
        return IBMiJobStatus.ACTIVE;
    }

    private String concatenateAS400Messages(AS400Exception aS400Exception) {
        String string = "";
        for (AS400Message aS400Message : aS400Exception.getAS400MessageList()) {
            String string2 = MessageUtil.formatMsg((String)"{0} - {1}", (Object[])new Object[]{aS400Message.getID(), aS400Message.getText()});
            string = string + " " + string2;
        }
        return Convert.trimL((String)string);
    }

    private AS400 createAS400ObjectandValidateUser() throws ActionFailedException {
        String string = IBMiAgent.getAS400SystemName();
        String string2 = IBMiAgent.getAS400UserName();
        String string3 = IBMiAgent.getAS400Password();
        AS400 aS400 = new AS400(string, string2, string3);
        try {
            aS400.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            logger.debug((Object)"Warning: The AS400 object rejected the property setGuiAvailable(false). GUI prompting may occur.");
        }
        AS400.setPasswordExpirationWarningDays((int)-1);
        try {
            aS400.validateSignon();
        }
        catch (IOException iOException) {
            throw new ActionFailedException("Unable to validate the user ID and password, due to an I/O error.", (Throwable)iOException);
        }
        catch (AS400SecurityException aS400SecurityException) {
            throw new ActionFailedException("Unable to validate the user ID and password.", (Throwable)aS400SecurityException);
        }
        return aS400;
    }

    private byte[] createQualifiedJobName(IBMiJobIdentifier iBMiJobIdentifier, AS400Text aS400Text, AS400Text aS400Text2) {
        if (aS400Text.getByteLength() != 10 || aS400Text2.getByteLength() != 6) {
            throw new IllegalArgumentException("Program error: parm length incorrect.");
        }
        byte[] byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        aS400Text.toBytes((Object)iBMiJobIdentifier.getJobName(), byArray);
        aS400Text.toBytes((Object)iBMiJobIdentifier.getJobUser(), byArray, 10);
        aS400Text2.toBytes((Object)iBMiJobIdentifier.getJobNumber(), byArray, 20);
        return byArray;
    }

    private IBMiJobInfo extractJobInfo(byte[] byArray, CharConverter charConverter) {
        IBMiJobInfo iBMiJobInfo = new IBMiJobInfo();
        String string = charConverter.byteArrayToString(byArray, 50, 10);
        iBMiJobInfo.setJobStatus(IBMiJobStatus.persistanceCodeToEnum(Convert.trimR((String)string)));
        if (iBMiJobInfo.getJobStatus() == IBMiJobStatus.ACTIVE) {
            String string2 = charConverter.byteArrayToString(byArray, 107, 4);
            iBMiJobInfo.setActiveJobStatus(Convert.trimR((String)string2));
        }
        return iBMiJobInfo;
    }

    private boolean isJobNotFoundMessage(AS400Message[] aS400MessageArray) {
        if (aS400MessageArray.length > 1) {
            return false;
        }
        String string = aS400MessageArray[0].getID().trim();
        return string.equalsIgnoreCase("CPF3C53") || string.equalsIgnoreCase("CPF3C55");
    }
}

