/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.access.ibmi;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.busobj.JobStatusCode;
import com.helpsystems.enterprise.core.dm.IBMiJobDM;
import com.helpsystems.enterprise.core.ibmi.IBMiAgent;
import com.helpsystems.enterprise.core.ibmi.IBMiJob;
import com.helpsystems.enterprise.core.ibmi.IBMiJobIdentifier;
import com.helpsystems.enterprise.core.ibmi.IBMiJobStatus;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class IBMiJobDMImpl
implements IBMiJobDM {
    private static final Logger logger = Logger.getLogger(IBMiJobDMImpl.class);
    private static String library = IBMiAgent.getProdlib();
    private static final String JOB_TABLE = "SKYJOB";
    private String jobTable = library + "." + "SKYJOB";

    @Override
    public void clearActiveJobStatuses() throws ResourceUnavailableException {
        this.clearActiveJobStatusTimestamps();
        String string = "UPDATE " + this.jobTable + " SET jobactsts= '' WHERE jobactsts<> ''";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while clearing the active job statuses.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public IBMiJob[] getActiveJobs() {
        ArrayList arrayList = new ArrayList();
        throw new IllegalStateException("Method getActiveJobs is not implemented.");
    }

    @Override
    public IBMiJob[] getJobs() throws ResourceUnavailableException {
        IBMiJobGenerator iBMiJobGenerator = new IBMiJobGenerator();
        String string = "SELECT jobid, jobhid, jobsts, jobname, jobuser, jobnum, jobibmsts, jobactsts, jobststs FROM " + this.jobTable + " WHERE jobsts <> ' '";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        ArrayList<IBMiJob> arrayList = new ArrayList<IBMiJob>();
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    IBMiJob iBMiJob = (IBMiJob)iBMiJobGenerator.generateObject(resultSet);
                    arrayList.add(iBMiJob);
                }
                catch (BadDataException badDataException) {
                    String string2 = this.constructBadDataDetails(badDataException.getErrorList());
                    logger.error((Object)MessageUtil.formatMsg((String)"Unable to determine the state of IBM i job, due to corrupt data.{0}", (Object[])new Object[]{string2}));
                }
            }
        }
        catch (SQLException sQLException) {
            String string3 = "SQL error while retrieving the list of jobs.";
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new IBMiJob[arrayList.size()]);
    }

    @Override
    public void updateIBMiJobStatus(long l, IBMiJobStatus iBMiJobStatus) throws ResourceUnavailableException {
        String string = "UPDATE " + this.jobTable + " SET jobibmsts=?, jobststs=? " + "WHERE jobhid=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, iBMiJobStatus.persistanceCode());
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                logger.debug((Object)MessageUtil.formatMsg((String)"Tried to update the job status of run ID {0} to {1}, but the db row was no longer there.", (Object[])new Object[]{l, iBMiJobStatus}));
            } else if (n > 1) {
                String string2 = MessageUtil.formatMsg((String)"Program error: More than job row was updated for run ID {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string2);
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while updating the job status for run ID {0} to {1}.", (Object[])new Object[]{l, iBMiJobStatus});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    @Override
    public void updateIBMiActiveJobStatus(long l, String string) throws ResourceUnavailableException {
        String string2 = "UPDATE " + this.jobTable + " SET jobactsts=?, jobststs=? " + "WHERE jobhid=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setLong(2, System.currentTimeMillis());
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                logger.debug((Object)MessageUtil.formatMsg((String)"Tried to update the active job status of run ID {0} to {1}, but the db row was no longer there.", (Object[])new Object[]{l, string}));
            } else if (n > 1) {
                String string3 = MessageUtil.formatMsg((String)"Program error: More than job row was updated for run ID {0}.", (Object[])new Object[]{l});
                throw new RuntimeException(string3);
            }
        }
        catch (SQLException sQLException) {
            String string4 = MessageUtil.formatMsg((String)"SQL error while updating the active job status for run ID {0} to {1}.", (Object[])new Object[]{l, string});
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void clearActiveJobStatusTimestamps() throws ResourceUnavailableException {
        String string = "UPDATE " + this.jobTable + " SET jobststs= 0 " + "WHERE jobactsts<> '' AND (jobibmsts=? OR jobibmsts='')";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setString(1, IBMiJobStatus.ACTIVE.persistanceCode());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while clearing the active job status timestamps.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private PreparedStatement getDefaultPreparedStmt(String string) throws ResourceUnavailableException {
        Connection connection = this.getJDBCConnection();
        Object var3_3 = null;
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            AbstractDatabaseManager.closeEm((Connection)connection, var3_3, null);
            connection = null;
            var3_3 = null;
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
    }

    private Connection getJDBCConnection() throws ResourceUnavailableException {
        String string = IBMiAgent.getJDBCDriver();
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"JDBC driver {0} not found.", (Object[])new Object[]{string}));
        }
        String string2 = IBMiAgent.getJDBCSystemName();
        String string3 = IBMiAgent.getJDBCConnectionURL(string2);
        String string4 = IBMiAgent.getJDBCUserName();
        String string5 = IBMiAgent.getJDBCPassword();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string3, string4, string5);
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while trying to establish a JDBC connection to {0}.", (Object[])new Object[]{string2}), (Throwable)sQLException);
        }
        if (connection == null) {
            throw new ResourceUnavailableException("Unable to get a JDBC Connection.");
        }
        return connection;
    }

    private void closeConnection(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("Statement cannot be null.");
        }
        Connection connection = null;
        try {
            connection = statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ResultSet resultSet = null;
        try {
            resultSet = statement.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AbstractDatabaseManager.closeEm((Connection)connection, (Statement)statement, (ResultSet)resultSet);
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    private class IBMiJobGenerator
    extends AbstractBusObjGenerator {
        public IBMiJobGenerator() {
            super(6, "IBMiJob");
        }

        protected Object constructObject() {
            return new IBMiJob();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            IBMiJob iBMiJob = (IBMiJob)object;
            switch (n) {
                case 1: {
                    iBMiJob.setJobHistoryID(resultSet.getLong("jobhid"));
                    break;
                }
                case 2: {
                    iBMiJob.setJobID(resultSet.getLong("jobid"));
                    break;
                }
                case 3: {
                    String string = Convert.trimR((String)resultSet.getString("jobsts"));
                    iBMiJob.setJobStatus(JobStatusCode.persistanceCodeToEnum(string));
                    break;
                }
                case 4: {
                    String string = Convert.trimR((String)resultSet.getString("jobname"));
                    String string2 = Convert.trimR((String)resultSet.getString("jobuser"));
                    String string3 = Convert.trimR((String)resultSet.getString("jobnum"));
                    iBMiJob.setJobIdentifier(new IBMiJobIdentifier(string, string2, string3));
                    break;
                }
                case 5: {
                    String string = Convert.trimR((String)resultSet.getString("jobibmsts"));
                    iBMiJob.setIBMiJobStatus(IBMiJobStatus.persistanceCodeToEnum(string));
                    break;
                }
                case 6: {
                    iBMiJob.setActiveJobStatus(Convert.trimR((String)resultSet.getString("jobactsts")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }

        protected void validate(Object object) {
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            ((IBMiJob)object).validate();
        }
    }
}

