/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class PrintJVMProperties {
    public static void main(String[] stringArray) {
        try {
            PrintJVMProperties.printAll();
        }
        finally {
            System.exit(0);
        }
    }

    public static void printAll() {
        PrintJVMProperties.printSystemProperties();
        PrintJVMProperties.printEnvironmentVariables();
    }

    public static void printSystemProperties() {
        try {
            PrintJVMProperties.printGroupHeader("System Properties");
            Properties properties = System.getProperties();
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            Set<Map.Entry<Object, Object>> set = properties.entrySet();
            for (Map.Entry<Object, Object> entry : set) {
                treeMap.put(entry.getKey(), entry.getValue());
            }
            PrintJVMProperties.printSortedEntrySet(treeMap.entrySet());
        }
        catch (Throwable throwable) {
            PrintJVMProperties.writeln("Error printing system properties.");
            throwable.printStackTrace();
        }
    }

    public static void printEnvironmentVariables() {
        try {
            PrintJVMProperties.printGroupHeader("Environment Variables");
            Map<String, String> map = System.getenv();
            TreeMap<String, String> treeMap = new TreeMap<String, String>(map);
            PrintJVMProperties.printSortedEntrySet(treeMap.entrySet());
        }
        catch (Throwable throwable) {
            PrintJVMProperties.writeln("Error printing environment variables.");
            throwable.printStackTrace();
        }
    }

    private static void printGroupHeader(String string) {
        PrintJVMProperties.writeln("**** " + string + " ****");
    }

    private static void printSortedEntrySet(Set<Map.Entry<String, String>> set) {
        for (Map.Entry<String, String> entry : set) {
            String string = entry.getKey();
            if (string.equals("line.separator")) continue;
            PrintJVMProperties.printDetailLine(entry);
        }
    }

    private static void printDetailLine(Map.Entry<String, String> entry) {
        PrintJVMProperties.writeln("\t" + entry.toString());
    }

    private static void writeln(String string) {
        System.out.println(string);
    }
}

