/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.schedule;

import com.helpsystems.common.core.schedule.SendRobotData;
import junit.framework.TestCase;

public class SendRobotDataTest
extends TestCase {
    SendRobotData srd;

    protected void setUp() throws Exception {
        super.setUp();
        this.srd = new SendRobotData();
    }

    protected void tearDown() throws Exception {
        this.srd = null;
        super.tearDown();
    }

    public void testBuildSndMsgCommand() {
        this.srd = new SendRobotData("MYNAME", "B");
        String string = this.srd.buildSndMsgCommand();
        String string2 = "SNDRBTDTA PRQJOB(MYNAME) STATUS(B)";
        SendRobotDataTest.assertEquals((String)string2, (String)string);
        this.srd.setJobNumber("000000123456");
        string = this.srd.buildSndMsgCommand();
        string2 = "SNDRBTDTA PRQJOB#(000000123456) STATUS(B)";
        SendRobotDataTest.assertEquals((String)string2, (String)string);
        this.srd = new SendRobotData("MYNAME", "000000123456", "T");
        string = this.srd.buildSndMsgCommand();
        string2 = "SNDRBTDTA PRQJOB#(000000123456) STATUS(T)";
        SendRobotDataTest.assertEquals((String)string2, (String)string);
    }

    public void testBuildSndMsgCommandRequiresJobNameOrNumber() {
        try {
            this.srd.buildSndMsgCommand();
            SendRobotDataTest.fail((String)"buildSndMsgCommand() didn't require job name or number");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.srd.setJobName("  ");
        this.srd.setJobNumber("123456");
        try {
            this.srd.buildSndMsgCommand();
            SendRobotDataTest.fail((String)"buildSndMsgCommand() didn't require valid job name or number");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testSetJobName() {
        this.srd.setJobName("JobName");
        SendRobotDataTest.assertEquals((String)"JobName", (String)this.srd.getJobName());
        this.srd.setJobName(null);
        SendRobotDataTest.assertEquals((String)"", (String)this.srd.getJobName());
        this.srd.setJobName("Name   ");
        SendRobotDataTest.assertEquals((String)"Name", (String)this.srd.getJobName());
    }

    public void testSetJobNumber() {
        this.srd.setJobNumber("jobNumber");
        SendRobotDataTest.assertEquals((String)"jobNumber", (String)this.srd.getJobNumber());
        this.srd.setJobNumber(null);
        SendRobotDataTest.assertEquals((String)"", (String)this.srd.getJobNumber());
        this.srd.setJobNumber("Number   ");
        SendRobotDataTest.assertEquals((String)"Number", (String)this.srd.getJobNumber());
    }

    public void testSetStatusCode() {
        this.srd.setStatusCode("X");
        SendRobotDataTest.assertEquals((String)"X", (String)this.srd.getStatusCode());
        this.srd.setStatusCode(null);
        SendRobotDataTest.assertEquals((String)"B", (String)this.srd.getStatusCode());
        this.srd.setStatusCode("");
        SendRobotDataTest.assertEquals((String)"B", (String)this.srd.getStatusCode());
        this.srd.setStatusCode("  ");
        SendRobotDataTest.assertEquals((String)"B", (String)this.srd.getStatusCode());
        this.srd.setStatusCode(" X ");
        SendRobotDataTest.assertEquals((String)"X", (String)this.srd.getStatusCode());
    }
}

