/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.schedule;

import com.helpsystems.common.core.schedule.CommonScheduleJob;
import java.util.Arrays;
import junit.framework.TestCase;

public class CommonScheduleJobTest
extends TestCase {
    CommonScheduleJob csj;

    protected void setUp() throws Exception {
        super.setUp();
        this.csj = new CommonScheduleJob();
    }

    protected void tearDown() throws Exception {
        this.csj = null;
        super.tearDown();
    }

    public void testSetName() {
        this.csj.setName("  MyName  ");
        CommonScheduleJobTest.assertEquals((String)"MYNAME", (String)this.csj.getName());
    }

    public void testSetDescription() {
        this.csj.setDescription("  Test description  ");
        CommonScheduleJobTest.assertEquals((String)"Test description", (String)this.csj.getDescription());
    }

    public void testSetJobType() {
        this.csj.setJobType(" T ");
        CommonScheduleJobTest.assertEquals((String)"T", (String)this.csj.getJobType());
    }

    public void testSetJobName() {
        this.csj.setJobName(" MyName ");
        CommonScheduleJobTest.assertEquals((String)"MYNAME", (String)this.csj.getJobName());
    }

    public void testSetNotes() {
        this.csj.setNotes(" My Notes ");
        CommonScheduleJobTest.assertEquals((String)" My Notes ", (String)this.csj.getNotes());
    }

    public void testSetJobD() {
        this.csj.setJobD(" My Job D ");
        CommonScheduleJobTest.assertEquals((String)" My Job D ", (String)this.csj.getJobD());
    }

    public void testSetJobDLib() {
        this.csj.setJobDLib(" My Lib ");
        CommonScheduleJobTest.assertEquals((String)" My Lib ", (String)this.csj.getJobDLib());
    }

    public void testSetOutQ() {
        this.csj.setOutQ(" My Out Q ");
        CommonScheduleJobTest.assertEquals((String)" My Out Q ", (String)this.csj.getOutQ());
    }

    public void testSetOutQLib() {
        this.csj.setOutQLib(" My Out Q Lib ");
        CommonScheduleJobTest.assertEquals((String)" My Out Q Lib ", (String)this.csj.getOutQLib());
    }

    public void testSetJobNumber() {
        this.csj.setJobNumber(" My Job Num ");
        CommonScheduleJobTest.assertEquals((String)" My Job Num ", (String)this.csj.getJobNumber());
    }

    public void testSetCommandStrString() {
        this.csj.setCommandStr(" My Command String ");
        String[] stringArray = this.csj.getCommandStr();
        CommonScheduleJobTest.assertEquals((int)1, (int)stringArray.length);
        CommonScheduleJobTest.assertEquals((String)" My Command String ", (String)stringArray[0]);
    }

    public void testSetCommandStrStringArray() {
        String[] stringArray = new String[]{" Cmd String 1 ", " Cmd String 2 "};
        this.csj.setCommandStr(stringArray);
        String[] stringArray2 = this.csj.getCommandStr();
        CommonScheduleJobTest.assertEquals((int)2, (int)stringArray2.length);
        CommonScheduleJobTest.assertEquals((String)" Cmd String 1 ", (String)stringArray2[0]);
        CommonScheduleJobTest.assertEquals((String)" Cmd String 2 ", (String)stringArray2[1]);
    }

    public void testSetApplication() {
        this.csj.setApplication(" My Appl ");
        CommonScheduleJobTest.assertEquals((String)" My Appl ", (String)this.csj.getApplication());
    }

    public void testSetScheduleJobApplicationName() {
        this.csj.setScheduleJobApplicationName(" My Sched Job Appl Name ");
        CommonScheduleJobTest.assertEquals((String)" My Sched Job Appl Name ", (String)this.csj.getScheduleJobApplicationName());
    }

    public void testSetRunTimes() {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.csj.setRunTimes(nArray);
        int[] nArray2 = this.csj.getRunTimes();
        CommonScheduleJobTest.assertEquals((int)8, (int)nArray2.length);
        for (int i = 0; i < 8; ++i) {
            CommonScheduleJobTest.assertEquals((int)nArray2[i], (int)(i + 1));
        }
    }

    public void testSetRunTimesRequiresEightValues() {
        try {
            this.csj.setRunTimes(new int[]{1, 2, 3, 4});
            CommonScheduleJobTest.fail((String)"setRunTimes() accepted fewer than 8 run times");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.csj.setRunTimes(new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
            CommonScheduleJobTest.fail((String)"setRunTimes() accepted more than 8 run times");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetRunDays() {
        char[] cArray = new char[]{'1', '2', '3', '4', '5', '6', '7'};
        this.csj.setRunDays(cArray);
        char[] cArray2 = this.csj.getRunDays();
        CommonScheduleJobTest.assertEquals((int)7, (int)cArray2.length);
        for (int i = 0; i < 7; ++i) {
            CommonScheduleJobTest.assertEquals((char)cArray2[i], (char)((char)(49 + i)));
        }
    }

    public void testSetRunDaysRequiresEightValues() {
        try {
            this.csj.setRunDays(new char[]{'1', '2', '3', '4'});
            CommonScheduleJobTest.fail((String)"setRunDays() accepted fewer than 7 run days");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.csj.setRunDays(new char[]{'1', '2', '3', '4', '5', '6', '7', '8'});
            CommonScheduleJobTest.fail((String)"setRunDays() accepted more than 7 run days");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetPersistent() {
        this.csj.setPersistent(false);
        CommonScheduleJobTest.assertFalse((boolean)this.csj.isPersistent());
        this.csj.setPersistent(true);
        CommonScheduleJobTest.assertTrue((boolean)this.csj.isPersistent());
    }

    public void testValidate() {
        this.csj.setJobName("ValidName");
        this.csj.setNotes("xxxxxxxxxxxxxxxxxxxx");
        this.csj.setJobD("jobd");
        this.csj.setJobDLib("jobdlib");
        this.csj.setOutQ("outq");
        this.csj.setOutQLib("outqlib");
        this.csj.setCommandStr(new String[]{"valid command"});
        this.csj.setApplication("RBT");
        this.csj.setJobType("C");
        this.csj.validate();
        char[] cArray = new char[61];
        Arrays.fill(cArray, 'X');
        this.csj.setNotes(new String(cArray));
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for notes");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setNotes("xxxxxxxxxxxxxxxxxxxx");
        this.csj.setJobD("toolongforjobd");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for jobd");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setJobD("jobd");
        this.csj.setJobDLib("toolongforjobdlib");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for jobdlib");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setJobDLib("jobdlib");
        this.csj.setOutQ("toolongforoutq");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for outq");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setOutQ("outq");
        this.csj.setOutQLib("toolongforoutqlib");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for outqlib");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setOutQLib("outqlib");
        this.csj.setApplication("toolong");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long value for application");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setApplication("RBT");
        this.csj.setJobType("X");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted invalid value for job type");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setJobType("C");
        char[] cArray2 = new char[3001];
        Arrays.fill(cArray2, 'X');
        this.csj.setCommandStr(new String(cArray2));
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too long command");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setCommandStr(new String[0]);
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too few commands");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.csj.setCommandStr(new String[]{"string 1", "string 2", "string 3", "string 4", "string 5", "string 6", "string 7", "string 8", "string 9", "string 10", "too many strings"});
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted too many commands");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateRequiresJobName() {
        this.csj.setJobName("");
        try {
            this.csj.validate();
            CommonScheduleJobTest.fail((String)"validate() accepted no job name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateTruncatesDescription() {
        this.csj.setJobName("JOBNAME");
        this.csj.setJobType("C");
        this.csj.setDescription("abcdefghijklmnopqrstuvwxyz");
        CommonScheduleJobTest.assertEquals((String)"abcdefghijklmnopqrstuvwxyz", (String)this.csj.getDescription());
        this.csj.validate();
        CommonScheduleJobTest.assertEquals((String)"abcdefghijklmnopqrstuvwx", (String)this.csj.getDescription());
    }
}

