/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.reporting;

import com.helpsystems.common.core.reporting.ReportField;
import com.helpsystems.common.core.reporting.ReportSelectionCriteria;
import com.helpsystems.common.core.util.DateTranslator;
import java.io.IOException;
import java.util.Date;

public abstract class AbstractReportWriter {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int SIZE_LARGE = 1;
    public static final int SIZE_MEDIUM = 2;
    public static final int SIZE_SMALL = 3;
    private boolean reportOpen = false;
    private String previewText = null;

    protected void checkReportStatus() {
        if (!this.reportOpen) {
            throw new IllegalStateException("The current report is not open.");
        }
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return DateTranslator.formatShortDate(date);
    }

    public String formatTime(Date date) {
        if (date == null) {
            return "";
        }
        return DateTranslator.formatTime(date);
    }

    public String formatTimeStamp(Date date) {
        if (date == null) {
            return "";
        }
        return DateTranslator.formatDateTime(date);
    }

    public void closeReport() {
        this.reportOpen = false;
    }

    protected void setReportOpen() {
        this.reportOpen = true;
    }

    public void setPreviewText(String string) {
        this.previewText = string != null && string.trim().length() < 1 ? null : string;
    }

    public String getPreViewText() {
        return this.previewText;
    }

    public abstract String getFileName();

    public abstract int getCurrentPage();

    public abstract int getNextLine();

    public abstract void writeHeader(String var1, ReportSelectionCriteria[] var2, String var3, String var4) throws IOException;

    public abstract void writeFooter() throws IOException;

    public abstract void writePageBreak() throws IOException;

    public abstract void writeBlankLines(int var1) throws IOException;

    public abstract void writeSectionHeading(String var1, int var2, int var3) throws IOException;

    public abstract void writeFormattedLine(String var1) throws IOException;

    public abstract void writePairedValueTable_Start() throws IOException;

    public abstract void writePairedValueTable_Start(String var1, int var2) throws IOException;

    public abstract void writePairedValueTable_Entry(String var1, String var2, int[] var3) throws IOException;

    public abstract void writePairedValueTable_End() throws IOException;

    public abstract void addInset() throws IOException;

    public abstract void addInset(int var1) throws IOException;

    public abstract void removeInset() throws IOException;

    public abstract void removeInset(int var1) throws IOException;

    public abstract void writeTable_Start(String[] var1, int[] var2, boolean var3) throws IOException;

    public abstract void writeTable_Start(String[] var1, int[] var2, String var3, int var4, boolean var5) throws IOException;

    public abstract void writeTable_Entry(ReportField[] var1, boolean var2) throws IOException;

    public abstract void writeTable_End(boolean var1) throws IOException;

    public abstract void writeRowText_Start() throws IOException;

    public abstract void writeRowText_Entry(String var1) throws IOException;

    public abstract void writeRowText_End() throws IOException;
}

