/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.DataReplicationEntry;
import com.helpsystems.common.core.network.DataReplicationRequest;
import junit.framework.TestCase;

public class DataReplicationRequestTest
extends TestCase {
    DataReplicationRequest request;

    protected void setUp() throws Exception {
        super.setUp();
        this.request = new DataReplicationRequest();
    }

    protected void tearDown() throws Exception {
        this.request = null;
        super.tearDown();
    }

    public void testEqualsObject() {
        DataReplicationRequestTest.assertFalse((boolean)this.request.equals(null));
        DataReplicationRequestTest.assertFalse((boolean)this.request.equals(new Object()));
        this.request.setChangeType(1);
        this.request.setRequestMode(1);
        this.request.setNewCode(2397823459L);
        this.request.setChangeCode(349834);
        this.request.setTableName("table_name");
        this.request.setProductName("prod_name");
        this.request.setProductRelease("R25");
        this.request.setLibraryName("lib_name");
        this.request.setNodeProductIID(12345);
        this.request.setPiidFieldName("field_name");
        this.request.setProcessedByHost(false);
        DataReplicationRequest dataReplicationRequest = new DataReplicationRequest();
        dataReplicationRequest.setChangeType(1);
        dataReplicationRequest.setRequestMode(1);
        dataReplicationRequest.setNewCode(2397823459L);
        dataReplicationRequest.setChangeCode(349834);
        dataReplicationRequest.setTableName("table_name");
        dataReplicationRequest.setProductName("prod_name");
        dataReplicationRequest.setProductRelease("R25");
        dataReplicationRequest.setLibraryName("lib_name");
        dataReplicationRequest.setNodeProductIID(12345);
        dataReplicationRequest.setPiidFieldName("field_name");
        dataReplicationRequest.setProcessedByHost(false);
    }

    public void testAddEntry() {
        DataReplicationEntry[] dataReplicationEntryArray = this.request.getEntries();
        DataReplicationRequestTest.assertEquals((int)0, (int)dataReplicationEntryArray.length);
        DataReplicationEntry dataReplicationEntry = new DataReplicationEntry();
        dataReplicationEntry.setOriginalValue("orig_value");
        dataReplicationEntry.setNewValue("new_value");
        dataReplicationEntry.setColumnName("column_name");
        dataReplicationEntry.setEncoded(false);
        dataReplicationEntry.setSqlPlaceholder("placeholder");
        this.request.addEntry(dataReplicationEntry);
        dataReplicationEntryArray = this.request.getEntries();
        DataReplicationRequestTest.assertEquals((int)1, (int)dataReplicationEntryArray.length);
        DataReplicationRequestTest.assertEquals((Object)dataReplicationEntry, (Object)dataReplicationEntryArray[0]);
    }

    public void testAddEntryStatically() {
        DataReplicationRequest.addEntry(this.request, "column_name", "value");
        DataReplicationEntry[] dataReplicationEntryArray = this.request.getEntries();
        DataReplicationRequestTest.assertEquals((int)1, (int)dataReplicationEntryArray.length);
        DataReplicationEntry dataReplicationEntry = dataReplicationEntryArray[0];
        DataReplicationRequestTest.assertEquals((String)"column_name", (String)dataReplicationEntry.getColumnName());
        DataReplicationRequestTest.assertEquals((Object)"value", (Object)dataReplicationEntry.getNewValue());
    }

    public void testGetChangeType() {
        this.request.setChangeType(3);
        DataReplicationRequestTest.assertEquals((int)3, (int)this.request.getChangeType());
        this.request.setChangeType(1);
        DataReplicationRequestTest.assertEquals((int)1, (int)this.request.getChangeType());
        this.request.setChangeType(2);
        DataReplicationRequestTest.assertEquals((int)2, (int)this.request.getChangeType());
    }

    public void testSetChangeTypeRequiresValidValue() {
        try {
            this.request.setChangeType(-28382);
            DataReplicationRequestTest.fail((String)"setChangeType() accepted invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRequestMode() {
        this.request.setRequestMode(1);
        DataReplicationRequestTest.assertEquals((int)1, (int)this.request.getRequestMode());
        this.request.setRequestMode(2);
        DataReplicationRequestTest.assertEquals((int)2, (int)this.request.getRequestMode());
    }

    public void testSetRequestModeRequiresValidValue() {
        try {
            this.request.setRequestMode(-48721);
            DataReplicationRequestTest.fail((String)"setRequestMode() accepted invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetNewCode() {
        this.request.setNewCode(2397823459L);
        DataReplicationRequestTest.assertEquals((long)2397823459L, (long)this.request.getNewCode());
    }

    public void testGetChangeCode() {
        this.request.setChangeCode(349834);
        DataReplicationRequestTest.assertEquals((int)349834, (int)this.request.getChangeCode());
    }

    public void testGetTableName() {
        this.request.setTableName("table_name");
        DataReplicationRequestTest.assertEquals((String)"table_name", (String)this.request.getTableName());
    }

    public void testGetProductName() {
        this.request.setProductName("prod_name");
        DataReplicationRequestTest.assertEquals((String)"prod_name", (String)this.request.getProductName());
    }

    public void testGetProductRelease() {
        this.request.setProductRelease("R25");
        DataReplicationRequestTest.assertEquals((String)"R25", (String)this.request.getProductRelease());
    }

    public void testGetLibraryName() {
        this.request.setLibraryName("lib_name");
        DataReplicationRequestTest.assertEquals((String)"lib_name", (String)this.request.getLibraryName());
    }

    public void testGetNodeProductIID() {
        this.request.setNodeProductIID(12345);
        DataReplicationRequestTest.assertEquals((int)12345, (int)this.request.getNodeProductIID());
    }

    public void testGetPiidFieldName() {
        this.request.setPiidFieldName("field_name");
        DataReplicationRequestTest.assertEquals((String)"field_name", (String)this.request.getPiidFieldName());
    }

    public void testIsProcessedByHost() {
        this.request.setProcessedByHost(false);
        DataReplicationRequestTest.assertFalse((boolean)this.request.isProcessedByHost());
        this.request.setProcessedByHost(true);
        DataReplicationRequestTest.assertTrue((boolean)this.request.isProcessedByHost());
    }

    public void testRemoveAllEntries() {
        DataReplicationEntry dataReplicationEntry = new DataReplicationEntry();
        dataReplicationEntry.setOriginalValue("orig_value");
        dataReplicationEntry.setNewValue("new_value");
        dataReplicationEntry.setColumnName("column_name");
        dataReplicationEntry.setEncoded(false);
        dataReplicationEntry.setSqlPlaceholder("placeholder");
        this.request.addEntry(dataReplicationEntry);
        this.request.removeAllEntries();
        DataReplicationEntry[] dataReplicationEntryArray = this.request.getEntries();
        DataReplicationRequestTest.assertEquals((int)0, (int)dataReplicationEntryArray.length);
    }

    public void testClearEntries() {
        DataReplicationEntry dataReplicationEntry = new DataReplicationEntry();
        dataReplicationEntry.setOriginalValue("orig_value");
        dataReplicationEntry.setNewValue("new_value");
        dataReplicationEntry.setColumnName("column_name");
        dataReplicationEntry.setEncoded(false);
        dataReplicationEntry.setSqlPlaceholder("placeholder");
        this.request.addEntry(dataReplicationEntry);
        this.request.clearEntries();
        DataReplicationEntry[] dataReplicationEntryArray = this.request.getEntries();
        DataReplicationRequestTest.assertEquals((int)0, (int)dataReplicationEntryArray.length);
    }

    public void testIsSimilar() {
        this.request.setChangeType(1);
        this.request.setRequestMode(1);
        this.request.setNewCode(2397823459L);
        this.request.setChangeCode(349834);
        this.request.setTableName("table_name");
        this.request.setProductName("prod_name");
        this.request.setProductRelease("R25");
        this.request.setLibraryName("lib_name");
        this.request.setNodeProductIID(12345);
        this.request.setPiidFieldName("field_name");
        this.request.setProcessedByHost(false);
        DataReplicationRequest dataReplicationRequest = new DataReplicationRequest();
        dataReplicationRequest.setChangeType(1);
        dataReplicationRequest.setRequestMode(1);
        dataReplicationRequest.setNewCode(2397823459L);
        dataReplicationRequest.setChangeCode(349834);
        dataReplicationRequest.setTableName("table_name");
        dataReplicationRequest.setProductName("prod_name");
        dataReplicationRequest.setProductRelease("R25");
        dataReplicationRequest.setLibraryName("lib_name");
        dataReplicationRequest.setNodeProductIID(12345);
        dataReplicationRequest.setPiidFieldName("field_name");
        dataReplicationRequest.setProcessedByHost(false);
        DataReplicationRequestTest.assertFalse((boolean)this.request.equals(dataReplicationRequest));
        DataReplicationRequestTest.assertTrue((boolean)this.request.isSimilar(dataReplicationRequest));
    }
}

