/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.license.LicenseKey;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.IOException;

public class PointKey
extends LicenseKey {
    private static final long serialVersionUID = -213207821777468155L;
    public static final int ENC_KEY_LENGTH = 55;
    private int points;

    public PointKey() {
    }

    public PointKey(String string, String string2, long l, int n) {
        this.setProductCode(string);
        this.setHardwareCode(string2);
        this.setExpirationDate(l);
        this.setPoints(n);
    }

    public static PointKey createLicenseKey(String string, EncryptUtil encryptUtil) throws IOException {
        PointKey pointKey = new PointKey();
        pointKey.setEncryptedKey(string, encryptUtil);
        return pointKey;
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n) {
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("Invalid point value");
        }
        this.points = n;
    }

    @Override
    public void setEncryptedKey(String string, EncryptUtil encryptUtil) throws IOException {
        int n;
        if (encryptUtil == null) {
            throw new NullPointerException("The encryption utilities passed in were null.");
        }
        ValidationHelper.checkForNull("License", string);
        String string2 = EncryptUtil.cleanBeforeDecode(string);
        if (string2.length() == 55) {
            if (!PointKey.verifyChecksum(string2)) {
                throw new IOException("Checksum failed.");
            }
            string2 = string2.substring(0, 52);
        }
        byte[] byArray = null;
        try {
            byArray = encryptUtil.decodeBase32ToBinary(string2);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to decode the license key");
            iOException.initCause(exception);
            throw iOException;
        }
        String string3 = new String(byArray, "ISO8859_1");
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (stringBuffer.length() < 15) {
            throw new IOException("Decoded key length too small.");
        }
        string3 = stringBuffer.toString();
        this.setHardwareCode(string3.substring(0, 10));
        string3 = string3.substring(10);
        stringBuffer.delete(0, 10);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 8; i > -1; --i) {
            n = stringBuffer.charAt(i);
            if (n < 65 || n > 90) continue;
            stringBuffer2.append((char)n);
            stringBuffer.deleteCharAt(i);
        }
        this.setProductCode(stringBuffer2.reverse().toString());
        try {
            long l = Long.parseLong(stringBuffer.substring(0, 6)) * 10811194L;
            if (l < 0L) {
                l = 0L;
            }
            this.setExpirationDate(l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad data within encoded key.");
        }
        stringBuffer.delete(0, 6);
        char c = stringBuffer.charAt(0);
        this.setKeyType(c % 3);
        stringBuffer.delete(0, 1);
        while (stringBuffer.charAt(0) > '9') {
            n = stringBuffer.charAt(0);
            if (n > 128) {
                this.flags = (byte)(n &= 0x7F);
            }
            stringBuffer.deleteCharAt(0);
        }
        for (n = 0; n < stringBuffer.length() && Character.isDigit(stringBuffer.charAt(n)); ++n) {
        }
        String string4 = n == stringBuffer.length() ? stringBuffer.toString() : stringBuffer.substring(0, n);
        this.points = Integer.parseInt(string4);
        for (int i = 0; i < n; ++i) {
            stringBuffer.deleteCharAt(0);
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(' ');
        stringBuffer.append(this.points);
        stringBuffer.append(" points");
        switch (this.keyType) {
            case 0: {
                stringBuffer.append(", Trial license");
                break;
            }
            case 1: {
                stringBuffer.append(", Perm code");
                break;
            }
            case 2: {
                stringBuffer.append(", ELA key");
                break;
            }
            default: {
                stringBuffer.append(", unknown type");
            }
        }
        stringBuffer.append(", flags=0x");
        stringBuffer.append(Integer.toHexString(this.flags));
        return stringBuffer.toString();
    }
}

