/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import junit.framework.TestCase;

public class GenericSortFieldTest
extends TestCase {
    GenericSortField gsf;
    GenericSortField gsf2;

    protected void setUp() throws Exception {
        super.setUp();
        this.gsf = new GenericSortField(1001, 0);
        this.gsf2 = new GenericSortField(2002, 1);
        this.gsf.setSecondarySort(this.gsf2);
    }

    protected void tearDown() throws Exception {
        this.gsf = null;
        this.gsf2 = null;
        super.tearDown();
    }

    public void testGetField() {
        GenericSortFieldTest.assertEquals((int)1001, (int)this.gsf.getField());
        this.gsf.setField(2002);
        GenericSortFieldTest.assertEquals((int)2002, (int)this.gsf.getField());
    }

    public void testGetDirection() {
        GenericSortFieldTest.assertEquals((int)0, (int)this.gsf.getDirection());
        this.gsf.setDirection(1);
        GenericSortFieldTest.assertEquals((int)1, (int)this.gsf.getDirection());
    }

    public void testSetDirectionRejectsInvalidValues() {
        this.gsf.setDirection(0);
        GenericSortFieldTest.assertEquals((int)0, (int)this.gsf.getDirection());
        this.gsf.setDirection(1);
        GenericSortFieldTest.assertEquals((int)1, (int)this.gsf.getDirection());
        try {
            this.gsf.setDirection(-1234);
            GenericSortFieldTest.fail((String)"setDirection() accepted an invalid value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIsAscending() {
        GenericSortFieldTest.assertTrue((boolean)this.gsf.isAscending());
        this.gsf.setDirection(1);
        GenericSortFieldTest.assertFalse((boolean)this.gsf.isAscending());
    }

    public void testIsDescending() {
        GenericSortFieldTest.assertFalse((boolean)this.gsf.isDescending());
        this.gsf.setDirection(1);
        GenericSortFieldTest.assertTrue((boolean)this.gsf.isDescending());
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.gsf.doNotInvoke();
        GenericSortFieldTest.assertNull((Object)stringArray);
    }

    public void testGetSecondarySort() {
        this.gsf.setSecondarySort(this.gsf2);
        GenericSortFieldTest.assertEquals((Object)this.gsf2, (Object)this.gsf.getSecondarySort());
    }

    public void testSecondarySortCannotBePrimarySort() {
        this.gsf = new GenericSortField(1234, 0);
        try {
            this.gsf.setSecondarySort(this.gsf);
            GenericSortFieldTest.fail((String)"setSecondarySort() allowed primary sort field as secondary sort field");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSecondarySortNeedNotBeGenericSortField() {
        this.gsf = new GenericSortField(1234, 0);
        OtherSortField otherSortField = new OtherSortField(2345, 0);
        this.gsf.setSecondarySort(otherSortField);
        GenericSortFieldTest.assertEquals((Object)otherSortField, (Object)this.gsf.getSecondarySort());
    }

    public void testCloneRequiresSecondarySortIsAlsoGenericSortField() {
        this.gsf = new GenericSortField(1234, 0);
        OtherSortField otherSortField = new OtherSortField(2345, 0);
        this.gsf.setSecondarySort(otherSortField);
        try {
            this.gsf.clone();
            GenericSortFieldTest.fail((String)"clone() accepted secondary sort other than GenericSortField");
        }
        catch (RuntimeException runtimeException) {
            GenericSortFieldTest.assertTrue((boolean)runtimeException.getMessage().contains("secondary sort"));
        }
    }

    public void testClone() {
        GenericSortField genericSortField = (GenericSortField)this.gsf.clone();
        GenericSortFieldTest.assertTrue((boolean)this.gsf.equals(genericSortField));
        GenericSortFieldTest.assertFalse((this.gsf == genericSortField ? 1 : 0) != 0);
    }

    public void testEqualsObject() {
        GenericSortField genericSortField = new GenericSortField(1001, 0);
        genericSortField.setSecondarySort(new GenericSortField(2002, 1));
        GenericSortField genericSortField2 = new GenericSortField(1001, 1);
        genericSortField2.setSecondarySort(new GenericSortField(2002, 1));
        GenericSortField genericSortField3 = new GenericSortField(1003, 0);
        genericSortField3.setSecondarySort(new GenericSortField(2002, 1));
        GenericSortField genericSortField4 = new GenericSortField(1001, 0);
        GenericSortFieldTest.assertFalse((boolean)this.gsf.equals(null));
        GenericSortFieldTest.assertFalse((boolean)this.gsf.equals(new Object()));
        GenericSortFieldTest.assertTrue((boolean)this.gsf.equals(this.gsf));
        GenericSortFieldTest.assertFalse((boolean)genericSortField.equals(genericSortField2));
        GenericSortFieldTest.assertFalse((boolean)genericSortField.equals(genericSortField3));
        GenericSortFieldTest.assertFalse((boolean)genericSortField.equals(genericSortField4));
        GenericSortFieldTest.assertTrue((boolean)this.gsf.equals(genericSortField));
        GenericSortFieldTest.assertTrue((boolean)genericSortField.equals(this.gsf));
    }

    private class OtherSortField
    implements SortField {
        private int field;
        private int direction;

        public OtherSortField(int n, int n2) {
            this.field = n;
            this.direction = n2;
        }

        @Override
        public int getDirection() {
            return this.direction;
        }

        @Override
        public int getField() {
            return this.field;
        }

        @Override
        public SortField getSecondarySort() {
            return null;
        }

        @Override
        public boolean isAscending() {
            return this.direction == 0;
        }

        @Override
        public boolean isDescending() {
            return this.direction == 1;
        }
    }
}

