/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;

public class InstalledProduct
extends CommonVersionedObject {
    private static final long serialVersionUID = -9026444876191149837L;
    public static final int APPL_UNKNOWN = 0;
    public static final int APPL_SCHEDULE = 1;
    public static final int APPL_ALERT = 2;
    public static final int APPL_CONSOLE = 3;
    public static final int APPL_CPA = 4;
    public static final int APPL_EZVIEW = 5;
    public static final int APPL_HELPNET = 6;
    public static final int APPL_MAPICS = 7;
    public static final int APPL_MONITOR = 8;
    public static final int APPL_NETWORK = 9;
    public static final int APPL_NODE = 10;
    public static final int APPL_CONSOLE_MASTER = 11;
    public static final int APPL_MONITOR_MASTER = 12;
    public static final int APPL_REPORTS_MASTER = 13;
    public static final int APPL_SCHEDULE_MASTER = 14;
    public static final int APPL_SAVE_MASTER = 15;
    public static final int APPL_UPS_MASTER = 16;
    public static final int APPL_QUERY = 17;
    public static final int APPL_CORRAL = 18;
    public static final int APPL_REPLAY = 19;
    public static final int APPL_REPORTS = 20;
    public static final int APPL_REPORTS_DATA = 21;
    public static final int APPL_REPORTS_MERGE = 22;
    public static final int APPL_SAVE = 23;
    public static final int APPL_SAVE_DATA = 24;
    public static final int APPL_SPACE = 25;
    public static final int APPL_SYSLIB = 26;
    public static final int APPL_UPS = 27;
    public static final int APPL_CLIENT = 28;
    public static final int APPL_COMMON_JAVA = 29;
    public static final int APPL_AUTO_TUNE = 30;
    public static final int APPL_TRAPPER = 31;
    public static final int APPL_TRANSFORM = 32;
    public static final int APPL_SCHEDULE_JDE = 33;
    public static final int APPL_PORTAL = 34;
    public static final int APPL_LPAR = 35;
    public static final int APPL_SECURITY = 36;
    public static final int APPL_ENTERPRISE = 37;
    public static final int APPL_SET = 38;
    public static final int APPL_SEP = 39;
    public static final int APPL_SKYBOT_SCHEDULER = 40;
    public static final int APPL_ROBOT_BROWSER_INTERFACE = 34;
    static final String[] APPL = new String[]{"UNK", "RBT", "ALR", "CON", "CPA", "EVX", "HLP", "MAP", "MTR", "NET", "NOD", "CMS", "MMS", "RPM", "RMS", "SMS", "UMS", "RBQ", "ROL", "RPY", "REP", "RPD", "RMG", "RBS", "RSD", "SPC", "RSL", "UPS", "RCL", "RCJ", "AT", "TRP", "TRN", "RBJ", "POR", "LPR", "RSE", "RBE", "SET", "SEP", "SBS"};
    static final String[] TEXT = new String[]{"Unknown", "Robot/SCHEDULE", "Robot/ALERT", "Robot/CONSOLE", "Robot/CPA", "EZVIEW", "Help/NET", "Robot/MAPICS", "Robot/MONITOR", "Robot/NETWORK Host", "Robot/NETWORK Node", "Robot/CONSOLE Master Library", "Robot/MONITOR Master Library", "Robot/REPORTS Master Library", "Robot/SCHEDULE Master Library", "Robot/SAVE Master Library", "Robot/UPS Master Library", "Robot/QUERY", "Robot/CORRAL", "Robot/REPLAY", "Robot/REPORTS", "Robot/REPORTS Data Library", "Robot/MERGERMG", "Robot/SAVE", "Robot/SAVE Data Library", "Robot/SPACE", "Robot/SYSTEM Library", "Robot/UPS", "Robot/CLIENT", "Robot/Common Java", "Robot/AUTO TUNE", "Robot/TRAPPER", "Robot/TRANSFORM", "Robot/SCHEDULE - JDE", "Robot Browser Interface", "Robot/LPAR", "Robot/SECURITY", "Robot/SCHEDULE Enterprise", "Robot/SCHEDULE Enterprise Temporary", "Robot/SCHEDULE Enterprise Primary", "Automate Schedule"};
    private String applCode = "";
    private String relMod = "";
    private String libraryName = "";

    public InstalledProduct() {
    }

    public InstalledProduct(String string, String string2, String string3) {
        ValidationHelper.checkForNullAndBlank("Application Code", string);
        this.applCode = string.trim();
        this.relMod = string2 == null || string2.trim().length() == 0 ? "" : string2.trim();
        this.libraryName = string3 == null || string3.trim().length() == 0 ? "" : string3.trim();
    }

    public InstalledProduct(int n, String string, String string2) {
        this(InstalledProduct.getApplCode(n), string, string2);
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getApplCode() {
        return this.applCode;
    }

    public String getDescription() {
        return InstalledProduct.getDescription(this.applCode);
    }

    public boolean isInstalled() {
        return this.relMod.length() > 1 && this.libraryName.length() > 1;
    }

    public String getRelMod() {
        return this.relMod;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof InstalledProduct) {
            InstalledProduct installedProduct = (InstalledProduct)object;
            return installedProduct.applCode.equals(this.applCode);
        }
        return false;
    }

    public static int getNumApps() {
        return APPL.length;
    }

    public static String getDescription(String string) {
        for (int i = 0; i < APPL.length; ++i) {
            if (!APPL[i].equals(string)) continue;
            return TEXT[i];
        }
        return null;
    }

    public static String getApplCode(int n) {
        if (n < 0 || n > APPL.length) {
            throw new IllegalArgumentException("The index " + n + " is invalid.");
        }
        return APPL[n];
    }

    public static String getDescription(int n) {
        if (n < 0 || n > TEXT.length) {
            throw new IllegalArgumentException("The index " + n + " is invalid.");
        }
        return TEXT[n];
    }

    public static String[] getProductCodes() {
        String[] stringArray = new String[APPL.length];
        System.arraycopy(APPL, 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public static int getIDFromApplCode(String string) {
        ValidationHelper.checkForNull("Application Code", string);
        for (int i = 0; i < APPL.length; ++i) {
            if (!APPL[i].equals(string)) continue;
            return i;
        }
        throw new IllegalArgumentException("Application Code " + string + " is not defined.");
    }

    public void setApplCode(String string) {
        this.applCode = string;
    }

    public void setLibraryName(String string) {
        this.libraryName = string;
    }

    public void setRelMod(String string) {
        this.relMod = string;
    }

    public String[] doNotInvoke() {
        return new String[]{"getDescription", "isInstalled"};
    }
}

