/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import com.helpsystems.common.core.access.dataset.JoinedRowFilter;
import com.helpsystems.common.core.util.ValidationHelper;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;

public class JoinedDataSet<T>
implements DataSet {
    private static final Logger logger = Logger.getLogger(JoinedDataSet.class);
    protected ArrayList<CachingDataSet<T>> dataSetList = new ArrayList();
    protected boolean isClosed;
    private JoinedRowFilter rowFilter;
    protected List<int[]> joinList;
    protected Thread joiner;
    protected boolean keepJoining;
    protected Comparator comparator;

    public JoinedDataSet(Comparator comparator) {
        this.comparator = comparator;
        this.clearJoin();
    }

    protected void clearJoin() {
        if (this.joiner != null && this.joiner.isAlive()) {
            this.joiner.interrupt();
        }
        this.joiner = null;
        this.keepJoining = false;
        this.joinList = null;
    }

    public void add(DataSet<T> dataSet) throws DataSetException {
        ValidationHelper.checkForNull("DataSet", dataSet);
        this.checkIfClosed();
        if (this.joinList != null) {
            throw new IllegalStateException("Joining has already commenced.");
        }
        if (!(dataSet instanceof CachingDataSet)) {
            this.dataSetList.add(new CachingDataSet(dataSet));
        } else {
            this.dataSetList.add((CachingDataSet)dataSet);
        }
    }

    @Override
    public void close() {
        this.keepJoining = false;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        for (DataSet dataSet : this.dataSetList) {
            try {
                dataSet.close();
            }
            catch (DataSetException dataSetException) {
                logger.debug((Object)"Unable to close a DataSet", (Throwable)dataSetException);
            }
        }
    }

    protected void checkIfClosed() throws DataSetClosedException {
        if (this.isClosed) {
            throw new DataSetClosedException("This DataSet is Closed.");
        }
    }

    public T get(int n) throws DataSetException, BadDataException {
        Object[] objectArray;
        for (Object object : objectArray = this.getAll(n)) {
            if (object == null) continue;
            return (T)object;
        }
        throw new DataSetException("Invalid row, all values are null");
    }

    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        ErrorTable errorTable = new ErrorTable();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                objectArray[i] = this.get(n + i);
                continue;
            }
            catch (BadDataException badDataException) {
                errorTable.addException(n, badDataException);
            }
        }
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("One or more objects contains bad data.", objectArray, errorTable);
        }
        return objectArray;
    }

    public Object[] getAll(int n) throws DataSetException, BadDataException {
        this.checkIfClosed();
        Object[] objectArray = new Object[this.dataSetList.size()];
        if (objectArray.length == 0) {
            return objectArray;
        }
        if (objectArray.length == 1) {
            objectArray[0] = this.dataSetList.get(0).get(n);
            return objectArray;
        }
        this.blockForRow(n);
        if (n < 0 || n >= this.joinList.size()) {
            throw new IndexOutOfBoundsException("Invalid offset: " + n);
        }
        int[] nArray = this.joinList.get(n);
        for (int i = 0; i < objectArray.length; ++i) {
            CachingDataSet<T> cachingDataSet = this.dataSetList.get(i);
            if (nArray[i] <= -1) continue;
            objectArray[i] = cachingDataSet.get(nArray[i]);
        }
        return objectArray;
    }

    protected void joinOfSlow() throws DataSetException, BadDataException {
        int n = this.dataSetList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        CachingDataSet[] cachingDataSetArray = new CachingDataSet[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
            cachingDataSetArray[i] = this.dataSetList.get(i);
            nArray2[i] = cachingDataSetArray[i].size();
        }
        Object[] objectArray = new Object[n];
        logger.trace((Object)"Beginning merge-join");
        while (this.keepJoining && !this.isClosed) {
            int[] nArray3 = new int[n];
            Object t = null;
            for (int i = 0; i < n; ++i) {
                if (nArray[i] == nArray2[i]) {
                    nArray3[i] = -1;
                    objectArray[i] = null;
                    continue;
                }
                Object t2 = cachingDataSetArray[i].get(nArray[i]);
                if (t == null) {
                    t = t2;
                    nArray3[i] = nArray[i];
                    objectArray[i] = t2;
                    int n2 = i;
                    nArray[n2] = nArray[n2] + 1;
                    continue;
                }
                int n3 = this.comparator.compare(t, t2);
                if (n3 > 0) {
                    t = t2;
                    for (int j = 0; j < i; ++j) {
                        if (nArray3[j] > -1) {
                            int n4 = j;
                            nArray[n4] = nArray[n4] - 1;
                        }
                        nArray3[j] = -1;
                        objectArray[j] = null;
                    }
                    nArray3[i] = nArray[i];
                    objectArray[i] = t2;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                if (n3 == 0) {
                    nArray3[i] = nArray[i];
                    objectArray[i] = t2;
                    int n6 = i;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                nArray3[i] = -1;
                objectArray[i] = null;
            }
            if (t == null) break;
            if (this.rowFilter != null && !this.rowFilter.keep(this, objectArray)) continue;
            this.joinList.add(nArray3);
        }
        logger.trace((Object)"  join done!");
    }

    public void startJoin() {
        if (this.joinList != null) {
            throw new IllegalStateException("Join has already been run.");
        }
        this.joinList = new ArrayList<int[]>();
        this.joiner = new Thread(){

            @Override
            public void run() {
                this.setName("JoinedDataSet join Thread");
                try {
                    JoinedDataSet.this.keepJoining = true;
                    JoinedDataSet.this.joinOfSlow();
                }
                catch (Exception exception) {
                    logger.debug((Object)"Error while doing join", (Throwable)exception);
                    JoinedDataSet.this.close();
                }
            }
        };
        this.joiner.start();
    }

    @Override
    public int size() throws DataSetException {
        this.blockForRow(-1);
        return this.joinList.size();
    }

    private void blockForRow(int n) throws DataSetClosedException {
        if (this.joinList == null) {
            this.startJoin();
        }
        while (this.joiner.isAlive()) {
            this.checkIfClosed();
            if (n > -1 && this.joinList != null && this.joinList.size() > n) {
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void main(String[] stringArray) throws Exception {
        ArrayDataSet<String> arrayDataSet = new ArrayDataSet<String>(new String[]{"B", "Q", "X", "Z"});
        ArrayDataSet<String> arrayDataSet2 = new ArrayDataSet<String>(new String[]{"A", "B", "Z"});
        ArrayDataSet<String> arrayDataSet3 = new ArrayDataSet<String>(new String[]{"A", "Q", "R", "T", "Y", "Z"});
        JoinedDataSet<String> joinedDataSet = new JoinedDataSet<String>(Collator.getInstance());
        joinedDataSet.add(arrayDataSet);
        joinedDataSet.add(arrayDataSet2);
        joinedDataSet.add(arrayDataSet3);
        System.out.println("Size = " + joinedDataSet.size());
        for (int i = 0; i < joinedDataSet.size(); ++i) {
            Object[] objectArray = joinedDataSet.getAll(i);
            for (int j = 0; j < objectArray.length; ++j) {
                if (j > 0) {
                    System.out.print("\t");
                }
                if (objectArray[j] != null) {
                    System.out.print(objectArray[j]);
                    continue;
                }
                System.out.print("-");
            }
            System.out.println();
        }
    }

    public JoinedRowFilter getRowFilter() {
        return this.rowFilter;
    }

    public void setRowFilter(JoinedRowFilter joinedRowFilter) {
        if (this.joinList != null) {
            throw new IllegalStateException("Join has already started.");
        }
        this.rowFilter = joinedRowFilter;
    }
}

