/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import java.io.Serializable;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class WinStartAgent {
    private static boolean verbose = false;

    private WinStartAgent() {
    }

    private static void printHelp() {
        System.out.println("Need the following args:");
        System.out.println("\tconfigFile     Optional - The Agent's configuration file name (Default is agent.xml)");
        System.out.println("\tservicePort    Optional - The port to use when connecting to the Agent Server");
    }

    public static void main(String[] peerID) {
        Object object;
        AgentServiceEntry[] agentServiceEntryArray2;
        if (peerID == null) {
            WinStartAgent.printHelp();
            return;
        }
        int n = -1;
        String string = null;
        for (AgentServiceEntry[] agentServiceEntryArray2 : peerID) {
            if ("-v".equals(agentServiceEntryArray2)) {
                verbose = true;
                continue;
            }
            if (string == null) {
                string = agentServiceEntryArray2;
                continue;
            }
            if (n == -1) {
                try {
                    n = Integer.parseInt((String)agentServiceEntryArray2);
                    continue;
                }
                catch (Exception exception) {
                    WinStartAgent.finished("Unable to parse port number '" + (String)agentServiceEntryArray2 + "'.", null, 1);
                }
            }
            WinStartAgent.finished("Unrecognized paramater: " + (String)agentServiceEntryArray2, null, 1);
        }
        if (string == null) {
            string = "agent.xml";
        }
        if (n == -1) {
            n = 57471;
        }
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} [%c] %t> %m\n"), "System.out"));
        Logger.getRootLogger().setLevel(Level.WARN);
        Log4jInit.setInitialized((boolean)true);
        PeerID peerID2 = null;
        SimplePeer simplePeer = null;
        try {
            simplePeer = SimplePeer.createAnInstance();
            object = new PeerDescriptor("localhost", n, 7, "Unknown");
            peerID2 = simplePeer.connectToPeer((PeerDescriptor)object, (Serializable)((Object)WinStartAgent.class.getName()));
            ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)simplePeer));
        }
        catch (Exception exception) {
            WinStartAgent.finished("Unable to connect to the local Agent Server on port " + n, exception, 1);
        }
        object = (AgentServiceAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)peerID2, (String)"ENTERPRISE.AgentServiceAM");
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray2 = object.getEntries()) {
            if (!agentServiceEntry.getFilename().equalsIgnoreCase(string)) continue;
            AgentProcessInfo agentProcessInfo = object.getProcess(agentServiceEntry);
            if (agentProcessInfo != null && agentProcessInfo.isAlive()) {
                WinStartAgent.finished("Agent is already running.", null, 0);
            }
            try {
                object.startAgent(agentServiceEntry);
            }
            catch (Exception exception) {
                WinStartAgent.finished("Unable to start Agent", exception, 1);
            }
            WinStartAgent.finished("Agent started.", null, 0);
        }
        WinStartAgent.finished("Service does not contain an entry for a configuration file named '" + string + "'.", null, 1);
    }

    static void finished(String string, Exception exception, int n) {
        if (n == 0) {
            if (string != null) {
                System.out.println(string);
            }
        } else if (string != null) {
            System.err.println(string);
        }
        if (verbose && exception != null) {
            exception.printStackTrace();
        }
        System.exit(n);
    }
}

