/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.service;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.SimplePeer;
import com.helpsystems.common.tl.access.TLManagerRegistryPlugin;
import com.helpsystems.common.tl.dm.RemoteEventAM;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.enterprise.service.AgentProcessInfo;
import com.helpsystems.enterprise.service.AgentProcessListener;
import com.helpsystems.enterprise.service.AgentProcessListenerAdapter;
import com.helpsystems.enterprise.service.AgentServiceAM;
import com.helpsystems.enterprise.service.AgentServiceAMImpl;
import com.helpsystems.enterprise.service.AgentServiceEntry;
import com.sun.jna.platform.win32.Kernel32;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class WinClusterStartAgent {
    private static final Logger logger = Logger.getLogger(WinClusterStartAgent.class);
    private static final String PROCESS_NAME = "Skybot Scheduler Cluster Agent Process";
    private static FileAppender appender;
    private boolean verbose = false;
    private AgentProcessInfo startedInfo = null;
    private AgentServiceEntry startedEntry = null;
    private AgentProcessListener listener = null;
    private int servicePort = -1;
    private String fileName = null;
    private PeerID remotePeerID = null;
    private SimplePeer peer = null;
    private AgentServiceAM agentServiceAM = null;
    private int pid = -1;
    private String currentComputerName;

    public WinClusterStartAgent(String[] stringArray) {
        logger.addAppender((Appender)WinClusterStartAgent.getAppender(stringArray[0]));
        logger.setLevel(Level.DEBUG);
        Log4jInit.setInitialized((boolean)true);
        this.logInfo("Skybot Scheduler Cluster Agent Process started.");
        this.init(stringArray);
    }

    private void init(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray.length == 1) {
                String[] stringArray2 = stringArray[0].split("\\s+");
                this.parseParms(stringArray2);
            } else {
                this.parseParms(stringArray);
            }
        }
        if (this.fileName == null) {
            this.fileName = "agent.xml";
        }
        if (this.servicePort == -1) {
            this.servicePort = 57471;
        }
        this.currentComputerName = System.getenv().get("COMPUTERNAME");
        this.logInfo("Starting Cluster service using computer name: " + this.currentComputerName);
    }

    public static FileAppender getAppender(String string) {
        String string2 = string.substring(0, string.length() - 4);
        if (appender == null) {
            try {
                appender = new RollingFileAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} %t> %m\n"), "WinClusterStartAgent_" + string2 + ".log");
            }
            catch (IOException iOException) {
                System.out.println("Error adding RollingFileAppender for log4j. " + iOException.getMessage());
            }
        }
        return appender;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null || stringArray[0].trim().length() < 5) {
            WinClusterStartAgent.printHelp();
            return;
        }
        WinClusterStartAgent winClusterStartAgent = new WinClusterStartAgent(stringArray);
        winClusterStartAgent.startUp();
    }

    public void startUp() {
        this.attemptToConnect();
        try {
            this.startAgentIfConnected();
            this.registerHeartbeat();
        }
        catch (Exception exception) {
            this.finished("Unable to start and register Agent", exception, 1);
        }
    }

    private void attemptToConnect() {
        int n = -1;
        try {
            this.peer = SimplePeer.createAnInstance();
        }
        catch (PeerStartupException peerStartupException) {
            this.finished("Unable to connect to the local Agent Service on port " + this.servicePort + ". (1)", (Exception)((Object)peerStartupException), 1);
        }
        PeerDescriptor peerDescriptor = new PeerDescriptor("localhost", this.servicePort, 7, "Unknown");
        String string = "Unable to connect to the local Agent Service on port " + this.servicePort + ".";
        while (this.remotePeerID == null && n++ < 180) {
            try {
                this.logDebug("Attempting to connect to " + peerDescriptor);
                this.logDebug("If no message after this, Agent Server may be inactive.");
                this.remotePeerID = this.peer.connectToPeer(peerDescriptor, (Serializable)((Object)WinClusterStartAgent.class.getName()));
                if (this.remotePeerID != null) continue;
                try {
                    this.logDebug("About to sleep 1000 ...");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    this.finished(string + " (2)", interruptedException, 2);
                }
            }
            catch (Exception exception) {
                this.finished(string + " (3)", exception, 3);
            }
        }
        ManagerRegistry.setPlugin((ManagerRegistryPlugin)new TLManagerRegistryPlugin((Peer)this.peer));
        this.agentServiceAM = (AgentServiceAM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.remotePeerID, (String)"ENTERPRISE.AgentServiceAM");
        if (this.agentServiceAM == null) {
            this.finished("Unable to connect to the local Agent Service on port " + this.servicePort + ". (4)", null, 4);
        }
        this.logInfo("Connected to Agent Service on port number " + this.servicePort);
    }

    private void startAgentIfConnected() throws Exception {
        AgentServiceEntry agentServiceEntry = this.getOurAgentEntry();
        if (agentServiceEntry != null) {
            if (this.verbose) {
                logger.setLevel(Level.DEBUG);
            } else {
                logger.setLevel(agentServiceEntry.getLoggingLevel());
            }
            this.logDebug("Logging level set to " + logger.getLevel());
            this.logDebug("Checking Agent " + agentServiceEntry.getFilename() + "...");
            AgentProcessInfo agentProcessInfo = null;
            agentProcessInfo = this.agentServiceAM.getProcess(agentServiceEntry);
            this.startedEntry = agentServiceEntry;
            try {
                if (agentProcessInfo == null || !agentProcessInfo.isAlive()) {
                    this.logInfo("Starting Agent " + this.startedEntry.getFilename());
                    this.agentServiceAM.startAgentAs(this.startedEntry, this.currentComputerName);
                } else {
                    this.logInfo("Agent " + this.startedEntry.getFilename() + " is already started.");
                    this.startedInfo = agentProcessInfo;
                }
                this.pid = Kernel32.INSTANCE.GetCurrentProcessId();
                this.logDebug("Register PID " + this.pid + " with Agent " + this.startedEntry.getFilename() + " ...");
                this.registerWithService();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.finished("Unable to start Agent", exception, 1);
            }
        } else {
            this.logError("Unable to Start Agent. Entry for " + this.fileName + " is missing.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerHeartbeat() {
        boolean bl = false;
        this.logDebug("Registering Shutdown Hook...");
        this.registerShutdownHook();
        int n = -1;
        boolean bl2 = true;
        try {
            while (!bl) {
                this.startedInfo = this.agentServiceAM.getProcess(this.startedEntry);
                if (this.startedInfo != null && this.startedInfo.isAlive()) {
                    if (bl2) {
                        this.logInfo("Agent " + this.startedEntry.getFilename() + " is alive.  Shutdown Hook established.");
                        bl2 = false;
                    }
                    n = -1;
                    try {
                        Thread.sleep(6000L);
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            this.logDebug("Attempting to stop Agent...");
                            this.agentServiceAM.stopAgent(this.startedEntry, true);
                        }
                        catch (Exception exception) {
                            this.finished("Unable to stop Agent", exception, 40);
                        }
                    }
                }
                int n2 = ++n;
                ++n;
                if (n2 <= 3) continue;
                this.finished("Agent was stopped, so we are ending.", null, 0);
            }
            if (this.startedEntry == null) {
                this.finished("Service does not contain an entry for a configuration file named '" + this.fileName + "'.", null, 1);
            }
        }
        finally {
            if (this.startedEntry == null) {
                this.logInfo("Ending Cluster service; no Agent to end.");
            } else {
                this.logDebug("Ending Cluster service; attempting to end Agent.");
                try {
                    this.agentServiceAM.stopAgent(this.startedEntry, true);
                }
                catch (Exception exception) {
                    this.finished("Unable to stop Agent", exception, 40);
                }
            }
        }
    }

    private AgentServiceEntry getOurAgentEntry() throws Exception {
        AgentServiceEntry[] agentServiceEntryArray;
        for (AgentServiceEntry agentServiceEntry : agentServiceEntryArray = this.agentServiceAM.getEntries()) {
            if (!agentServiceEntry.getFilename().equalsIgnoreCase(this.fileName)) continue;
            return agentServiceEntry;
        }
        throw new Exception("Unable to find Service Entry for " + this.fileName + ".");
    }

    private void registerWithService() {
        if (this.agentServiceAM instanceof AgentServiceAMImpl) {
            this.logDebug("Adding listener for PID (" + this.pid + ") ...");
            this.listener = new ClusterAgentProcessListener(this.startedInfo);
            this.agentServiceAM.addListener(this.listener);
        } else {
            try {
                this.listener = new ClusterAgentProcessListener(this.startedInfo);
                this.logDebug("Adding remote listener for PID (" + this.pid + ") via TL ...");
                RemoteEventAM remoteEventAM = (RemoteEventAM)ManagerRegistry.getManager((String)"PEER.RemoteEventAM");
                remoteEventAM.addListenerToPeer(this.remotePeerID, (SimpleEventListener)new AgentProcessListenerAdapter(this.listener));
            }
            catch (Exception exception) {
                this.logError("Unable to attach event listener to ServicePeer.");
                exception.printStackTrace();
            }
        }
        this.logDebug("Adding remote Process Monitor for PID (" + this.pid + ") ...");
        this.agentServiceAM.addProcessMonitor(this.pid, this.startedEntry, this.currentComputerName);
    }

    private void parseParms(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        this.servicePort = n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if ("-v".equalsIgnoreCase(string)) {
                this.verbose = true;
                this.logInfo("verbose is selected");
                continue;
            }
            if (string != null && string.toUpperCase().endsWith(".XML")) {
                if (this.fileName != null) continue;
                this.fileName = string;
                continue;
            }
            if (!string.startsWith("-")) {
                try {
                    this.servicePort = n = Integer.parseInt(string);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.logInfo("Ignoring unrecognized parameter: " + string);
        }
    }

    private static void printHelp() {
        System.out.println("Need the following args:");
        System.out.println("\tconfigFile.xml Required - The Agent's configuration file name.");
        System.out.println("                          (The Agent should be manually managed).");
        System.out.println("\tservicePort    Optional - The port to connect to the Agent Service.");
        System.out.println("                          (Only required if you changed default.).");
        System.out.println("\t-v             Optional - Run in verbose mode.");
    }

    private void registerPOSIXHook(String string, SignalHandler signalHandler) {
        try {
            Signal.handle(new Signal(string), signalHandler);
        }
        catch (Throwable throwable) {
            System.out.println("Unable to register signal " + string);
        }
    }

    private void registerShutdownHook() {
        SignalHandler signalHandler = new SignalHandler(){

            @Override
            public void handle(Signal signal) {
                try {
                    WinClusterStartAgent.this.logDebug("Sending signal to stop Agent (" + WinClusterStartAgent.this.startedEntry.getFilename() + ")...");
                    WinClusterStartAgent.this.agentServiceAM.stopAgent(WinClusterStartAgent.this.startedEntry, true);
                }
                catch (Exception exception) {
                    WinClusterStartAgent.this.finished("Unable to stop Agent", exception, 40);
                }
            }
        };
        this.registerPOSIXHook("INT", signalHandler);
        this.registerPOSIXHook("TERM", signalHandler);
    }

    private void logInfo(String string) {
        logger.info((Object)string);
        System.out.println(string);
    }

    private void logDebug(String string) {
        logger.debug((Object)string);
        System.out.println(string);
    }

    private void logError(String string) {
        logger.error((Object)string);
        System.err.println(string);
    }

    private void logError(String string, Exception exception) {
        logger.error((Object)string, (Throwable)exception);
        System.err.println(string);
    }

    private void finished(String string, Exception exception, int n) {
        if (n == 0) {
            if (string != null) {
                this.logInfo(string);
            }
        } else if (string != null) {
            if (exception != null) {
                this.logError(string, exception);
            } else {
                this.logError(string);
            }
        }
        this.logInfo("Skybot Scheduler Cluster Agent Process ended.");
        System.exit(n);
    }

    private class ClusterAgentProcessListener
    implements AgentProcessListener {
        private AgentProcessInfo ours;

        public ClusterAgentProcessListener(AgentProcessInfo agentProcessInfo) {
            this.ours = agentProcessInfo;
        }

        @Override
        public void logGrew(AgentProcessInfo agentProcessInfo, String[] stringArray) {
        }

        @Override
        public void processStarted(AgentProcessInfo agentProcessInfo) {
        }

        @Override
        public void processEnded(AgentProcessInfo agentProcessInfo) {
            if (this.ours.equals(agentProcessInfo)) {
                WinClusterStartAgent.this.finished("The agent has ended.", null, 0);
            }
        }
    }
}

