/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.snmp;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.SNMPTrap;
import com.helpsystems.common.core.busobj.SNMPTrapManager;
import com.helpsystems.common.core.dm.SNMPTrapAM;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SNMPTrapAMImpl
extends AbstractManager
implements SNMPTrapAM {
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private SnmpIPAddress snmpIpAddr = null;

    public SNMPTrapAMImpl(String string) {
        this.setName("COMMON.SNMPTrapAM");
        if (string != null && string.length() > 0) {
            try {
                this.snmpIpAddr = new SnmpIPAddress(InetAddress.getByName(string));
            }
            catch (UnknownHostException unknownHostException) {
                throw new NullPointerException("Error retrieving InetAddress for address " + string);
            }
        }
        try {
            this.snmpIpAddr = new SnmpIPAddress(InetAddress.getByName(LOOPBACK_ADDRESS));
        }
        catch (UnknownHostException unknownHostException) {
            throw new NullPointerException("Error retrieving InetAddress for loopback address");
        }
    }

    public void sendColdStart(String string, SNMPTrapManager sNMPTrapManager) throws ActionFailedException {
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.setEnterprise(string);
        snmpPduTrap.setGeneric(6);
        snmpPduTrap.setSpecific(0);
        snmpPduTrap.setTimeStamp(0L);
        this.doSendTrap(snmpPduTrap, sNMPTrapManager);
    }

    public void sendTrap(SNMPTrap sNMPTrap, SNMPTrapManager sNMPTrapManager) throws ActionFailedException {
        this.sendTrap(sNMPTrap, sNMPTrapManager, System.currentTimeMillis());
    }

    public void sendTrap(SNMPTrap sNMPTrap, SNMPTrapManager sNMPTrapManager, long l) throws ActionFailedException {
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        long l2 = (System.currentTimeMillis() - l) / 10L;
        snmpPduTrap.setTimeStamp(l2);
        snmpPduTrap.setEnterprise(sNMPTrap.getEnterprise());
        snmpPduTrap.setGeneric(6);
        snmpPduTrap.setSpecific(sNMPTrap.getSpecificCode());
        String[] stringArray = sNMPTrap.getVariableBindingNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = sNMPTrap.getVariableBinding(stringArray[i]);
            SnmpVarBind snmpVarBind = this.createVarBind(stringArray[i], string);
            snmpPduTrap.addVarBind(snmpVarBind);
        }
        this.doSendTrap(snmpPduTrap, sNMPTrapManager);
    }

    public SnmpVarBind createVarBind(String string, String string2) {
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        snmpVarBind.setName(string);
        SnmpOctetString snmpOctetString = new SnmpOctetString();
        snmpOctetString.setString(string2);
        snmpVarBind.setValue((SnmpSyntax)snmpOctetString);
        return snmpVarBind;
    }

    private void doSendTrap(SnmpPduTrap snmpPduTrap, SNMPTrapManager sNMPTrapManager) throws ActionFailedException {
        snmpPduTrap.setAgentAddress(this.snmpIpAddr);
        snmpPduTrap.setGeneric(6);
        SnmpTrapSession snmpTrapSession = null;
        try {
            snmpTrapSession = new SnmpTrapSession(null, 0);
        }
        catch (SocketException socketException) {
            throw new ActionFailedException("Unable to start SNMP Trap Session for " + sNMPTrapManager.getManagerAddress(), (Throwable)socketException);
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(sNMPTrapManager.getManagerAddress());
        }
        catch (UnknownHostException unknownHostException) {
            throw new ActionFailedException("Unable to resolve IP Address for " + sNMPTrapManager.getManagerAddress(), (Throwable)unknownHostException);
        }
        int n = 162;
        try {
            n = sNMPTrapManager.getPortNumber();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n2 = 8000;
        try {
            n2 = sNMPTrapManager.getTimeout();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SnmpPeer snmpPeer = new SnmpPeer(inetAddress, n);
        snmpPeer.setTimeout(n2);
        SnmpParameters snmpParameters = snmpPeer.getParameters();
        snmpParameters.setReadCommunity(sNMPTrapManager.getCommunityName());
        snmpPeer.setParameters(snmpParameters);
        try {
            snmpTrapSession.send(snmpPeer, snmpPduTrap);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Error sending SNMP Trap", (Throwable)exception);
        }
        finally {
            try {
                snmpTrapSession.close();
            }
            catch (Exception exception) {}
        }
    }
}

