/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.OS400ObjectListFilter;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class OS400ObjectListParameters {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400ObjectListParameters.class);
    private static final Logger logger = Logger.getLogger(OS400ObjectListParameters.class);
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private AS400 as400;
    private final int ccsid;
    double verRel = 0.0;

    public OS400ObjectListParameters(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
        try {
            int n = aS400.getVersion();
            int n2 = aS400.getRelease();
            this.verRel = new Double(n + "." + n2);
        }
        catch (Exception exception) {
            logger.debug((Object)"Error getting system Version/Release.", (Throwable)exception);
        }
    }

    public ProgramParameter[] getParms(OS400ObjectListFilter oS400ObjectListFilter) {
        int n = 1;
        int n2 = n * 120;
        ProgramParameter[] programParameterArray = null;
        if (this.verRel < 5.2) {
            logger.trace((Object)"Loading pre-V5R2 parameter list...");
            int[] nArray = new int[]{202, 203, 301};
            programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(bin4_.toBytes(n2)), new ProgramParameter(80), this.getRecordCountParm(), this.getSortParm(), this.getObjectLibraryParm(oS400ObjectListFilter), this.getObjectTypeParm(oS400ObjectListFilter), this.getAuthorityControlParm(oS400ObjectListFilter.getLibAutList(), oS400ObjectListFilter.getObjAutList()), this.getSelectionControlParm(), this.getFieldsCountParm(nArray), this.getFieldsParm(nArray), this.getErrorParm()};
        } else {
            logger.trace((Object)"Loading V5R2 parameter list...");
            int[] nArray = new int[]{202, 203, 301, 605};
            programParameterArray = new ProgramParameter[]{new ProgramParameter(n2), new ProgramParameter(bin4_.toBytes(n2)), new ProgramParameter(80), this.getRecordCountParm(), this.getSortParm(), this.getObjectLibraryParm(oS400ObjectListFilter), this.getObjectTypeParm(oS400ObjectListFilter), this.getAuthorityControlParm(oS400ObjectListFilter.getLibAutList(), oS400ObjectListFilter.getObjAutList()), this.getSelectionControlParm(), this.getFieldsCountParm(nArray), this.getFieldsParm(nArray), this.getErrorParm(), this.getJobIDInfoParm(), this.getFormatOfJobIDInfoParm(), this.getASPControlParm(oS400ObjectListFilter)};
        }
        return programParameterArray;
    }

    private ProgramParameter getRecordCountParm() {
        return new ProgramParameter(bin4_.toBytes(-1));
    }

    private ProgramParameter getSortParm() {
        byte[] byArray = null;
        byArray = bin4_.toBytes(0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getObjectLibraryParm(OS400ObjectListFilter oS400ObjectListFilter) {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[20];
        aS400Text.toBytes((Object)oS400ObjectListFilter.getObject(), byArray, 0);
        aS400Text.toBytes((Object)oS400ObjectListFilter.getLibrary(), byArray, 10);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getObjectTypeParm(OS400ObjectListFilter oS400ObjectListFilter) {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[10];
        aS400Text.toBytes((Object)oS400ObjectListFilter.getType(), byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getAuthorityControlParm(String[] stringArray, String[] stringArray2) {
        int n;
        int n2;
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        int n3 = 28;
        int n4 = 0;
        int n5 = n3;
        int n6 = stringArray2.length;
        int n7 = n3 + 10 * n6;
        int n8 = stringArray.length;
        int n9 = 0;
        int n10 = n3 + 10 * n6 + n8 * 10;
        byte[] byArray = new byte[n10];
        BinaryConverter.intToByteArray((int)n10, (byte[])byArray, (int)0);
        BinaryConverter.intToByteArray((int)n4, (byte[])byArray, (int)4);
        BinaryConverter.intToByteArray((int)n5, (byte[])byArray, (int)8);
        BinaryConverter.intToByteArray((int)n6, (byte[])byArray, (int)12);
        BinaryConverter.intToByteArray((int)n7, (byte[])byArray, (int)16);
        BinaryConverter.intToByteArray((int)n8, (byte[])byArray, (int)20);
        BinaryConverter.intToByteArray((int)n9, (byte[])byArray, (int)20);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            n = n5 + n2 * 10;
            logger.debug((Object)("Object authority list item #" + (n2 + 1) + ": " + stringArray2[n2]));
            aS400Text.toBytes((Object)stringArray2[n2], byArray, n);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = n7 + n2 * 10;
            logger.debug((Object)("Library authority list item #" + (n2 + 1) + ": " + stringArray[n2]));
            aS400Text.toBytes((Object)stringArray2[n2], byArray, n);
        }
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getSelectionControlParm() {
        AS400Text aS400Text = new AS400Text(1, this.ccsid, this.as400);
        int n = 21;
        int n2 = 1;
        int n3 = 20;
        int n4 = 1;
        int n5 = 0;
        String string = "A";
        byte[] byArray = new byte[21];
        BinaryConverter.intToByteArray((int)n, (byte[])byArray, (int)0);
        BinaryConverter.intToByteArray((int)n2, (byte[])byArray, (int)4);
        BinaryConverter.intToByteArray((int)n3, (byte[])byArray, (int)8);
        BinaryConverter.intToByteArray((int)n4, (byte[])byArray, (int)12);
        BinaryConverter.intToByteArray((int)n5, (byte[])byArray, (int)16);
        aS400Text.toBytes((Object)string, byArray, 20);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getFieldsCountParm(int[] nArray) {
        return new ProgramParameter(bin4_.toBytes(nArray.length));
    }

    private ProgramParameter getFieldsParm(int[] nArray) {
        byte[] byArray = new byte[4 * nArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            BinaryConverter.intToByteArray((int)nArray[i], (byte[])byArray, (int)n);
            n += 4;
        }
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getErrorParm() {
        return new ProgramParameter(bin4_.toBytes(0));
    }

    private ProgramParameter getJobIDInfoParm() {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[10];
        aS400Text.toBytes((Object)"*", byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getFormatOfJobIDInfoParm() {
        AS400Text aS400Text = new AS400Text(8, this.ccsid, this.as400);
        byte[] byArray = new byte[8];
        aS400Text.toBytes((Object)"JIDF0000", byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getASPControlParm(OS400ObjectListFilter oS400ObjectListFilter) {
        String string = oS400ObjectListFilter.getASPFilterType();
        String string2 = oS400ObjectListFilter.getASPFilterDevice();
        boolean bl = oS400ObjectListFilter.isIncludeSysbas();
        logger.trace((Object)("Setting ASP Control Parameter: " + string2 + "/" + string + "/" + bl));
        if (string.equals("*ASPGRP") && bl) {
            logger.trace((Object)"Overriding QGYOLOBJ ASP control parameter.");
            string = "";
            string2 = "*";
        }
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        int n = 24;
        byte[] byArray = new byte[n];
        BinaryConverter.intToByteArray((int)n, (byte[])byArray, (int)0);
        aS400Text.toBytes((Object)string2, byArray, 4);
        aS400Text.toBytes((Object)string, byArray, 14);
        return new ProgramParameter(byArray);
    }
}

