/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.util;

import com.helpsystems.common.as400.busobj.OS400Object;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class OS400ObjectDescriptionParameters {
    public static final int V5R1_RECEIVER_LENGTH = 572;
    public static final int V5R2_RECEIVER_LENGTH = 598;
    private static final Logger logger = Logger.getLogger(OS400ObjectDescriptionParameters.class);
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(OS400ObjectDescriptionParameters.class);
    private static final AS400Bin4 bin4_ = new AS400Bin4();
    private AS400 as400;
    private final int ccsid;
    private int osVersion;
    private int osRelease;
    private static final String OBJD0400 = "OBJD0400";

    public OS400ObjectDescriptionParameters(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException(rbh.getText("the_system_is_null"));
        }
        this.as400 = aS400;
        this.ccsid = this.as400.getCcsid();
        try {
            this.osVersion = aS400.getVersion();
            this.osRelease = aS400.getRelease();
        }
        catch (Exception exception) {
            logger.debug((Object)"Error getting system Version/Release.", (Throwable)exception);
        }
    }

    public ProgramParameter[] getParms(OS400Object oS400Object) {
        ProgramParameter[] programParameterArray = null;
        double d = new Double(this.osVersion + "." + this.osRelease);
        programParameterArray = d >= 5.2 ? new ProgramParameter[]{new ProgramParameter(598), new ProgramParameter(bin4_.toBytes(598)), this.getFormatParm(), this.getObjectLibraryParm(oS400Object), this.getObjectTypeParm(oS400Object), this.getErrorParm(), this.getASPParm(oS400Object)} : new ProgramParameter[]{new ProgramParameter(572), new ProgramParameter(bin4_.toBytes(572)), this.getFormatParm(), this.getObjectLibraryParm(oS400Object), this.getObjectTypeParm(oS400Object), this.getErrorParm()};
        return programParameterArray;
    }

    private ProgramParameter getFormatParm() {
        AS400Text aS400Text = new AS400Text(8, this.ccsid, this.as400);
        byte[] byArray = new byte[8];
        aS400Text.toBytes((Object)OBJD0400, byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getObjectLibraryParm(OS400Object oS400Object) {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[20];
        aS400Text.toBytes((Object)oS400Object.getObject(), byArray, 0);
        aS400Text.toBytes((Object)oS400Object.getLibrary(), byArray, 10);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getObjectTypeParm(OS400Object oS400Object) {
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[10];
        aS400Text.toBytes((Object)oS400Object.getType(), byArray, 0);
        return new ProgramParameter(byArray);
    }

    private ProgramParameter getErrorParm() {
        return new ProgramParameter(bin4_.toBytes(0));
    }

    private ProgramParameter getASPParm(OS400Object oS400Object) {
        int n = 24;
        String string = "";
        String string2 = "*ASP";
        String string3 = "*ASPGRP";
        String string4 = oS400Object.getAspDevice();
        if (string4 == null || string4.trim().length() == 0) {
            throw new IllegalArgumentException(rbh.getText("asp_device_is_not_specified"));
        }
        logger.trace((Object)("Getting object from ASP Device: " + oS400Object.getAspDevice()));
        AS400Text aS400Text = new AS400Text(10, this.ccsid, this.as400);
        byte[] byArray = new byte[24];
        BinaryConverter.intToByteArray((int)n, (byte[])byArray, (int)0);
        if (string4.startsWith("*")) {
            aS400Text.toBytes((Object)string4, byArray, 4);
            aS400Text.toBytes((Object)string, byArray, 14);
        } else if (string4.equals("*SYSBAS")) {
            aS400Text.toBytes((Object)string4, byArray, 4);
            aS400Text.toBytes((Object)string3, byArray, 14);
        } else {
            aS400Text.toBytes((Object)string4, byArray, 4);
            aS400Text.toBytes((Object)string2, byArray, 14);
        }
        return new ProgramParameter(byArray);
    }
}

