/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.parser;

import com.helpsystems.common.as400.prompter.busobj.Dependency;
import com.helpsystems.common.as400.prompter.busobj.DependencyControl;
import com.helpsystems.common.as400.prompter.busobj.PromptControlEvaluator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DepParser {
    public static Dependency parse(Element element) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string = element.getNodeName();
        if (!"Dep".equalsIgnoreCase(string)) {
            throw new RuntimeException("The element passed in is a " + string + ". It should be 'Dep'");
        }
        Dependency dependency = new Dependency();
        if (element.hasAttribute("CtlKwdRel")) {
            dependency.setOperator(PromptControlEvaluator.mapOperator(element.getAttribute("CtlKwdRel")));
        }
        if (element.hasAttribute("CtlKwd")) {
            dependency.setKeyword(element.getAttribute("CtlKwd"));
        }
        if (element.hasAttribute("CmpVal")) {
            dependency.setCompareValue(element.getAttribute("CmpVal"));
        }
        if (element.hasAttribute("NbrTrueRel")) {
            dependency.setNumberTrueOperator(PromptControlEvaluator.mapOperator(element.getAttribute("NbrTrueRel")));
        }
        if (element.hasAttribute("NbrTrue")) {
            dependency.setNumberTrue(Integer.parseInt(element.getAttribute("NbrTrue")));
        }
        if (element.hasAttribute("MsgID")) {
            dependency.setMessageID(element.getAttribute("MsgID"));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            DependencyControl dependencyControl;
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !"DepParm".equalsIgnoreCase((element2 = (Element)node).getNodeName()) || (dependencyControl = DepParser.parseRule(element2)) == null) continue;
            dependency.addRule(dependencyControl);
        }
        return dependency;
    }

    private static DependencyControl parseRule(Element element) {
        if (element == null) {
            throw new NullPointerException("The element passed in is null.");
        }
        String string = element.getNodeName();
        if (!"DepParm".equalsIgnoreCase(string)) {
            throw new RuntimeException("The element passed in is a " + string + ". It should be 'DepParm'");
        }
        DependencyControl dependencyControl = new DependencyControl();
        if (element.hasAttribute("Kwd")) {
            dependencyControl.setKeyword(element.getAttribute("Kwd"));
        }
        if (element.hasAttribute("Rel")) {
            dependencyControl.setOperator(PromptControlEvaluator.mapOperator(element.getAttribute("Rel")));
        }
        if (element.hasAttribute("CmpVal")) {
            dependencyControl.setCompareValue(element.getAttribute("CmpVal"));
        }
        if (element.hasAttribute("CmpKwd")) {
            dependencyControl.setCompareKeyword(element.getAttribute("CmpKwd"));
        }
        return dependencyControl;
    }
}

