/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.parser;

import com.helpsystems.common.as400.prompter.busobj.AbstractParameterValue;
import com.helpsystems.common.as400.prompter.busobj.ParameterValueList;
import com.helpsystems.common.as400.prompter.busobj.StringValue;
import com.helpsystems.common.as400.prompter.parser.ParsedParameterList;

public class CommandTokenizer {
    private String commandString;
    private int offset;
    private String commandName;

    public CommandTokenizer(String string) {
        if (string == null) {
            this.commandString = null;
            this.offset = -1;
            throw new NullPointerException("The command passed in is null.");
        }
        this.commandString = string.trim();
        if (this.commandString.length() == 0) {
            this.commandString = null;
            this.offset = -1;
            throw new IllegalArgumentException("The command passed in is empty.");
        }
        this.offset = 0;
        this.offset = this.commandString.indexOf(" ");
        if (this.offset == -1) {
            this.commandName = this.commandString;
            if (this.commandName.indexOf("(") > -1 || this.commandName.indexOf(")") > -1) {
                throw new IllegalArgumentException("The command name " + this.commandName + " is not valid.");
            }
        } else {
            this.commandName = this.commandString.substring(0, this.offset);
            ++this.offset;
        }
    }

    public String getCommandName() {
        return this.commandName;
    }

    public ParsedParameterList nextValue() {
        if (this.offset == this.commandString.length()) {
            this.offset = -1;
        }
        if (this.offset < 0) {
            return null;
        }
        while (this.commandString.charAt(this.offset) <= ' ') {
            ++this.offset;
            if (this.offset != this.commandString.length()) continue;
            this.offset = -1;
            return null;
        }
        ParsedParameterList parsedParameterList = null;
        int n = this.offset;
        int n2 = this.commandString.indexOf("(", n);
        int n3 = this.commandString.indexOf(" ", n);
        if (n3 == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 > -1 && n2 < n3) {
            parsedParameterList = new ParsedParameterList();
            parsedParameterList.setKeyword(this.commandString.substring(n, n2));
            this.offset = n2;
            this.fillParsedParameterValues(parsedParameterList);
            if ("".equals(parsedParameterList.getKeyword())) {
                parsedParameterList.setKeyword(null);
            }
        } else {
            String string;
            parsedParameterList = new ParsedParameterList();
            if (n3 == Integer.MAX_VALUE) {
                string = this.commandString.substring(this.offset);
                this.offset = -1;
            } else {
                string = this.commandString.substring(this.offset, n3);
                this.offset = n3;
            }
            parsedParameterList.addValue(new StringValue(null, string));
        }
        return parsedParameterList;
    }

    protected void fillParsedParameterValues(ParsedParameterList parsedParameterList) {
        if ('(' != this.commandString.charAt(this.offset)) {
            throw new RuntimeException("The offset is not pointing to a '(' char");
        }
        ++this.offset;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.offset > -1) {
            if (this.offset >= this.commandString.length()) {
                this.offset = -1;
                break;
            }
            char c = this.commandString.charAt(this.offset);
            if (c == '\'') {
                String string;
                int n = ++this.offset;
                this.findEndApostrophie();
                if (this.offset == -1) {
                    string = this.commandString.substring(n);
                    stringBuffer.append("'");
                    stringBuffer.append(string);
                    continue;
                }
                if (n < this.offset) {
                    string = this.commandString.substring(n, this.offset);
                    stringBuffer.append("'");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                ++this.offset;
                continue;
            }
            if (c == '(') {
                if (stringBuffer.length() > 0) {
                    parsedParameterList.addValue(new StringValue(null, stringBuffer.toString()));
                    stringBuffer.delete(0, stringBuffer.length());
                }
                ParsedParameterList parsedParameterList2 = new ParsedParameterList();
                this.fillParsedParameterValues(parsedParameterList2);
                parsedParameterList.addValue(parsedParameterList2);
                continue;
            }
            if (c == ')') {
                ++this.offset;
                if (stringBuffer.length() > 0) {
                    parsedParameterList.addValue(new StringValue(null, stringBuffer.toString()));
                }
                return;
            }
            if (c == ' ') {
                if (stringBuffer.length() > 0) {
                    parsedParameterList.addValue(new StringValue(null, stringBuffer.toString()));
                    stringBuffer.delete(0, stringBuffer.length());
                }
                ++this.offset;
                continue;
            }
            stringBuffer.append(c);
            ++this.offset;
        }
        if (stringBuffer.length() > 0) {
            parsedParameterList.addValue(new StringValue(null, stringBuffer.toString()));
        }
    }

    protected void findEndApostrophie() {
        while (this.offset < this.commandString.length()) {
            char c = this.commandString.charAt(this.offset);
            if (c == '\'') {
                if (this.offset + 1 < this.commandString.length()) {
                    char c2 = this.commandString.charAt(this.offset + 1);
                    if (c2 == '\'') {
                        this.offset += 2;
                        continue;
                    }
                    return;
                }
                return;
            }
            ++this.offset;
        }
        this.offset = -1;
    }

    public static void main(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[i]);
        }
        CommandTokenizer commandTokenizer = new CommandTokenizer(stringBuffer.toString());
        System.out.println("Command name is " + commandTokenizer.getCommandName());
        ParsedParameterList parsedParameterList;
        while ((parsedParameterList = commandTokenizer.nextValue()) != null) {
            System.out.println(parsedParameterList.getKeyword());
            CommandTokenizer.recursivelyPrintValues(parsedParameterList, 1);
        }
        return;
    }

    private static void recursivelyPrintValues(ParameterValueList parameterValueList, int n) {
        AbstractParameterValue[] abstractParameterValueArray = parameterValueList.getValues();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < abstractParameterValueArray.length; ++i) {
            stringBuffer.delete(0, stringBuffer.length());
            if (abstractParameterValueArray[i] instanceof StringValue) {
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("\t");
                }
                stringBuffer.append(abstractParameterValueArray[i]);
                System.out.println(stringBuffer.toString());
                continue;
            }
            if (!(abstractParameterValueArray[i] instanceof ParameterValueList)) continue;
            CommandTokenizer.recursivelyPrintValues((ParameterValueList)abstractParameterValueArray[i], n + 1);
        }
    }
}

