/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.prompter.busobj;

import com.helpsystems.common.as400.prompter.busobj.AbstractParameterValue;
import com.helpsystems.common.as400.prompter.busobj.ChoiceProgram;
import com.helpsystems.common.as400.prompter.busobj.ParameterEntry;
import com.helpsystems.common.as400.prompter.busobj.ParameterValueList;
import com.helpsystems.common.as400.prompter.busobj.PromptControlEvaluator;
import com.helpsystems.common.as400.prompter.busobj.PromptedCommand;
import com.helpsystems.common.as400.prompter.busobj.SingleValueDefinition;
import com.helpsystems.common.as400.prompter.busobj.SpecialValueDefinition;
import com.helpsystems.common.as400.prompter.busobj.StringValue;
import com.helpsystems.common.as400.prompter.parser.ParsedParameterList;
import com.helpsystems.common.core.util.Equal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class GenericParameter
implements Cloneable {
    private static final Logger logger = Logger.getLogger(GenericParameter.class);
    public static final int YES = 100;
    public static final int NO = 101;
    public static final int PROMPT = 102;
    protected String prompt;
    protected String defaultValue;
    protected String choice;
    protected int minOccurence;
    protected int length;
    private int fractionLength;
    protected int relOp;
    protected String relValue;
    protected double rangeMinValue;
    protected double rangeMaxValue;
    protected int displayInput;
    protected boolean restricted;
    protected boolean fullFieldSize;
    protected ArrayList<SpecialValueDefinition> specialValueList;
    protected ArrayList<SingleValueDefinition> singleValueList;
    protected String parameterType;
    protected ChoiceProgram choiceProgram;
    protected int maxOccurence;
    protected ArrayList<GenericParameter> nestedParameterTemplateList;
    protected ArrayList<GenericParameter> nestedParameterList;
    protected GenericParameter parent;
    protected ParameterValueList parameterValueList;
    private boolean isValueSpecified;
    protected String promptControlLibrary;
    protected String promptControlProgram;

    public GenericParameter() {
        this.setDisplayInput(100);
        this.initializeLists();
    }

    private void initializeLists() {
        this.nestedParameterTemplateList = new ArrayList();
        this.nestedParameterList = new ArrayList();
        this.specialValueList = new ArrayList();
        this.singleValueList = new ArrayList();
        this.parameterValueList = new ParameterValueList(this);
    }

    public Object clone() {
        GenericParameter genericParameter = null;
        try {
            genericParameter = (GenericParameter)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to clone Parameter " + this.getKeyword(), cloneNotSupportedException);
        }
        genericParameter.initializeLists();
        genericParameter.nestedParameterTemplateList.addAll(this.nestedParameterTemplateList);
        genericParameter.specialValueList.addAll(this.specialValueList);
        genericParameter.singleValueList.addAll(this.singleValueList);
        return genericParameter;
    }

    public void addSpecialValueDefinition(SpecialValueDefinition specialValueDefinition) {
        this.specialValueList.add(specialValueDefinition);
    }

    public SpecialValueDefinition[] getSpecialValueDefinitions() {
        SpecialValueDefinition[] specialValueDefinitionArray = new SpecialValueDefinition[this.specialValueList.size()];
        this.specialValueList.toArray(specialValueDefinitionArray);
        return specialValueDefinitionArray;
    }

    public SingleValueDefinition[] getSingleValueDefinitions() {
        SingleValueDefinition[] singleValueDefinitionArray = new SingleValueDefinition[this.singleValueList.size()];
        this.singleValueList.toArray(singleValueDefinitionArray);
        return singleValueDefinitionArray;
    }

    public void addSingleValueDefinition(SingleValueDefinition singleValueDefinition) {
        this.singleValueList.add(singleValueDefinition);
    }

    public void addParameterValue(AbstractParameterValue abstractParameterValue) {
        String string = abstractParameterValue.toString();
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.defaultValue != null && this.defaultValue.equalsIgnoreCase(abstractParameterValue.toString()) && !this.isValueSpecified()) {
            return;
        }
        if (this.parameterValueList.size() == this.maxOccurence) {
            throw new IllegalArgumentException("Parameter maximum number of values exceeded: " + this.maxOccurence);
        }
        if (this.isElem()) {
            GenericParameter genericParameter;
            if (this.nestedParameterList.size() == 0) {
                if (this.nestedParameterTemplateList.size() == 0) {
                    throw new IllegalStateException("Unable to set value \"" + abstractParameterValue + "\" into parameter " + this.getKeyword() + ": No nested parameters found.");
                }
                genericParameter = this.nestedParameterTemplateList.get(0);
                GenericParameter genericParameter2 = (GenericParameter)genericParameter.clone();
                this.addNestedParameter(genericParameter2);
            }
            genericParameter = this.nestedParameterList.get(0);
            genericParameter.addParameterValue(abstractParameterValue);
        } else {
            String string2;
            PromptedCommand promptedCommand = this.findParentCommand();
            boolean bl = false;
            if (promptedCommand != null) {
                bl = promptedCommand.isValidVariableName(string);
            }
            boolean bl2 = this.isSingleOrSpecialValue(string);
            String string3 = PromptControlEvaluator.unmapVariableIfNecessary(this, string);
            if (!Equal.isEqual((Object)string3, (Object)string)) {
                string3 = this.unHexIfNeeded(string3);
            }
            if ((string2 = this.stripApostrophes(string3)) == null) {
                string2 = "";
            }
            if (this.isNumeric()) {
                string2 = string2.replace(',', '.');
            }
            if (this.isInteger() && string2.indexOf(".") > -1) {
                throw new IllegalArgumentException("Decimal point for parameter value " + this.getKeyword() + " not valid.");
            }
            if (this.length > 0 && !bl) {
                if ("DEC".equals(this.parameterType)) {
                    int n;
                    int n2 = string2.indexOf(".");
                    if (n2 == -1) {
                        n2 = string2.length();
                        string2 = string2 + ".";
                    }
                    if ((n = n2) > this.length) {
                        if (string2.endsWith(".")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        throw new IllegalArgumentException("The value " + string2 + " exceeds the max integer length of " + this.length);
                    }
                } else if (string2.length() > this.length) {
                    throw new IllegalArgumentException("The value " + string + " exceeds the max length of " + this.length);
                }
            }
            if (this.isRestricted() && !bl && !bl2) {
                throw new IllegalArgumentException("The value " + string + " is not valid for the parameter " + this.getKeyword());
            }
            PromptedCommand promptedCommand2 = this.findParentCommand();
            if ("DATE".equals(this.parameterType) && promptedCommand2 != null && !bl2 && !bl && !promptedCommand2.isValidDate(string2)) {
                throw new IllegalArgumentException("Value " + string + " for parameter " + this.getKeyword() + " is not a valid date.\n" + "The date format for this server is " + promptedCommand.getDateFormatAsString());
            }
            if ("TIME".equals(this.parameterType) && promptedCommand2 != null && !bl2 && !bl && !promptedCommand2.isValidTime(string2)) {
                throw new IllegalArgumentException("Value " + string + " for parameter " + this.getKeyword() + " is not a valid time.\n" + "The time format for this server is " + promptedCommand.getTimeFormatAsString());
            }
            abstractParameterValue.setParameter(this);
            this.parameterValueList.addValue(abstractParameterValue);
            this.checkSingleValues();
        }
    }

    protected String stripApostrophes(String string) {
        String string2 = string;
        if (string2 == null) {
            return string2;
        }
        if (string2.startsWith("'") && string2.endsWith("'")) {
            if (string2.length() == 2) {
                string2 = "";
            } else {
                string2 = string2.substring(1, string2.length() - 1);
                string2 = string2.replaceAll("''", "'");
            }
        }
        return string2;
    }

    private void checkSingleValues() {
        SingleValueDefinition[] singleValueDefinitionArray = this.getSingleValueDefinitions();
        AbstractParameterValue[] abstractParameterValueArray = this.getParameterValues();
        for (int i = 0; i < abstractParameterValueArray.length; ++i) {
            if (!(abstractParameterValueArray[i] instanceof StringValue)) continue;
            String string = ((StringValue)abstractParameterValueArray[i]).getValue();
            for (int j = 0; j < singleValueDefinitionArray.length; ++j) {
                String string2 = singleValueDefinitionArray[j].getValue();
                if (!string.equalsIgnoreCase(string2) || abstractParameterValueArray.length <= 1) continue;
                throw new IllegalStateException("The single value " + string + " must be the only value for parameter " + this.getKeyword());
            }
        }
    }

    public void clearValues() {
        this.parameterValueList.clear();
        GenericParameter[] genericParameterArray = this.getNestedParameters();
        for (int i = 0; i < genericParameterArray.length; ++i) {
            genericParameterArray[i].clearValues();
        }
        this.setValueSpecified(false);
    }

    public AbstractParameterValue[] getParameterValues() {
        return this.parameterValueList.getValues();
    }

    ParameterValueList getParameterValueList() {
        return this.parameterValueList;
    }

    public String getCommandString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.parameterValueList.toString();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ("GENERIC".equals(this.getType()) && !(this instanceof ParameterEntry) && stringBuffer.length() > 0 && this.parameterValueList.size() > 1) {
            stringBuffer.insert(0, '(');
            stringBuffer.append(')');
        }
        GenericParameter[] genericParameterArray = this.getNestedParameters();
        GenericParameter[] genericParameterArray2 = this.getNestedParameterTemplates();
        boolean bl = this.isElemInElem();
        if (this.maxOccurence > 1) {
            bl = true;
        }
        if (this.isAllElemWithinElem()) {
            bl = false;
        }
        int n = genericParameterArray2.length;
        int n2 = genericParameterArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n3 = 0;
        while (n3 < genericParameterArray.length) {
            int n4;
            arrayList.clear();
            arrayList2.clear();
            int n5 = -1;
            for (n4 = 0; n4 < n && n3 + n4 < genericParameterArray.length; ++n4) {
                GenericParameter genericParameter = genericParameterArray[n3 + n4];
                String string2 = genericParameter.getCommandString();
                arrayList.add(string2);
                if (string2 != null && string2.length() > 0) {
                    n5 = n4;
                }
                String string3 = genericParameter.getDefaultValue();
                if (this.isElem() && "".equals(string3)) {
                    string3 = "*N";
                }
                if (genericParameter.isElem()) {
                    string3 = '(' + string3 + ')';
                }
                arrayList2.add(string3);
            }
            if (n5 == -1) {
                n3 += n4;
                continue;
            }
            if (this.isElem() && bl) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('(');
            }
            if (this.isQual() && stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            int n6 = 0;
            int n7 = Math.min(n, n2);
            int n8 = 1;
            if (this.isQual()) {
                n6 = n7 - 1;
                n7 = -1;
                n8 = -1;
            }
            for (int i = n6; i != n7; i += n8) {
                String string4 = (String)arrayList.get(i);
                if ((string4 == null || string4.length() < 1) && i <= n5) {
                    String string5 = (String)arrayList2.get(i);
                    if (string5 == null) {
                        GenericParameter genericParameter = genericParameterArray[n3 + i];
                        throw new NullPointerException("Parameter " + genericParameter.getKeyword() + " does not have a default value, " + " and no value was entered.");
                    }
                    if (this.isQual() && i < n6 && string5.length() == 0) {
                        string5 = "' '";
                    }
                    string4 = string5;
                }
                if (string4 == null || string4.length() <= 0) continue;
                if (this.isQual()) {
                    if (i < n6 && stringBuffer.length() > 0) {
                        stringBuffer.append('/');
                    }
                } else if (i > n6) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string4);
            }
            if (this.isElem() && bl) {
                stringBuffer.append(')');
            }
            n3 += n4;
        }
        return stringBuffer.toString();
    }

    public void addNestedParameter(GenericParameter genericParameter) {
        genericParameter.setParent(this);
        this.nestedParameterList.add(genericParameter);
    }

    public void addNestedParameterTemplate(GenericParameter genericParameter) {
        genericParameter.setParent(this);
        boolean bl = false;
        if (this.defaultValue != null && this.defaultValue.length() > 0) {
            bl = true;
        }
        if ((this.isQual() || this.isElem()) && bl) {
            if (this.nestedParameterTemplateList.size() == 0) {
                genericParameter.setDefaultValue(this.defaultValue);
            } else {
                genericParameter.setDefaultValue("");
            }
        }
        if (this.isQual() && this.nestedParameterTemplateList.size() == 0) {
            genericParameter.setPrompt(this.getPrompt());
        }
        if (this.nestedParameterTemplateList.size() == 0 && (this.isQual() || this.isElem())) {
            GenericParameter genericParameter2 = genericParameter;
            if (genericParameter2.isQual()) {
                genericParameter2 = genericParameter2.getNestedParameterTemplates()[0];
            }
            this.mergeChoices(genericParameter2);
            genericParameter2.singleValueList.addAll(this.singleValueList);
            genericParameter2.specialValueList.addAll(this.specialValueList);
        }
        this.nestedParameterTemplateList.add(genericParameter);
    }

    public GenericParameter[] getNestedParameterTemplates() {
        GenericParameter[] genericParameterArray = new GenericParameter[this.nestedParameterTemplateList.size()];
        this.nestedParameterTemplateList.toArray(genericParameterArray);
        return genericParameterArray;
    }

    public GenericParameter[] getNestedParameters() {
        GenericParameter[] genericParameterArray = new GenericParameter[this.nestedParameterList.size()];
        this.nestedParameterList.toArray(genericParameterArray);
        return genericParameterArray;
    }

    public ParameterValueList getAllParameterValues() {
        ParameterValueList parameterValueList = new ParameterValueList(this);
        parameterValueList.addAll(this.getParameterValues());
        GenericParameter[] genericParameterArray = this.getNestedParameters();
        for (int i = 0; i < genericParameterArray.length; ++i) {
            parameterValueList.addValue(genericParameterArray[i].getAllParameterValues());
        }
        return parameterValueList;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getDefaultValue() {
        if (this.isElem() || this.isQual()) {
            GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
            if (genericParameterArray.length == 0) {
                return null;
            }
            return genericParameterArray[0].getDefaultValue();
        }
        return this.unHexIfNeeded(this.defaultValue);
    }

    public boolean isDefaultValue(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (this.defaultValue == null || this.defaultValue.length() == 0) {
            return false;
        }
        return this.defaultValue.equalsIgnoreCase(string);
    }

    public String getChoice() {
        return this.choice;
    }

    public boolean isElem() {
        return "ELEM".equalsIgnoreCase(this.parameterType);
    }

    public boolean isElemInElem() {
        return this.isElem() && this.parent != null && this.parent.isElem();
    }

    public boolean isInElem() {
        return this.parent != null && this.parent.isElem();
    }

    public boolean hasRequiredValues() {
        Object object;
        if (!this.isElem() && !this.isQual() && (!this.isValueSpecified() && this.getMinOccurrence() > 0 ? this.defaultValue == null || this.defaultValue.length() == 0 : ((ParameterValueList)(object = this.getAllParameterValues())).size() < this.getMinOccurrence())) {
            return false;
        }
        if (this.isQual() && this.getMinOccurrence() == 0) {
            return true;
        }
        object = this.getNestedParameters();
        for (int i = 0; i < ((Object)object).length; ++i) {
            if (((GenericParameter)object[i]).hasRequiredValues() || i >= this.getMinOccurrence()) continue;
            return false;
        }
        return true;
    }

    public boolean isAllElemWithinElem() {
        boolean bl = false;
        if (this.isElem()) {
            bl = true;
            GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
            for (int i = 0; i < genericParameterArray.length; ++i) {
                if (genericParameterArray[i].isElem()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isQual() {
        return "QUAL".equalsIgnoreCase(this.parameterType);
    }

    public boolean isNumeric() {
        return "DEC".equalsIgnoreCase(this.parameterType) || this.isInteger();
    }

    public boolean isInteger() {
        return "INT2".equalsIgnoreCase(this.parameterType) || "INT4".equalsIgnoreCase(this.parameterType) || "UINT2".equalsIgnoreCase(this.parameterType) || "UINT4".equalsIgnoreCase(this.parameterType);
    }

    private void mergeChoices(GenericParameter genericParameter) {
        if (this.choice == null || this.choice.length() == 0) {
            return;
        }
        String string = genericParameter.getChoice();
        if (string == null || string.length() == 0) {
            genericParameter.setChoice(this.choice);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf(",");
        if (n == -1) {
            stringBuffer.append(", ");
            stringBuffer.append(this.choice);
        } else {
            stringBuffer.insert(n, ", " + this.choice);
        }
        genericParameter.setChoice(stringBuffer.toString());
    }

    public boolean isValueSpecified() {
        if (this.isQual() || this.isElem()) {
            GenericParameter[] genericParameterArray = this.getNestedParameters();
            for (int i = 0; i < genericParameterArray.length; ++i) {
                if (!genericParameterArray[i].isValueSpecified()) continue;
                return true;
            }
            return false;
        }
        return this.isValueSpecified;
    }

    public void setValueSpecified(boolean bl) {
        this.isValueSpecified = bl;
    }

    public boolean needsApostrophes() {
        return !"CmdStr".equalsIgnoreCase(this.parameterType) && !"Cmd".equalsIgnoreCase(this.parameterType) && !this.isNumeric() && !this.isElem() && !this.isQual();
    }

    public void setPrompt(String string) {
        this.prompt = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
        if (this.isQual() || this.isElem()) {
            GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
            for (int i = 0; i < genericParameterArray.length; ++i) {
                if (i == 0) {
                    genericParameterArray[i].setDefaultValue(string);
                    continue;
                }
                genericParameterArray[i].setDefaultValue("");
            }
        }
    }

    public void setChoice(String string) {
        this.choice = string;
    }

    public void setMinOccurrence(int n) {
        this.minOccurence = n;
    }

    public int getMinOccurrence() {
        return this.minOccurence;
    }

    public void setLength(int n) {
        this.length = "HEX".equalsIgnoreCase(this.parameterType) ? n * 2 : ("X".equals(this.parameterType) ? 255 : n);
    }

    public int getLength() {
        return this.length;
    }

    public int getFractionLength() {
        return this.fractionLength;
    }

    public void setFractionLength(int n) {
        this.fractionLength = n;
    }

    public void setRelOperator(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.relOp = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value passed in  is not valid.");
            }
        }
    }

    public void setRelOperator(String string) {
        this.setRelOperator(PromptControlEvaluator.mapOperator(string));
    }

    public int getRelOperator() {
        return this.relOp;
    }

    public void setRelValue(String string) {
        this.relValue = string;
    }

    public String getRelValue() {
        return this.relValue;
    }

    public void setRangeMinValue(double d) {
        this.rangeMinValue = d;
    }

    public double getRangeMinValue() {
        return this.rangeMinValue;
    }

    public void setRangeMaxValue(double d) {
        this.rangeMaxValue = d;
    }

    public double getRangeMaxValue() {
        return this.rangeMaxValue;
    }

    public void setDisplayInput(int n) {
        switch (n) {
            case 100: 
            case 101: 
            case 102: {
                this.displayInput = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value passed in  is not valid.");
            }
        }
    }

    public void setDisplayInput(String string) {
        if (string == null) {
            throw new NullPointerException("The value passed in was null.");
        }
        if ("yes".equalsIgnoreCase(string)) {
            this.setDisplayInput(100);
            return;
        }
        if ("no".equalsIgnoreCase(string)) {
            this.setDisplayInput(101);
            return;
        }
        if ("prompt".equalsIgnoreCase(string)) {
            this.setDisplayInput(102);
            return;
        }
        throw new IllegalArgumentException("The value '" + string + "' is not a valid value for this setting.");
    }

    public int getDisplayInput() {
        return this.displayInput;
    }

    public void setRestricted(boolean bl) {
        this.restricted = bl;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setFullFieldSize(boolean bl) {
        this.fullFieldSize = bl;
    }

    public boolean isFullFieldSize() {
        return this.fullFieldSize;
    }

    public String getType() {
        return this.parameterType;
    }

    public void setType(String string) {
        this.parameterType = string == null ? null : string.toUpperCase();
        if ("X".equals(this.parameterType)) {
            this.setLength(255);
        }
    }

    public String getPromptControlLibrary() {
        return this.promptControlLibrary;
    }

    public void setPromptControlLibrary(String string) {
        this.promptControlLibrary = string;
    }

    public String getPromptControlProgram() {
        return this.promptControlProgram;
    }

    public void setPromptControlProgram(String string) {
        this.promptControlProgram = string;
    }

    public void setMaxOccurrence(int n) {
        this.maxOccurence = n;
    }

    public int getMaxOccurrence() {
        return this.maxOccurence;
    }

    public ChoiceProgram getChoiceProgram() {
        return this.choiceProgram;
    }

    public void setChoiceProgram(ChoiceProgram choiceProgram) {
        this.choiceProgram = choiceProgram;
    }

    public GenericParameter getParent() {
        return this.parent;
    }

    public void setParent(GenericParameter genericParameter) {
        this.parent = genericParameter;
    }

    public void parseParameterValue(ParsedParameterList parsedParameterList) {
        int n;
        Object object;
        Object[] objectArray;
        this.setValueSpecified(true);
        if (this.isElem()) {
            objectArray = parsedParameterList.getValues();
            object = new ParsedParameterList();
            for (n = 0; n < objectArray.length; ++n) {
                if (!(objectArray[n] instanceof StringValue)) {
                    object = null;
                    break;
                }
                ((ParameterValueList)object).addValue((AbstractParameterValue)objectArray[n]);
            }
            if (object != null) {
                parsedParameterList.clear();
                parsedParameterList.addValue((AbstractParameterValue)object);
            }
        }
        objectArray = this.getNestedParameterTemplates();
        object = parsedParameterList.getValues();
        for (n = 0; n < ((AbstractParameterValue[])object).length; ++n) {
            AbstractParameterValue abstractParameterValue;
            AbstractParameterValue[] abstractParameterValueArray;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.getKeyword() + " Parsing stuff: " + object[n]));
            }
            if (this.isElem()) {
                if (this.isAllElemWithinElem()) {
                    abstractParameterValueArray = (AbstractParameterValue[])((GenericParameter)objectArray[n]).clone();
                    this.addNestedParameter((GenericParameter)abstractParameterValueArray);
                    abstractParameterValue = new ParsedParameterList();
                    ((ParameterValueList)abstractParameterValue).addValue((AbstractParameterValue)object[n]);
                    abstractParameterValueArray.parseParameterValue((ParsedParameterList)abstractParameterValue);
                    continue;
                }
                this.parseAndAddElemParam((AbstractParameterValue)object[n]);
                continue;
            }
            if (this.isQual()) {
                this.parseAndAddQualParam((AbstractParameterValue)object[n]);
                continue;
            }
            if (!this.needsApostrophes()) {
                abstractParameterValueArray = this.getParameterValues();
                if (abstractParameterValueArray.length == 1 && abstractParameterValueArray[0] instanceof StringValue) {
                    abstractParameterValue = (StringValue)abstractParameterValueArray[0];
                    String string = object[n].toString();
                    string = object[n] instanceof ParameterValueList ? "(" + string + ")" : ' ' + string;
                    ((StringValue)abstractParameterValue).setValue(((StringValue)abstractParameterValue).getValue() + string);
                    continue;
                }
                this.addParameterValue((AbstractParameterValue)object[n]);
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("\tAdding STRING param: " + object[n]));
            }
            this.addParameterValue((AbstractParameterValue)object[n]);
        }
    }

    private void parseStringValue(StringValue stringValue) {
        if (this.isQual()) {
            GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
            if (genericParameterArray.length == 0) {
                throw new IllegalArgumentException(this.getKeyword() + " [" + this.parameterType + "] does not contain nested parameters.");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(stringValue.toString(), "/", false);
            int n = stringTokenizer.countTokens();
            if (n > genericParameterArray.length) {
                throw new IllegalArgumentException("The parameter value \"" + stringValue + "\" appears to have " + n + " pieces, but there are only " + genericParameterArray.length + " nested parameters available.");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(stringTokenizer.nextToken());
            }
            for (int i = 0; i < genericParameterArray.length; ++i) {
                GenericParameter genericParameter = (GenericParameter)genericParameterArray[i].clone();
                this.addNestedParameter(genericParameter);
                int n2 = n - i - 1;
                if (n2 <= -1 || n2 >= arrayList.size()) continue;
                String string = (String)arrayList.get(n2);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Adding QUAL token: " + string));
                }
                genericParameter.setValueSpecified(true);
                genericParameter.addParameterValue(new StringValue(genericParameterArray[i], string));
            }
        } else {
            this.setValueSpecified(true);
            this.addParameterValue(stringValue);
        }
    }

    private void parseAndAddElemParam(AbstractParameterValue abstractParameterValue) {
        GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
        if (genericParameterArray.length == 0) {
            throw new IllegalArgumentException(this.getKeyword() + " [" + this.parameterType + "] does not contain nested parameters.");
        }
        if (abstractParameterValue instanceof StringValue) {
            throw new IllegalArgumentException("Unable to find the destination for the ELEM String parameter " + abstractParameterValue);
        }
        if (abstractParameterValue instanceof ParameterValueList) {
            ParameterValueList parameterValueList = (ParameterValueList)abstractParameterValue;
            AbstractParameterValue[] abstractParameterValueArray = parameterValueList.getValues();
            for (int i = 0; i < genericParameterArray.length; ++i) {
                GenericParameter genericParameter = (GenericParameter)genericParameterArray[i].clone();
                this.addNestedParameter(genericParameter);
                if (i >= abstractParameterValueArray.length) continue;
                if (abstractParameterValueArray[i] instanceof ParsedParameterList) {
                    genericParameter.parseParameterValue((ParsedParameterList)abstractParameterValueArray[i]);
                    continue;
                }
                if (abstractParameterValueArray[i] instanceof StringValue) {
                    genericParameter.parseStringValue((StringValue)abstractParameterValueArray[i]);
                    continue;
                }
                genericParameter.addParameterValue(abstractParameterValueArray[i]);
            }
        }
    }

    private void parseAndAddQualParam(AbstractParameterValue abstractParameterValue) {
        GenericParameter[] genericParameterArray = this.getNestedParameterTemplates();
        if (genericParameterArray.length == 0) {
            throw new IllegalArgumentException(this.getKeyword() + " [" + this.parameterType + "] does not contain nested parameters.");
        }
        if (!(abstractParameterValue instanceof StringValue)) {
            throw new IllegalArgumentException("Qual parameter " + this.getKeyword() + " doesn't know what to do with ParameterValueList" + abstractParameterValue);
        }
        this.parseStringValue((StringValue)abstractParameterValue);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.prompt);
        stringBuffer.append("\t  [");
        stringBuffer.append(this.defaultValue);
        stringBuffer.append("]\t ");
        stringBuffer.append(this.choice);
        return stringBuffer.toString();
    }

    public String getKeyword() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getKeyword();
    }

    public PromptedCommand findParentCommand() {
        GenericParameter genericParameter = this;
        while (genericParameter != null && !(genericParameter instanceof ParameterEntry)) {
            genericParameter = genericParameter.parent;
        }
        if (genericParameter == null) {
            return null;
        }
        PromptedCommand promptedCommand = ((ParameterEntry)genericParameter).getCommand();
        return promptedCommand;
    }

    private String unHexIfNeeded(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.startsWith("X'") && string.endsWith("'") && string.length() > 3) {
            PromptedCommand promptedCommand = this.findParentCommand();
            if (promptedCommand == null) {
                throw new NullPointerException("Param " + this.getKeyword() + " cannot convert hex string " + string + ". Parent command could not be found.");
            }
            return promptedCommand.unEBCDIC(string);
        }
        return string;
    }

    public String checkRange() {
        Object[] objectArray;
        if (this.relOp != 0 && this.relValue != null && this.isValueSpecified() && (objectArray = this.getParameterValues()).length > 0) {
            PromptedCommand promptedCommand;
            String string = objectArray[0].toString();
            boolean bl = false;
            bl = this.isSingleOrSpecialValue(string) ? true : ((promptedCommand = this.findParentCommand()) != null && promptedCommand.isValidVariableName(string) ? true : PromptControlEvaluator.compare(string, this.relValue, this.relOp, true, this.findParentCommand()));
            if (!bl) {
                switch (this.relOp) {
                    case 2: {
                        return "Parameter " + this.getKeyword() + " must be " + this.relValue + ".";
                    }
                    case 4: {
                        return "Parameter " + this.getKeyword() + " must be less than " + this.relValue + ".";
                    }
                    case 1: {
                        return "Parameter " + this.getKeyword() + " must be less than " + this.relValue + ".";
                    }
                    case 6: {
                        return "Parameter " + this.getKeyword() + " must be " + this.relValue + " or less.";
                    }
                    case 3: {
                        return "Parameter " + this.getKeyword() + " must be " + this.relValue + " or greater.";
                    }
                    case 5: {
                        return "Parameter " + this.getKeyword() + " must not be " + this.relValue + ".";
                    }
                }
                return "Value for parameter " + this.getKeyword() + " is not valid.";
            }
        }
        objectArray = this.getNestedParameters();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = ((GenericParameter)objectArray[i]).checkRange();
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public boolean isSingleOrSpecialValue(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i != 2; ++i) {
            SingleValueDefinition[] singleValueDefinitionArray = null;
            if (i == 0) {
                singleValueDefinitionArray = this.getSpecialValueDefinitions();
            } else if (i == 1) {
                singleValueDefinitionArray = this.getSingleValueDefinitions();
            }
            for (int j = 0; j < singleValueDefinitionArray.length; ++j) {
                if (!string.equalsIgnoreCase(singleValueDefinitionArray[j].getValue())) continue;
                return true;
            }
        }
        return false;
    }

    protected String addQuotesIfNeeded(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray;
        if (string == null || string.length() == 0) {
            return string;
        }
        if (this.parameterType.equals("X") && this.isValidHexParm(string)) {
            return string;
        }
        PromptedCommand promptedCommand = this.findParentCommand();
        if (promptedCommand != null && promptedCommand.isValidVariableName(string)) {
            return string;
        }
        if (!this.needsApostrophes()) {
            return string;
        }
        boolean bl = false;
        int n5 = 36;
        int n6 = 64;
        int n7 = 35;
        if (promptedCommand != null && (cArray = promptedCommand.getCharMap()) != null) {
            n5 = cArray[91];
            n6 = cArray[124];
            n7 = cArray[123];
        }
        for (n4 = 0; n4 < string.length(); ++n4) {
            n3 = string.charAt(n4);
            if (Character.isLetterOrDigit((char)n3) || n3 == 42 || n3 == 95 || n3 == n5 || n3 == n6 || n3 == n7) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        n4 = 0;
        n3 = -1;
        int[] nArray = new int[255];
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (n == 39) {
                if (n4 == 0) {
                    n4 = 1;
                }
                int n8 = ++n3;
                nArray[n8] = nArray[n8] + 1;
                continue;
            }
            n4 = 0;
        }
        if (n3 == -1) {
            return '\'' + string + '\'';
        }
        n2 = 0;
        if (!string.startsWith("'") || !string.endsWith("'")) {
            n2 = 1;
        } else {
            for (n = 0; n <= n3; ++n) {
                if (n == 0 || n == n3) {
                    if (nArray[n] % 2 == 1) continue;
                    n2 = 1;
                    break;
                }
                if (nArray[n] % 2 == 0) continue;
                n2 = 1;
                break;
            }
        }
        if (n2 != 0) {
            return '\'' + string.replaceAll("'", "''") + '\'';
        }
        return string;
    }

    private boolean isValidHexParm(String string) {
        if (string == null || string.length() < 5) {
            return false;
        }
        String string2 = string.toUpperCase();
        if (!string2.startsWith("X'") || !string2.endsWith("'")) {
            return false;
        }
        if (string2.length() % 2 != 1) {
            return false;
        }
        for (int i = 2; i < string2.length() - 1; ++i) {
            char c = string2.charAt(i);
            if (Character.digit(c, 16) != -1) continue;
            return false;
        }
        return true;
    }
}

