/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.dataset;

import com.helpsystems.common.as400.access.AbstractProgramCallManager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400Message;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.util.Convert;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.data.ProgramCallDocument;
import java.util.Date;

public class QHSTDataSet
implements DataSet {
    private static final String QHST_PROGRAM_NAME = "RSL3040";
    private WrappedAS400 as400;
    private int size;
    private ProgramCallDocument pcml;
    private String library = "*LIBL";
    private boolean isClosed;

    private QHSTDataSet(WrappedAS400 wrappedAS400, ProgramCallDocument programCallDocument, int n, String string) {
        this.as400 = wrappedAS400;
        this.size = n;
        this.pcml = programCallDocument;
        this.library = string;
    }

    public static DataSet createDataSet(WrappedAS400 wrappedAS400, ProgramCallDocument programCallDocument, int n, String string) throws DataSetException {
        QHSTDataSet qHSTDataSet = new QHSTDataSet(wrappedAS400, programCallDocument, n, string);
        return ArrayDataSet.checkThreshold((DataSet)qHSTDataSet, (int)1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] get(int n, int n2) throws DataSetException {
        int n3 = 256;
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        if (n2 == 0) {
            return new OS400Message[0];
        }
        Object[] objectArray = new Object[n2];
        int n4 = 0;
        int n5 = 0;
        try {
            ProgramCallDocument programCallDocument = this.pcml;
            synchronized (programCallDocument) {
                int n6;
                this.pcml.setSystem((AS400)this.as400);
                String string = "/QSYS.LIB/" + this.library.trim() + ".LIB/" + QHST_PROGRAM_NAME + ".PGM";
                this.pcml.setPath(QHST_PROGRAM_NAME, string);
                for (int i = n2; i > 0; i -= n6) {
                    this.pcml.setIntValue("RSL3040.offset", n + 1);
                    n5 = i > n3 ? n3 : i;
                    this.pcml.setIntValue("RSL3040.maxRecords", n5);
                    this.pcml.setIntValue("RSL3040.numReturned", 0);
                    AbstractProgramCallManager.doCallAndReturn(this.pcml, QHST_PROGRAM_NAME, null);
                    n6 = this.pcml.getIntValue("RSL3040.numReturned");
                    for (int j = 0; j < n6 && n4 + j < objectArray.length; ++j) {
                        OS400Message oS400Message = this.loadMessage(j, this.pcml, this.as400);
                        objectArray[n4 + j] = oS400Message;
                    }
                    n4 += n6;
                }
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Error retrieving QHST messages.", (Throwable)exception);
        }
        return objectArray;
    }

    private OS400Message loadMessage(int n, ProgramCallDocument programCallDocument, AS400 aS400) throws Exception {
        int[] nArray = new int[]{n};
        OS400Message oS400Message = new OS400Message();
        oS400Message.setSendingJobName((String)programCallDocument.getValue("RSL3040.records.dsJobName", nArray));
        oS400Message.setSendingJobNumber((String)programCallDocument.getValue("RSL3040.records.dsJobNumber", nArray));
        oS400Message.setSendingUser((String)programCallDocument.getValue("RSL3040.records.dsJobUser", nArray));
        String string = (String)programCallDocument.getValue("RSL3040.records.dsDate", nArray);
        String string2 = (String)programCallDocument.getValue("RSL3040.records.dsTime", nArray);
        Date date = Convert.getDate((int)Integer.parseInt(string), (int)Integer.parseInt(string2));
        oS400Message.setMessageDate(date);
        byte[] byArray = (byte[])programCallDocument.getValue("RSL3040.records.dsMsgData", nArray);
        oS400Message.setMessageData(byArray);
        oS400Message.setMessageFileLibrary((String)programCallDocument.getValue("RSL3040.records.dsMsgFileLib", nArray));
        oS400Message.setMessageFileName((String)programCallDocument.getValue("RSL3040.records.dsMsgFile", nArray));
        try {
            oS400Message.setSeverity(Integer.parseInt((String)programCallDocument.getValue("RSL3040.records.dsMsgSev", nArray)));
        }
        catch (NumberFormatException numberFormatException) {
            oS400Message.setSeverity(-1000);
        }
        try {
            oS400Message.setType(Integer.parseInt((String)programCallDocument.getValue("RSL3040.records.dsMsgType", nArray)));
        }
        catch (NumberFormatException numberFormatException) {
            oS400Message.setType(-1000);
        }
        oS400Message.setSendingProgram((String)programCallDocument.getValue("RSL3040.records.dsSndPgm", nArray));
        oS400Message.setFirstLevelText((String)programCallDocument.getValue("RSL3040.records.dsMsgText", nArray));
        oS400Message.setMessageId((String)programCallDocument.getValue("RSL3040.records.dsMsgID", nArray));
        oS400Message.setCurrentUser((String)programCallDocument.getValue("RSL3040.records.dsCurUser", nArray));
        oS400Message.setSystem(aS400.getSystemName());
        if (!oS400Message.getMessageFileName().equals("")) {
            MessageFile messageFile = new MessageFile(aS400, this.loadPath(oS400Message.getLibraryName(), oS400Message.getMessageFileName()));
            AS400Message aS400Message = messageFile.getMessage(oS400Message.getMessageId(), oS400Message.getMessageData());
            oS400Message.setSecondLevelText(aS400Message.getHelp());
        }
        return oS400Message;
    }

    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.as400.close();
        }
        catch (Exception exception) {
            throw new DataSetException("Error returning the AS400 connection.", (Throwable)exception);
        }
    }

    public int size() throws DataSetException {
        if (this.isClosed) {
            throw new DataSetException("This DataSet has been closed.");
        }
        return this.size;
    }

    private String loadPath(String string, String string2) {
        String string3 = "/" + string2.trim() + ".MSGF";
        if (!string.equals("*LIBL")) {
            string3 = "/" + string.trim() + ".LIB" + string3;
        }
        if (!string.equals("QSYS")) {
            string3 = "/QSYS.LIB" + string3;
        }
        return string3;
    }
}

