/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ResourceBundleHandler;

public class OS400ObjectListFilter
extends Proxy {
    private static final long serialVersionUID = -2519329066920016119L;
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler((String)OS400ObjectListFilter.class.getName());
    public static final String LIB_ALL = "*ALL";
    public static final String LIB_ALLUSR = "*ALLUSR";
    public static final String LIB_CURLIB = "*CURLIB";
    public static final String LIB_LIBL = "*LIBL";
    public static final String LIB_USRLIBL = "*USRLIBL";
    public static final String OBJ_ALL = "*ALL";
    public static final String OBJ_ALLUSR = "*ALLUSR";
    public static final String OBJ_IBM = "*IBM";
    public static final String TYPE_ALL = "*ALL";
    private String library;
    private String object;
    private String type;
    private boolean includeSysbas = true;
    public static final String ASP_TYPE_ASP = "*ASP";
    public static final String ASP_TYPE_ASPGRP = "*ASPGRP";
    private String aspFilterType = "";
    public static final String ASP_DEV_CURRENT = "*";
    public static final String ASP_DEV_CURASPGRP = "*CURASPGRP";
    public static final String ASP_DEV_SYSBAS = "*SYSBAS";
    public static final String ASP_DEV_ALLAVL = "*ALLAVL";
    private String aspFilterDevice = "*";
    public static final String OBJAUT_ALL = "*ALL";
    public static final String OBJAUT_CHANGE = "*CHANGE";
    public static final String OBJAUT_USE = "*USE";
    public static final String OBJAUT_AUTLMGT = "*AUTLMGT";
    public static final String OBJAUT_OBJOPR = "*OBJOPR";
    public static final String OBJAUT_OBJMGT = "*OBJMGT";
    public static final String OBJAUT_OBJEXIST = "*OBJEXIST";
    public static final String OBJAUT_OBJALTER = "*OBJALTER";
    public static final String OBJAUT_OBJREF = "*OBJREF";
    public static final String OBJAUT_READ = "*READ";
    public static final String OBJAUT_ADD = "*ADD";
    public static final String OBJAUT_UPD = "*UPD";
    public static final String OBJAUT_DLT = "*DLT";
    public static final String OBJAUT_EXECUTE = "*EXECUTE";
    public static final String OBJAUT_ANY = "*ANY";
    private String[] objAutList = new String[0];
    public static final String LIBAUT_ALL = "*ALL";
    public static final String LIBAUT_CHANGE = "*CHANGE";
    public static final String LIBAUT_USE = "*USE";
    public static final String LIBAUT_OBJOPR = "*OBJOPR";
    public static final String LIBAUT_OBJMGT = "*OBJMGT";
    public static final String LIBAUT_OBJEXIST = "*OBJEXIST";
    public static final String LIBAUT_OBJALTER = "*OBJALTER";
    public static final String LIBAUT_OBJREF = "*OBJREF";
    public static final String LIBAUT_READ = "*READ";
    public static final String LIBAUT_ADD = "*ADD";
    public static final String LIBAUT_UPD = "*UPD";
    public static final String LIBAUT_DLT = "*DLT";
    public static final String LIBAUT_EXECUTE = "*EXECUTE";
    private String[] libAutList = new String[0];

    public String getName() {
        return this.library + '/' + this.object;
    }

    public String getDescription() {
        return this.type;
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("The library filter is null.");
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() == 0) {
            throw new IllegalArgumentException(rbh.getMsg("LFBlank"));
        }
        if (string2.endsWith(ASP_DEV_CURRENT)) {
            throw new IllegalArgumentException(rbh.getMsg("LFGeneric"));
        }
        if (!(!string2.startsWith(ASP_DEV_CURRENT) || string2.equals("*ALL") || string2.equals("*ALLUSR") || string2.equals(LIB_CURLIB) || string2.equals(LIB_LIBL) || string2.equals(LIB_USRLIBL))) {
            throw new IllegalArgumentException(rbh.getMsg("LFSpecial", (Object)string2));
        }
        this.library = string2;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String string) {
        if (string == null) {
            throw new NullPointerException("The object filter is null.");
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() == 0) {
            throw new IllegalArgumentException(rbh.getMsg("OFBlank"));
        }
        if (string2.startsWith(ASP_DEV_CURRENT) && !string2.equals("*ALL") && !string2.equals("*ALLUSR") && !string2.equals(OBJ_IBM)) {
            throw new IllegalArgumentException(rbh.getMsg("OFSpecial", (Object)string2));
        }
        this.object = string2;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        if (string == null) {
            throw new NullPointerException("The object type value for the filter is null.");
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() == 0) {
            throw new IllegalArgumentException(rbh.getMsg("TFBlank"));
        }
        if (!string2.equals("*ALL") && !string2.startsWith(ASP_DEV_CURRENT)) {
            throw new IllegalArgumentException(rbh.getMsg("TFStartWith"));
        }
        this.type = string2;
        this.defaultAuthLists(string2);
    }

    public void setASPFilter(String string, String string2, boolean bl) {
        String string3 = string;
        String string4 = string2;
        if (string3 == null) {
            throw new NullPointerException("The ASP type value is null.");
        }
        if (string4 == null) {
            throw new NullPointerException("The ASP device value is null.");
        }
        string3 = string3.trim().toUpperCase();
        string4 = string4.trim().toUpperCase();
        if (string3.equals(ASP_TYPE_ASP)) {
            if (string4.length() == 0) {
                throw new IllegalArgumentException(rbh.getMsg("ASPDevBlank"));
            }
            if (string4.length() > 10) {
                throw new IllegalArgumentException(rbh.getMsg("ASPDevTooLong"));
            }
            this.aspFilterType = ASP_TYPE_ASP;
            this.aspFilterDevice = string4;
            this.includeSysbas = false;
            return;
        }
        if (string3.equals(ASP_TYPE_ASPGRP)) {
            if (string4.length() == 0) {
                throw new IllegalArgumentException(rbh.getMsg("ASPGrpBlank"));
            }
            if (string4.length() > 10) {
                throw new IllegalArgumentException(rbh.getMsg("ASPGrpTooLong"));
            }
            this.aspFilterType = ASP_TYPE_ASPGRP;
            this.aspFilterDevice = string4;
            this.includeSysbas = bl;
            return;
        }
        if (string3.length() == 0) {
            if (!(string4.equals(ASP_DEV_CURRENT) || string4.equals(ASP_DEV_SYSBAS) || string4.equals(ASP_DEV_CURASPGRP) || string4.equals(ASP_DEV_ALLAVL))) {
                throw new IllegalArgumentException(rbh.getMsg("ASPGrpSpecial", (Object)string4));
            }
            this.aspFilterType = "";
            this.aspFilterDevice = string4;
            this.includeSysbas = false;
            return;
        }
        throw new IllegalArgumentException(rbh.getMsg("ASPTypeInvalid", (Object)string3));
    }

    public String getASPFilterType() {
        return this.aspFilterType;
    }

    public String getASPFilterDevice() {
        return this.aspFilterDevice;
    }

    public boolean isIncludeSysbas() {
        return this.includeSysbas;
    }

    private void defaultAuthLists(String string) {
        String[] stringArray = new String[]{"*EXECUTE"};
        this.setLibAutList(stringArray);
        if (string.equals("*LIB")) {
            String[] stringArray2 = new String[]{"*EXECUTE"};
            this.setObjAutList(stringArray2);
        } else {
            String[] stringArray3 = new String[]{OBJAUT_ANY};
            this.setObjAutList(stringArray3);
        }
    }

    public String[] getObjAutList() {
        return this.objAutList;
    }

    public void setObjAutList(String[] stringArray) {
        this.objAutList = stringArray;
    }

    public String[] getLibAutList() {
        return this.libAutList;
    }

    public void setLibAutList(String[] stringArray) {
        this.libAutList = stringArray;
    }
}

