/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.busobj;

import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ValidationHelper;

public class OS400JobDescriptor
extends Proxy {
    private static final long serialVersionUID = -6746484461478465697L;
    public static final int MAX_LENGTH_JOB_NUMBER = 6;
    public static final int MAX_VALUE_JOB_NUMBER = 999999;
    public static final int MAX_LENGTH_JOB_NAME = 10;
    public static final int MAX_LENGTH_JOB_USER = 10;
    private String jobNumber;
    private String jobName;
    private String jobUser;

    public OS400JobDescriptor(String string, String string2, String string3) {
        this.setJobName(string);
        this.setJobUser(string2);
        this.setJobNumber(string3);
    }

    public OS400JobDescriptor(String string) {
        this.setAll(string);
    }

    public OS400JobDescriptor() {
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobUser() {
        return this.jobUser;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public String getName() {
        return this.getQualifiedName();
    }

    public String getQualifiedName(String string, String string2, String string3) {
        String string4 = string3.trim() + "/" + string2.trim() + "/" + string.trim();
        return string4;
    }

    public String getQualifiedName() {
        String string = this.jobNumber.trim() + "/" + this.jobUser.trim() + "/" + this.jobName.trim();
        return string;
    }

    public void setJobNumber(String string) throws NullPointerException, IllegalArgumentException {
        ValidationHelper.checkForNullAndBlank((String)"Job number", (String)string);
        String string2 = string;
        if (!string2.startsWith("*")) {
            if (string2.length() > 0 && string2.length() < 6) {
                while (string2.length() < 6) {
                    string2 = "0" + string2;
                }
            }
            if (string2.length() != 6) {
                throw new IllegalArgumentException("Job Number " + string2 + " is not valid. It must be exactly " + 6 + " characters long.");
            }
            try {
                Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Job Number " + string2 + " is not valid.");
            }
        }
        this.jobNumber = string2;
    }

    public void setJobName(String string) throws NullPointerException, IllegalArgumentException {
        ValidationHelper.checkForNullAndBlank((String)"Job name", (String)string);
        ValidationHelper.validateLength((String)"Job name", (int)10, (String)string);
        this.jobName = string;
    }

    public void setJobUser(String string) throws NullPointerException, IllegalArgumentException {
        ValidationHelper.checkForNullAndBlank((String)"Job user", (String)string);
        ValidationHelper.validateLength((String)"Job user", (int)10, (String)string);
        this.jobUser = string;
    }

    public void setAll(String string) throws NullPointerException, IllegalArgumentException {
        if (string.indexOf("/") == string.lastIndexOf("/")) {
            throw new IllegalArgumentException("Qualified job name not valid.  The required format is job-number/job-user/job-name.");
        }
        try {
            this.setJobNumber(string.substring(0, string.indexOf("/")));
            this.setJobUser(string.substring(string.indexOf("/") + 1, string.lastIndexOf("/")));
            this.setJobName(string.substring(string.lastIndexOf("/") + 1));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public static String createQualifiedJobName(String string, String string2, String string3) {
        return new OS400JobDescriptor(string3, string2, string).getQualifiedName(string3, string2, string);
    }

    public String toString() {
        return this.jobNumber + "/" + this.jobUser + "/" + this.jobName;
    }
}

