/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400ObjectPool;
import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.busobj.OS400LibraryList;
import com.helpsystems.common.as400.ex.CommandExecutionMessage;
import com.helpsystems.common.as400.ex.RobotSyslibUnavailableException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import org.apache.log4j.Logger;

public class WrappedAS400
extends AS400 {
    private static final Logger logger = Logger.getLogger(WrappedAS400.class);
    private AS400ObjectPool pool;
    protected String sysLibOverride = null;
    protected String rbtsyslib = null;
    protected boolean sysLibInQSYSLIBL = true;
    boolean isClosed;
    private boolean isOneTimeUse;
    private int as400ObjectOverrideCcsid;
    private int commandServerCcsidToRestore;

    public WrappedAS400(String string, String string2) {
        super(string, string2);
    }

    public void close() throws ResourceUnavailableException {
        if (this.isClosed) {
            AbstractAS400Manager.logCaller(this, "already closed");
            return;
        }
        this.isClosed = true;
        if (this.isOneTimeUse) {
            AbstractAS400Manager.logCaller(this, "one-time-use closed");
            this.disconnectAllServices();
            return;
        }
        Object var1_1 = null;
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            AbstractAS400Manager.logCaller(this, "released");
            this.pool.returnObject((Object)this);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to return an AS400 object to the pool.", (Throwable)exception);
            resourceUnavailableException = exception instanceof ResourceUnavailableException ? (ResourceUnavailableException)((Object)exception) : new ResourceUnavailableException("Error returning an AS400 object to the pool.", (Throwable)exception);
        }
        if (resourceUnavailableException != null) {
            throw resourceUnavailableException;
        }
        if (var1_1 != null) {
            throw var1_1;
        }
    }

    boolean isOneTimeUse() {
        return this.isOneTimeUse;
    }

    void setOneTimeUse(boolean bl) {
        this.isOneTimeUse = bl;
    }

    public void setupUserLibl(OS400LibraryList oS400LibraryList) throws ResourceUnavailableException {
        Object object;
        ProgramParameter[] programParameterArray;
        CommandCall commandCall;
        ValidationHelper.checkForNull((String)"LibraryList", (Object)((Object)oS400LibraryList));
        String string = "CHGLIBL LIBL(" + oS400LibraryList.getLibrariesAsParameter() + ") CURLIB(*CRTDFT)";
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            commandCall = new CommandCall((AS400)this);
            if (!AbstractAS400Manager.runCommand(string, commandCall)) {
                programParameterArray = new StringBuffer();
                programParameterArray.append("Unable to override User Library List: ");
                programParameterArray.append(string);
                programParameterArray.append(" \n");
                object = AbstractAS400Manager.extractMessages(commandCall);
                programParameterArray.append(AbstractAS400Manager.messagesToString((CommandExecutionMessage[])object));
                resourceUnavailableException = new ResourceUnavailableException(programParameterArray.toString(), null);
            }
        }
        catch (Exception exception) {
            resourceUnavailableException = new ResourceUnavailableException("Unable to override User Library List.", (Throwable)exception);
        }
        if (!this.sysLibInQSYSLIBL) {
            try {
                commandCall = new ProgramCall((AS400)this);
                commandCall.setProgram("/QSYS.LIB/" + this.rbtsyslib + ".LIB/RSL044.PGM");
                programParameterArray = new ProgramParameter[]{new ProgramParameter(1, this.getStringParm(this.rbtsyslib)), new ProgramParameter(1, this.getStringParm(this.sysLibOverride)), new ProgramParameter(1, this.getStringParm("          "))};
                commandCall.setParameterList(programParameterArray);
                if (!commandCall.run()) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Unable to set system library on server job.");
                    ((StringBuffer)object).append(" \n");
                    ((StringBuffer)object).append(AbstractAS400Manager.messagesToString(commandCall.getMessageList()));
                    logger.trace((Object)((StringBuffer)object).toString());
                }
            }
            catch (Throwable throwable) {
                logger.trace((Object)"Error calling program RSL044", throwable);
            }
        }
        if (resourceUnavailableException != null) {
            throw resourceUnavailableException;
        }
    }

    public void setASPGroup(String string) throws ResourceUnavailableException {
        String string2 = string;
        if (string2 == null) {
            string2 = "*NONE";
        }
        String string3 = "SETASPGRP ASPGRP(" + string2 + ")";
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            CommandCall commandCall = new CommandCall((AS400)this);
            if (!AbstractAS400Manager.runCommand(string3, commandCall)) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Unable to set the ASP Group: ");
                stringBuffer.append(string3);
                stringBuffer.append(" \n");
                CommandExecutionMessage[] commandExecutionMessageArray = AbstractAS400Manager.extractMessages(commandCall);
                stringBuffer.append(AbstractAS400Manager.messagesToString(commandExecutionMessageArray));
                resourceUnavailableException = new ResourceUnavailableException(stringBuffer.toString(), null);
            }
        }
        catch (Exception exception) {
            resourceUnavailableException = new ResourceUnavailableException("An error occurred while trying to set the ASP Group.", (Throwable)exception);
        }
        if (resourceUnavailableException != null) {
            throw resourceUnavailableException;
        }
    }

    public void cleanSystemLibl(String string, String string2) throws ResourceUnavailableException {
        if (string == null) {
            throw new NullPointerException("The library name passed in is null.");
        }
        this.rbtsyslib = string;
        ResourceUnavailableException resourceUnavailableException = null;
        try {
            ProgramCall programCall = new ProgramCall((AS400)this);
            programCall.setProgram("/QSYS.LIB/" + string + ".LIB/RSL042.PGM");
            ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(1, this.getStringParm(string)), new ProgramParameter(1, this.getStringParm(string2)), new ProgramParameter(1, this.getStringParm("          "), 10)};
            programCall.setParameterList(programParameterArray);
            if (!programCall.run()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Unable to clean up system library on server job.");
                stringBuffer.append(" \n");
                stringBuffer.append(AbstractAS400Manager.messagesToString(programCall.getMessageList()));
                resourceUnavailableException = new ResourceUnavailableException(stringBuffer.toString(), null);
            } else {
                AS400Text aS400Text = new AS400Text(10);
                String string3 = (String)aS400Text.toObject(programParameterArray[2].getOutputData());
                if (string3 != null && string3.trim().equals("4")) {
                    this.sysLibInQSYSLIBL = false;
                }
            }
        }
        catch (ObjectDoesNotExistException objectDoesNotExistException) {
            resourceUnavailableException = new RobotSyslibUnavailableException("Robot/SYSLIB is not installed or needs to be updated on this system .", objectDoesNotExistException);
        }
        catch (Exception exception) {
            resourceUnavailableException = new ResourceUnavailableException("Unable to override the system library list.", (Throwable)exception);
        }
        if (resourceUnavailableException != null) {
            throw resourceUnavailableException;
        }
        this.sysLibOverride = string2;
    }

    private byte[] getStringParm(String string) {
        int n = this.getCcsid();
        AS400Text aS400Text = new AS400Text(10, n, (AS400)this);
        byte[] byArray = new byte[10];
        aS400Text.toBytes((Object)string, byArray, 0);
        return byArray;
    }

    public void setPool(AS400ObjectPool aS400ObjectPool) {
        this.pool = aS400ObjectPool;
    }

    AS400ObjectPool getPool() {
        return this.pool;
    }

    public void setAs400ObjectOverrideCcsid(int n) {
        this.as400ObjectOverrideCcsid = n;
    }

    public int getCcsid() {
        if (this.as400ObjectOverrideCcsid != 0) {
            return this.as400ObjectOverrideCcsid;
        }
        return super.getCcsid();
    }

    public int getCommandServerCcsidToRestore() {
        return this.commandServerCcsidToRestore;
    }

    public void setCommandServerCcsidToRestore(int n) {
        this.commandServerCcsidToRestore = n;
    }

    public String getSysLibrary() {
        return this.rbtsyslib;
    }

    void setSysLibrary(String string) {
        this.rbtsyslib = string;
    }
}

