/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.AS400TestEnv;
import com.helpsystems.common.as400.busobj.OS400SpooledFile;
import com.helpsystems.common.as400.busobj.OS400SpooledFileLine;
import com.helpsystems.common.as400.busobj.OS400SpooledFileProxy;
import com.helpsystems.common.as400.dm.OS400SpooledFileDM;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;

public class OS400SpooledFileDMTester {
    private OS400SpooledFileDM dm;

    public void testEmptyFilter() {
        this.testList(new DataFilter());
    }

    public void testList(DataFilter dataFilter) {
        this.dm = (OS400SpooledFileDM)ManagerRegistry.getManagerStartsWith((String)"COMMON.OS400SpooledFileDM");
        try {
            DataSet dataSet = this.dm.getList(UserIdentity.NO_USER_SPECIFIED, dataFilter, (SortField)new GenericSortField(11, 0));
            for (int i = 0; i < dataSet.size(); ++i) {
                Object[] objectArray = dataSet.get(i, 1);
                OS400SpooledFileProxy oS400SpooledFileProxy = (OS400SpooledFileProxy)((Object)objectArray[0]);
                String string = oS400SpooledFileProxy.getJobName() + " " + oS400SpooledFileProxy.getJobNumber() + " " + oS400SpooledFileProxy.getJobUser() + " " + oS400SpooledFileProxy.getSpooledFileName() + " " + oS400SpooledFileProxy.getSpooledFileNumber() + " " + oS400SpooledFileProxy.getStatusAsString() + " Priority: " + oS400SpooledFileProxy.getOutputPriority() + " " + oS400SpooledFileProxy.getDateFileOpened() + " size: " + oS400SpooledFileProxy.getSize() + " outq: " + oS400SpooledFileProxy.getOutputQueueLibrary() + " " + oS400SpooledFileProxy.getOutputQueue();
                System.out.println(string);
            }
            System.out.println("Total: " + dataSet.size());
            dataSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testSorting() {
        GenericSortField genericSortField = new GenericSortField(12, 1);
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("user", (Serializable)((Object)"MATT"), 1));
        this.dm = (OS400SpooledFileDM)ManagerRegistry.getManagerStartsWith((String)"COMMON.OS400SpooledFileDM");
        try {
            DataSet dataSet = this.dm.getList(UserIdentity.NO_USER_SPECIFIED, dataFilter, (SortField)genericSortField);
            for (int i = 0; i < dataSet.size(); ++i) {
                Object[] objectArray = dataSet.get(i, 1);
                OS400SpooledFileProxy oS400SpooledFileProxy = (OS400SpooledFileProxy)((Object)objectArray[0]);
                String string = oS400SpooledFileProxy.getJobName() + " " + oS400SpooledFileProxy.getJobNumber() + " " + oS400SpooledFileProxy.getJobUser() + " " + oS400SpooledFileProxy.getSpooledFileName() + " " + oS400SpooledFileProxy.getSpooledFileNumber() + " " + oS400SpooledFileProxy.getStatusAsString() + " Priority: " + oS400SpooledFileProxy.getOutputPriority() + " " + oS400SpooledFileProxy.getDateFileOpened() + " size: " + oS400SpooledFileProxy.getSize() + " outq: " + oS400SpooledFileProxy.getOutputQueueLibrary() + " " + oS400SpooledFileProxy.getOutputQueue() + " Pages: " + oS400SpooledFileProxy.getTotalPages() + " Description: " + oS400SpooledFileProxy.getDescription();
                System.out.println(string);
            }
            System.out.println("Total: " + dataSet.size());
            dataSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testSave() {
        this.dm = (OS400SpooledFileDM)ManagerRegistry.getManagerStartsWith((String)"COMMON.OS400SpooledFileDM");
        try {
            GenericSortField genericSortField = new GenericSortField(4, 0);
            DataFilter dataFilter = new DataFilter();
            dataFilter.addCriteria(new FilterCriteria("user", (Serializable)((Object)"MATT"), 1));
            DataSet dataSet = this.dm.getList(UserIdentity.NO_USER_SPECIFIED, dataFilter, (SortField)genericSortField);
            Object[] objectArray = dataSet.get(dataSet.size() - 1, 1);
            OS400SpooledFileProxy oS400SpooledFileProxy = (OS400SpooledFileProxy)((Object)objectArray[0]);
            dataSet.close();
            OS400SpooledFile oS400SpooledFile = this.dm.getSpooledFile(UserIdentity.NO_USER_SPECIFIED, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
            oS400SpooledFile.setCopiesLeftToPrint(oS400SpooledFile.getCopiesLeftToPrint() + 1);
            oS400SpooledFile.setOutputPriority(9);
            oS400SpooledFile.setFormType(oS400SpooledFile.getFormType() + "1");
            oS400SpooledFile.setUserData(oS400SpooledFile.getUserData() + "1");
            oS400SpooledFile.setOutputQueue("ABC");
            oS400SpooledFile.setOutputQueueLibrary("MATT");
            oS400SpooledFile.setSaveAfterWritten(true);
            this.dm.save(UserIdentity.NO_USER_SPECIFIED, oS400SpooledFile);
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
    }

    public void testDelete() {
        this.dm = (OS400SpooledFileDM)ManagerRegistry.getManagerStartsWith((String)"COMMON.OS400SpooledFileDM");
        try {
            GenericSortField genericSortField = new GenericSortField(4, 0);
            DataFilter dataFilter = new DataFilter();
            dataFilter.addCriteria(new FilterCriteria("user", (Serializable)((Object)"MATT"), 1));
            DataSet dataSet = this.dm.getList(UserIdentity.NO_USER_SPECIFIED, dataFilter, (SortField)genericSortField);
            Object[] objectArray = dataSet.get(dataSet.size() - 1, 1);
            OS400SpooledFileProxy oS400SpooledFileProxy = (OS400SpooledFileProxy)((Object)objectArray[0]);
            dataSet.close();
            OS400SpooledFile oS400SpooledFile = this.dm.getSpooledFile(UserIdentity.NO_USER_SPECIFIED, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
            this.dm.delete(UserIdentity.NO_USER_SPECIFIED, oS400SpooledFile);
            System.out.println("Deleted: " + oS400SpooledFile.getSpooledFileName() + " " + oS400SpooledFile.getSpooledFileNumber() + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void testPageData() {
        this.dm = (OS400SpooledFileDM)ManagerRegistry.getManagerStartsWith((String)"COMMON.OS400SpooledFileDM");
        try {
            GenericSortField genericSortField = new GenericSortField(4, 0);
            DataFilter dataFilter = new DataFilter();
            dataFilter.addCriteria(new FilterCriteria("user", (Serializable)((Object)"MATT"), 1));
            dataFilter.addCriteria(new FilterCriteria("userData", (Serializable)((Object)"E"), 1));
            DataSet dataSet = this.dm.getList(UserIdentity.NO_USER_SPECIFIED, dataFilter, (SortField)genericSortField);
            Object[] objectArray = dataSet.get(dataSet.size() - 1, 1);
            OS400SpooledFileProxy oS400SpooledFileProxy = (OS400SpooledFileProxy)((Object)objectArray[0]);
            dataSet.close();
            DataSet dataSet2 = this.dm.getSpooledFileLineData(UserIdentity.NO_USER_SPECIFIED, oS400SpooledFileProxy);
            int n = 1;
            int n2 = 50;
            String string = n + "-" + n2 + " " + oS400SpooledFileProxy.getSpooledFileName() + ".txt";
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            Object[] objectArray2 = dataSet2.get(n, n2);
            while (objectArray2.length > 0) {
                for (int i = 0; i < objectArray2.length; ++i) {
                    OS400SpooledFileLine oS400SpooledFileLine = (OS400SpooledFileLine)((Object)objectArray2[i]);
                    String[] stringArray = oS400SpooledFileLine.getAllLines();
                    for (int j = 0; j < stringArray.length; ++j) {
                        System.out.println(stringArray[j]);
                        printWriter.println(stringArray[j]);
                    }
                }
                objectArray2 = dataSet2.get(n += n2, n2);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AS400TestEnv.start(stringArray[0], stringArray[1], stringArray[2], 2);
        OS400SpooledFileDMTester oS400SpooledFileDMTester = new OS400SpooledFileDMTester();
        oS400SpooledFileDMTester.testSorting();
    }
}

