/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400SpooledFileProxy;
import com.helpsystems.common.as400.dm.OS400SpooledFileAM;
import com.helpsystems.common.as400.util.OS400Utilities;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.SpooledFile;

public class OS400SpooledFileAMAS400
extends AbstractAS400Manager
implements OS400SpooledFileAM {
    private static final int ACTION_HOLD = 0;
    private static final int ACTION_MOVE_TO_TOP = 1;
    private static final int ACTION_RELEASE = 2;

    public OS400SpooledFileAMAS400(String string, String string2) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    @Override
    public void hold(OS400SpooledFileProxy oS400SpooledFileProxy, UserIdentity userIdentity) throws ResourceUnavailableException {
        this.performAction(oS400SpooledFileProxy, userIdentity, 0);
    }

    @Override
    public void moveToTop(OS400SpooledFileProxy oS400SpooledFileProxy, UserIdentity userIdentity) throws ResourceUnavailableException {
        this.performAction(oS400SpooledFileProxy, userIdentity, 1);
    }

    @Override
    public void release(OS400SpooledFileProxy oS400SpooledFileProxy, UserIdentity userIdentity) throws ResourceUnavailableException {
        this.performAction(oS400SpooledFileProxy, userIdentity, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performAction(OS400SpooledFileProxy oS400SpooledFileProxy, UserIdentity userIdentity, int n) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"OS400SpooledFileProxy", (Object)((Object)oS400SpooledFileProxy));
        String string = "accessing";
        WrappedAS400 wrappedAS400 = this.createConnectionForUser(userIdentity);
        try {
            SpooledFile spooledFile = new SpooledFile((AS400)wrappedAS400, oS400SpooledFileProxy.getSpooledFileName(), oS400SpooledFileProxy.getSpooledFileNumber(), oS400SpooledFileProxy.getJobName(), oS400SpooledFileProxy.getJobUser(), oS400SpooledFileProxy.getJobNumber());
            switch (n) {
                case 0: {
                    string = "holding";
                    spooledFile.hold("*IMMED");
                    return;
                }
                case 1: {
                    string = "moving";
                    spooledFile.moveToTop();
                    return;
                }
                case 2: {
                    string = "releasing";
                    spooledFile.release();
                    return;
                }
            }
            return;
        }
        catch (AS400Exception aS400Exception) {
            String string2 = OS400Utilities.convertAS400ExceptionToString(aS400Exception);
            throw new ResourceUnavailableException(string2, (Throwable)aS400Exception);
        }
        catch (Exception exception) {
            String string3 = "Error " + string + " OS400 spooled file.";
            throw new ResourceUnavailableException(string3, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }
}

