/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AS400ObjectPool;
import com.helpsystems.common.as400.access.AS400PoolManager;
import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.OS400LibraryList;
import com.helpsystems.common.as400.dm.OS400ProfileDM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.JobDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.User;
import java.io.Serializable;

public class OS400ProfileDMAS400
extends AbstractAS400Manager
implements OS400ProfileDM {
    public OS400ProfileDMAS400(String string, String string2) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        this.setName(string2);
    }

    @Override
    public String getGroupProfileName(UserIdentity userIdentity) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        String string = null;
        String string2 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            Job[] jobArray = wrappedAS400.getJobs(2);
            jobArray[0].loadInformation();
            string2 = (String)jobArray[0].getValue(305);
            User user = new User();
            user.setSystem((AS400)wrappedAS400);
            user.setName(string2);
            user.loadUserInformation();
            string = user.getGroupProfileName().trim();
            if (string != null && string.equalsIgnoreCase("*NONE")) {
                String string3 = null;
                return string3;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string2, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJobDescriptionName(UserIdentity userIdentity) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            String string = this.getJobDescriptionName(wrappedAS400);
            return string;
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private String getJobDescriptionName(AS400 aS400) throws ResourceUnavailableException {
        String string = null;
        String string2 = null;
        try {
            Job[] jobArray = aS400.getJobs(2);
            jobArray[0].loadInformation();
            string2 = (String)jobArray[0].getValue(305);
            User user = new User();
            user.setSystem(aS400);
            user.setName(string2);
            user.loadUserInformation();
            string = user.getJobDescription().trim();
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string2, (Throwable)exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJobDescriptionASPGroup(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            String string2 = this.getJobDescriptionASPGroup(string, wrappedAS400);
            return string2;
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private String getJobDescriptionASPGroup(String string, AS400 aS400) throws ResourceUnavailableException {
        String string2 = null;
        String string3 = null;
        try {
            JobDescription jobDescription = new JobDescription(aS400, new QSYSObjectPathName(string));
            jobDescription.refresh();
            String[] stringArray = jobDescription.getInitialASPGroupNames();
            if (stringArray != null && stringArray.length != 0) {
                string2 = stringArray[0];
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string3, (Throwable)exception);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getJobDescriptionLibl(UserIdentity userIdentity, String string) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            String[] stringArray = this.getJobDescriptionLibl(string, wrappedAS400);
            return stringArray;
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    private String[] getJobDescriptionLibl(String string, AS400 aS400) throws ResourceUnavailableException {
        String[] stringArray = null;
        String string2 = null;
        try {
            JobDescription jobDescription = new JobDescription(aS400, new QSYSObjectPathName(string));
            stringArray = jobDescription.getInitialLibraryList();
            if (stringArray != null) {
                if (stringArray[0].trim().equals("*SYSVAL")) {
                    SystemValue systemValue = new SystemValue(aS400, "QUSRLIBL");
                    stringArray = (String[])systemValue.getValue();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = stringArray[i].trim();
                }
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string2, (Throwable)exception);
        }
        return stringArray;
    }

    @Override
    public boolean isAllObjectAuthority(UserIdentity userIdentity) throws ResourceUnavailableException {
        boolean bl;
        block7: {
            WrappedAS400 wrappedAS400 = null;
            bl = false;
            String string = null;
            try {
                wrappedAS400 = this.borrowConnection(userIdentity);
                Job[] jobArray = wrappedAS400.getJobs(2);
                jobArray[0].loadInformation();
                string = (String)jobArray[0].getValue(305);
                User user = new User();
                user.setSystem((AS400)wrappedAS400);
                user.setName(string);
                user.loadUserInformation();
                String[] stringArray = user.getSpecialAuthority();
                if (stringArray == null || stringArray.length <= 0) break block7;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(User.SPECIAL_AUTHORITY_ALL_OBJECT)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string, (Throwable)exception);
            }
            finally {
                if (wrappedAS400 != null) {
                    this.releaseConnection(wrappedAS400);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isGroupProfileAllObjectAuthority(UserIdentity userIdentity) throws ResourceUnavailableException {
        boolean bl;
        block7: {
            WrappedAS400 wrappedAS400 = null;
            bl = false;
            String string = null;
            try {
                wrappedAS400 = this.borrowConnection(userIdentity);
                string = this.getGroupProfileName(userIdentity);
                if (string == null) break block7;
                User user = new User();
                user.setSystem((AS400)wrappedAS400);
                user.setName(string);
                user.loadUserInformation();
                String[] stringArray = user.getSpecialAuthority();
                if (stringArray == null || stringArray.length <= 0) break block7;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(User.SPECIAL_AUTHORITY_ALL_OBJECT)) continue;
                    bl = true;
                    break;
                }
            }
            catch (Exception exception) {
                throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string, (Throwable)exception);
            }
            finally {
                if (wrappedAS400 != null) {
                    this.releaseConnection(wrappedAS400);
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isUserSecurityOfficer(UserIdentity userIdentity) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        boolean bl = false;
        String string = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            Job[] jobArray = wrappedAS400.getJobs(2);
            jobArray[0].loadInformation();
            string = (String)jobArray[0].getValue(305);
            User user = new User();
            user.setSystem((AS400)wrappedAS400);
            user.setName(string);
            user.loadUserInformation();
            String string2 = user.getUserClassName();
            if (string2.equals("*SECOFR")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to retrieve profile information for user " + string, (Throwable)exception);
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserIdentity loadLiblInUserIdentity(UserIdentity userIdentity, OS400LibraryList oS400LibraryList) throws ResourceUnavailableException {
        WrappedAS400 wrappedAS400 = null;
        try {
            wrappedAS400 = this.borrowConnection(userIdentity);
            String string = this.getJobDescriptionName(wrappedAS400);
            String string2 = this.getJobDescriptionASPGroup(string, wrappedAS400);
            String[] stringArray = this.getJobDescriptionLibl(string, wrappedAS400);
            for (int i = 0; i < stringArray.length; ++i) {
                oS400LibraryList.addLibrary(stringArray[i].trim());
            }
            UserIdentity userIdentity2 = this.updateLiblInUserIdentity(userIdentity, oS400LibraryList, string2);
            return userIdentity2;
        }
        finally {
            if (wrappedAS400 != null) {
                this.releaseConnection(wrappedAS400);
            }
        }
    }

    @Override
    public UserIdentity updateLiblInUserIdentity(UserIdentity userIdentity, OS400LibraryList oS400LibraryList, String string) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = this.getIdentity(userIdentity);
        userIdentity2.setAttribute((Serializable)((Object)"os400.library_list"), (Serializable)((Object)oS400LibraryList));
        userIdentity2.setAttribute((Serializable)((Object)"os400.asp_group"), (Serializable)((Object)string));
        return userIdentity;
    }

    @Override
    public OS400LibraryList getLocalLibraryList(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = this.getIdentity(userIdentity);
        return (OS400LibraryList)((Object)userIdentity2.getAttribute((Serializable)((Object)"os400.library_list")));
    }

    @Override
    public String getASPGroupName(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = this.getIdentity(userIdentity);
        return (String)((Object)userIdentity2.getAttribute((Serializable)((Object)"os400.asp_group")));
    }

    private UserIdentity getIdentity(UserIdentity userIdentity) throws ResourceUnavailableException {
        UserIdentity userIdentity2 = userIdentity;
        AS400ObjectPool aS400ObjectPool = (AS400ObjectPool)AS400PoolManager.getInstance().getPool(this.poolName);
        if (!userIdentity.equals((Object)UserIdentity.NO_USER_SPECIFIED) && !aS400ObjectPool.getDescriptor().getDirectConnectPool()) {
            userIdentity2 = this.findIdentity(userIdentity);
        }
        return userIdentity2;
    }
}

