/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.as400.access;

import com.helpsystems.common.as400.access.AbstractAS400Manager;
import com.helpsystems.common.as400.access.WrappedAS400;
import com.helpsystems.common.as400.busobj.MessageSubstitutionVariable;
import com.helpsystems.common.as400.busobj.OS400MessageDescription;
import com.helpsystems.common.as400.dm.OS400MessageDescriptionDM;
import com.helpsystems.common.as400.dm.OS400UtilitiesAM;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.ValidationHelper;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.util.HashMap;

public class OS400MessageDescriptionDMAS400
extends AbstractAS400Manager
implements OS400MessageDescriptionDM {
    OS400UtilitiesAM os400UtilitiesAM;

    public OS400MessageDescriptionDMAS400(String string, String string2, OS400UtilitiesAM oS400UtilitiesAM) {
        super(string);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string2);
        ValidationHelper.checkForNull((String)"OS400UtilitiesAM", (Object)oS400UtilitiesAM);
        this.os400UtilitiesAM = oS400UtilitiesAM;
        this.setName(string2);
    }

    @Override
    public OS400MessageDescription get(UserIdentity userIdentity, String string, String string2, String string3, boolean bl) throws ResourceUnavailableException {
        return this.get(userIdentity, string, string2, string3, bl, null);
    }

    @Override
    public OS400MessageDescription get(UserIdentity userIdentity, String string, String string2, String string3, boolean bl, String string4) throws ResourceUnavailableException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        CharConverter charConverter;
        ValidationHelper.checkForNull((String)"User Identity", (Object)userIdentity);
        ValidationHelper.checkForNullAndBlank((String)"Library Name", (String)string);
        ValidationHelper.checkForNullAndBlank((String)"Message File Name", (String)string2);
        ValidationHelper.checkForNullAndBlank((String)"Message Identifier", (String)string3);
        boolean bl2 = this.os400UtilitiesAM.objectExists(userIdentity, string2, string, "*MSGF");
        if (!bl2) {
            throw new ResourceUnavailableException("Message File " + string2 + " in library " + string + " does not exist.");
        }
        String string5 = string.trim();
        if (string2 == null) {
            throw new NullPointerException("The message file name passed in is null.");
        }
        String string6 = string2.trim();
        if (string3 == null) {
            throw new NullPointerException("The message identifier passed in is null.");
        }
        WrappedAS400 wrappedAS400 = null;
        wrappedAS400 = this.borrowConnection(userIdentity);
        try {
            charConverter = new CharConverter(wrappedAS400.getCcsid());
            byArray3 = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            charConverter.stringToByteArray(string6, byArray3, 0, 10);
            charConverter.stringToByteArray(string5, byArray3, 10, 10);
            byArray2 = new byte[]{64, 64, 64, 64, 64, 64, 64};
            charConverter.stringToByteArray(string3, byArray2, 0, 7);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error retrieving message description", (Throwable)exception);
        }
        byte[] byArray4 = new byte[]{92, -43, -42, 64, 64, 64, 64, 64, 64, 64};
        byte[] byArray5 = new byte[]{92, -24, -59, -30, 64, 64, 64, 64, 64, 64};
        byte[] byArray6 = new byte[]{};
        if (string4 == null) {
            byArray = byArray4;
        } else {
            byArray6 = charConverter.stringToByteArray(string4);
            byArray = byArray5;
        }
        byte[] byArray7 = bl ? byArray5 : byArray4;
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(5120), new ProgramParameter(new byte[]{0, 0, 20, 0}), new ProgramParameter(new byte[]{-39, -29, -27, -44, -16, -12, -16, -16}), new ProgramParameter(byArray2), new ProgramParameter(byArray3), new ProgramParameter(byArray6), new ProgramParameter(BinaryConverter.intToByteArray((int)byArray6.length)), new ProgramParameter(byArray), new ProgramParameter(byArray7), new ProgramParameter(new byte[8])};
        ProgramCall programCall = new ProgramCall((AS400)wrappedAS400, "/QSYS.LIB/QMHRTVM.PGM", programParameterArray);
        programCall.setThreadSafe(true);
        try {
            if (!programCall.run()) {
                throw new ResourceUnavailableException("Error retrieving message description");
            }
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error retrieving message description", (Throwable)exception);
        }
        byte[] byArray8 = programParameterArray[0].getOutputData();
        OS400MessageDescription oS400MessageDescription = new OS400MessageDescription();
        oS400MessageDescription.setMessageId(string3);
        oS400MessageDescription.setMessageFileLibrary(string5);
        oS400MessageDescription.setMessageFileName(string6);
        oS400MessageDescription.setSeverity(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)8));
        oS400MessageDescription.setLogProblem(Convert.ynToBoolean((String)charConverter.byteArrayToString(byArray8, 25, 1)));
        oS400MessageDescription.setAlertOption(charConverter.byteArrayToString(byArray8, 16, 9).trim());
        oS400MessageDescription.setMessageCreationLevel(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)208));
        oS400MessageDescription.setMessageModificationLevel(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)220));
        String string7 = charConverter.byteArrayToString(byArray8, 200, 7);
        oS400MessageDescription.setMessageCreationDate(Convert.getDate((int)Integer.parseInt(string7)));
        String string8 = charConverter.byteArrayToString(byArray8, 212, 7);
        oS400MessageDescription.setMessageModificationDate(Convert.getDate((int)Integer.parseInt(string8)));
        oS400MessageDescription.setReplyType(charConverter.byteArrayToString(byArray8, 104, 10).trim());
        oS400MessageDescription.setReplyLength(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)116));
        oS400MessageDescription.setReplyDecimalPositions(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)120));
        oS400MessageDescription.setCCSID(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)48));
        oS400MessageDescription.setDefaultProgramName(charConverter.byteArrayToString(byArray8, 244, 10).trim());
        oS400MessageDescription.setDefaultProgramLibraryName(charConverter.byteArrayToString(byArray8, 254, 10).trim());
        int n6 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)52);
        int n7 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)56);
        if (n6 > 0 && n7 > 0) {
            oS400MessageDescription.setDefaultReply(charConverter.byteArrayToString(byArray8, n6, n7));
        }
        int n8 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)64);
        int n9 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)68);
        if (n8 > 0 && n9 > 0) {
            oS400MessageDescription.setFirstLevelText(Convert.trimR((String)charConverter.byteArrayToString(byArray8, n8, n9)));
        }
        String string9 = null;
        int n10 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)76);
        int n11 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)80);
        if (n10 > 0 && n11 > 0) {
            string9 = charConverter.byteArrayToString(byArray8, n10, n11);
        }
        if (string9 != null && bl) {
            string9 = MessageFile.substituteFormattingCharacters(string9);
        }
        oS400MessageDescription.setSecondLevelText("");
        if (string9 != null) {
            if (string9.startsWith(oS400MessageDescription.getFirstLevelText())) {
                oS400MessageDescription.setFirstLevelText(Convert.trimR((String)string9));
            } else if (string9.indexOf("\n", 0) == 0) {
                oS400MessageDescription.setSecondLevelText(Convert.trimR((String)string9.substring(1)));
            } else {
                oS400MessageDescription.setSecondLevelText(Convert.trimR((String)string9));
            }
        }
        int n12 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)36);
        int n13 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)88);
        int n14 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)92);
        int n15 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)100);
        if (n13 > 0 && n14 > 0 && n12 > 0) {
            MessageSubstitutionVariable[] messageSubstitutionVariableArray = new MessageSubstitutionVariable[n12];
            for (n5 = 0; n5 < n12; ++n5) {
                MessageSubstitutionVariable messageSubstitutionVariable = new MessageSubstitutionVariable();
                messageSubstitutionVariable.setName("&" + (n5 + 1));
                messageSubstitutionVariable.setLength(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)(n13 + n5 * n15)));
                if (messageSubstitutionVariable.getLength() == -1) {
                    messageSubstitutionVariable.setVaryLength(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)(n13 + n5 * n15 + 4)));
                } else {
                    messageSubstitutionVariable.setDecimalPositions(BinaryConverter.byteArrayToInt((byte[])byArray8, (int)(n13 + n5 * n15 + 4)));
                }
                messageSubstitutionVariable.setType(charConverter.byteArrayToString(byArray8, n13 + n5 * n15 + 8, 8).trim());
                messageSubstitutionVariableArray[n5] = messageSubstitutionVariable;
            }
            oS400MessageDescription.setMessageSubstitutionVariables(messageSubstitutionVariableArray);
        }
        int n16 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)148);
        n5 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)144);
        int n17 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)152);
        int n18 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)160);
        if (n5 > 0 && n17 > 0 && n16 > 0) {
            String string10 = charConverter.byteArrayToString(byArray8, n5, n17);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            n4 = n18 / 2;
            for (n3 = 0; n3 < n16; ++n3) {
                int n19;
                int n20 = n3 * n18;
                n2 = n19 = n20 + n4;
                n = n20 + n18;
                String string11 = string10.substring(n20, n19).trim();
                String string12 = string10.substring(n2, n).trim();
                hashMap.put(string11, string12);
            }
            oS400MessageDescription.setSpecialReplies(hashMap);
        }
        int n21 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)128);
        int n22 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)124);
        n4 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)132);
        n3 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)140);
        if (n22 > 0 && n4 > 0 && n21 > 0) {
            String string13 = charConverter.byteArrayToString(byArray8, n22, n4);
            String[] stringArray = new String[n21];
            for (n2 = 0; n2 < n21; ++n2) {
                n = n2 * n3;
                int n23 = n + n3;
                stringArray[n2] = string13.substring(n, n23).trim();
            }
            oS400MessageDescription.setValidReplies(stringArray);
        }
        int n24 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)164);
        int n25 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)168);
        n2 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)176);
        n = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)180);
        if (n24 > 0 && n25 > 0) {
            String string14 = charConverter.byteArrayToString(byArray8, n24, n25);
            oS400MessageDescription.setLowerReplyRange(string14);
        }
        if (n2 > 0 && n > 0) {
            String string15 = charConverter.byteArrayToString(byArray8, n2, n);
            oS400MessageDescription.setUpperReplyRange(string15);
        }
        int n26 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)232);
        int n27 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)228);
        int n28 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)236);
        if (n27 > 0 && n28 > 0 && n26 > 0) {
            String[] stringArray = new String[n26];
            block12: for (int i = 0; i < n26; ++i) {
                int n29 = BinaryConverter.byteArrayToInt((byte[])byArray8, (int)(n27 + i * 4));
                switch (n29) {
                    case -1: {
                        stringArray[i] = "*JOBDMP";
                        continue block12;
                    }
                    case -2: {
                        stringArray[i] = "*JOBINT";
                        continue block12;
                    }
                    case -4: {
                        stringArray[i] = "*JOB";
                        continue block12;
                    }
                    default: {
                        stringArray[i] = Integer.toString(n29);
                    }
                }
            }
            oS400MessageDescription.setDumpEntries(stringArray);
        }
        this.releaseConnection(wrappedAS400);
        return oS400MessageDescription;
    }
}

