/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.schedule;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.access.SQLWhereClause;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.schedule.CommonScheduleJobListDM;
import com.helpsystems.common.core.schedule.CommonScheduleJobProxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CommonScheduleJobListJDBC
extends AbstractDatabaseManager
implements CommonScheduleJobListDM {
    private static final Logger logger = Logger.getLogger(CommonScheduleJobListJDBC.class);
    protected String libraryName;
    private static final String PROXY_FIELDS = " KYTIME, JOBNAM, PROGDS, JOBTYP, SCHOVR, RTADOID ";
    private static final SortField[] SORT_FIELDS = new SortField[]{new GenericSortField(10101, 0), new GenericSortField(333, 0), new GenericSortField(20202, 0)};

    public CommonScheduleJobListJDBC(String string, String string2, String string3) {
        super(string);
        this.setName(string3);
        this.libraryName = string2;
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        return this.getJobList(dataFilter, sortField);
    }

    public DataSet getJobList(DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        String string = "select  KYTIME, JOBNAM, PROGDS, JOBTYP, SCHOVR, RTADOID  from " + this.libraryName + ".RBTROB ";
        String string2 = "select count (*) from " + this.libraryName + ".RBTROB ";
        String string3 = " JOBTYP != 'F' and JOBTYP != 'S' ";
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        try {
            wrappedConnection = this.getConnection();
            String string4 = "";
            boolean bl = false;
            if (dataFilter != null && !dataFilter.isEmpty()) {
                bl = true;
                string4 = " where " + SQLWhereClause.getSQL(dataFilter, true) + " and " + string3;
            } else {
                string4 = " where " + string3;
            }
            String string5 = string2 + string4;
            logger.trace((Object)("Count String: " + string5));
            PreparedStatement preparedStatement = wrappedConnection.prepareStatement(string5);
            if (bl) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement, 1, dataFilter);
            }
            String string6 = string + string4 + this.getSortSQL(sortField);
            logger.trace((Object)("Query String: " + string6));
            PreparedStatement preparedStatement2 = wrappedConnection.prepareStatement(string6, 1004, 1007);
            if (bl) {
                SQLWhereClause.prepareSQLWhereClause(preparedStatement2, 1, dataFilter);
            }
            int n = -1;
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            resultSet = preparedStatement2.executeQuery();
            ScheduleJobProxyGenerator scheduleJobProxyGenerator = new ScheduleJobProxyGenerator();
            return ResultSetDataSet.createDataSet(resultSet, scheduleJobProxyGenerator, n);
        }
        catch (Exception exception) {
            CommonScheduleJobListJDBC.closeEm(wrappedConnection, null, null);
            String string7 = "Schedule Job list query failed.";
            throw new RuntimeException(string7, exception);
        }
    }

    public SortField[] getSortFields() {
        return SORT_FIELDS;
    }

    private String getSortSQL(SortField sortField) {
        String string = "order by JOBNAM";
        if (sortField == null) {
            return string;
        }
        String string2 = "";
        if (sortField.getDirection() == 1) {
            string2 = "desc ";
        }
        switch (sortField.getField()) {
            case 10101: {
                string = "order by JOBNAM " + string2;
                break;
            }
            case 20202: {
                string = "order by PROGDS " + string2 + ", JOBNAM ";
                break;
            }
            case 333: {
                string = "order by JOBTYP " + string2 + ", JOBNAM ";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Sort Order: " + sortField.getField());
            }
        }
        return string;
    }

    private class ScheduleJobProxyGenerator
    extends AbstractBusObjGenerator {
        ScheduleJobProxyGenerator() {
            super(5, CommonScheduleJobProxy.class.getName());
        }

        @Override
        protected Object constructObject() {
            return new CommonScheduleJobProxy();
        }

        @Override
        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException {
            CommonScheduleJobProxy commonScheduleJobProxy = (CommonScheduleJobProxy)object;
            switch (n) {
                case 1: {
                    commonScheduleJobProxy.setJobType(resultSet.getString("JOBTYP"));
                    break;
                }
                case 2: {
                    commonScheduleJobProxy.setName(resultSet.getString("JOBNAM"));
                    break;
                }
                case 3: {
                    commonScheduleJobProxy.setDescription(resultSet.getString("PROGDS"));
                    break;
                }
                case 4: {
                    commonScheduleJobProxy.setScheduleCode(resultSet.getString("SCHOVR"));
                    break;
                }
                case 5: {
                    commonScheduleJobProxy.setJobNumber(resultSet.getString("KYTIME"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass #" + n + " exceeds maximum.");
                }
            }
        }
    }
}

