/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.schedule;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.DefaultProxyGenerator;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.schedule.ReservedCommandVariableDM;
import com.helpsystems.common.core.util.MessageUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CommonReservedCommandVariableDMJdbc
extends AbstractDatabaseManager
implements ReservedCommandVariableDM {
    private String table = "RBTRV";
    private String qualifiedTable;
    private static final String objDesc = "Reserved Command Variable";
    private static Logger logger = Logger.getLogger(CommonReservedCommandVariableDMJdbc.class);
    private static ProductIID PIID_ZERO = new ProductIID(0);

    public CommonReservedCommandVariableDMJdbc(String string, String string2, String string3) {
        super(string);
        this.checkForNull("Library", string2);
        this.checkForNull("ManagerName", string3);
        this.qualifiedTable = string2 + "." + this.table;
        this.setName(string3);
    }

    public DataSet getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws ResourceUnavailableException {
        return this.getProxyList();
    }

    public DataSet getProxyList() throws ResourceUnavailableException {
        String string = "select rcv_name, description, prd_instance_id from " + this.getTable() + " " + "order by rcv_name asc";
        PreparedStatement preparedStatement = this.getPreparedStmtForScrollableList(string);
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the {0} Proxy list.", (Object[])new Object[]{objDesc});
            logger.debug((Object)string2, (Throwable)sQLException);
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        DefaultProxyGenerator defaultProxyGenerator = new DefaultProxyGenerator("Reserved Command Variable Proxy", "rcv_name", "description", "prd_instance_id");
        try {
            int n = -1;
            int n2 = 100;
            DataSet dataSet = ResultSetDataSet.createDataSet(resultSet, defaultProxyGenerator, n, n2);
            return dataSet;
        }
        catch (DataSetException dataSetException) {
            String string3 = "Data set error while retrieving the Reserved Command Variable Object Proxy list.";
            logger.debug((Object)string3, (Throwable)dataSetException);
            this.closeConnection(preparedStatement);
            throw new ResourceUnavailableException(string3, (Throwable)dataSetException);
        }
    }

    public boolean isInDatabase(String string) throws ResourceUnavailableException {
        ProductIID productIID = PIID_ZERO;
        this.checkForNull("Name", string);
        String string2 = "SELECT COUNT(*) FROM " + this.getTable() + " WHERE prd_instance_id=? AND rcv_name=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        return this.getCount(preparedStatement, productIID, string) > 0;
    }

    private int getCount(PreparedStatement preparedStatement, ProductIID productIID, Object object) throws ResourceUnavailableException {
        ResultSet resultSet = null;
        try {
            preparedStatement.setInt(1, productIID.getID());
            preparedStatement.setObject(2, object);
            int n = 0;
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n += resultSet.getInt(1);
            }
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            String string = "Error while executing the SQL statement in the getCount method.";
            logger.debug((Object)string, (Throwable)sQLException);
            throw new ResourceUnavailableException(string, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String getTable() {
        return this.qualifiedTable;
    }

    private void checkForNull(String string, Object object) {
        if (object == null) {
            throw new NullPointerException(string + " cannot be null.");
        }
    }
}

