/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.access.alert.RecipientJDBC;
import com.helpsystems.common.access.client.ClientJDBC;
import com.helpsystems.common.access.network.RuntimeNodeProxyDMJdbc;
import com.helpsystems.common.access.reports.ReportSetProxyDMJdbc;
import com.helpsystems.common.access.schedule.CommonCalendarObjectDMJdbc;
import com.helpsystems.common.access.schedule.CommonReservedCommandVariableDMJdbc;
import com.helpsystems.common.access.schedule.CommonScheduleJobListJDBC;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.AbstractManagerLoader;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.busobj.InstalledProducts;
import com.helpsystems.common.core.dm.EncodingManager;
import com.helpsystems.common.core.dm.RelModDM;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.util.RelMod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class CommonJDBCLoader
extends AbstractManagerLoader {
    private static final Logger logger = Logger.getLogger(CommonJDBCLoader.class);
    private String url;
    private String suffix;
    private ArrayList<String> jdbcManagerIDs = new ArrayList();
    private RelMod interfaceVersion;

    public CommonJDBCLoader(String string) {
        this(string, null);
    }

    public CommonJDBCLoader(String string, String string2) {
        if (string == null || string.trim().length() < 1) {
            throw new NullPointerException("The database URL passed in is null.");
        }
        this.url = string;
        this.suffix = string2;
    }

    public void loadAll() throws ResourceUnavailableException {
        InstalledProduct installedProduct;
        CharSequence charSequence;
        Object object;
        try {
            object = (RelModDM)ManagerRegistry.getManagerOrFail((String)"COMMON.RelModDM", (String)this.suffix);
            this.interfaceVersion = object.retrieveInterfaceVersion();
        }
        catch (NoDataException noDataException) {
            logger.debug((Object)noDataException);
            throw new ResourceUnavailableException("Unable to get Release/Modification data.", (Throwable)noDataException);
        }
        logger.trace((Object)"Loading all Common JDBC Data Managers.");
        object = new ArrayList();
        Exception exception = null;
        try {
            charSequence = InstalledProduct.getApplCode((int)2);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadAlertManagers(installedProduct.getLibraryName());
            }
        }
        catch (Exception exception2) {
            logger.debug((Object)"Unable to start up Common Alert managers", (Throwable)exception2);
            object.add("ALERT");
            exception = exception2;
        }
        try {
            charSequence = InstalledProduct.getApplCode((int)1);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadScheduleManagers(installedProduct.getLibraryName());
            }
        }
        catch (Exception exception3) {
            logger.debug((Object)"Unable to start up Common Schedule managers", (Throwable)exception3);
            object.add("SCHEDULE");
            exception = exception3;
        }
        try {
            charSequence = InstalledProduct.getApplCode((int)28);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadClientManagers(installedProduct.getLibraryName());
            }
        }
        catch (Exception exception4) {
            logger.debug((Object)"Unable to start up Common Client managers", (Throwable)exception4);
            object.add("CLIENT");
            exception = exception4;
        }
        try {
            charSequence = InstalledProduct.getApplCode((int)20);
            installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
            if (installedProduct != null && installedProduct.isInstalled()) {
                this.loadReportsManagers(installedProduct.getLibraryName());
            }
        }
        catch (Exception exception5) {
            logger.debug((Object)"Unable to start up Common Reports managers", (Throwable)exception5);
            object.add("REPORTS");
            exception = exception5;
        }
        if (this.getEnvironment() == 1) {
            try {
                charSequence = InstalledProduct.getApplCode((int)9);
                installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
                if (installedProduct != null && installedProduct.isInstalled()) {
                    this.loadNetworkManagers(installedProduct.getLibraryName());
                }
            }
            catch (Exception exception6) {
                logger.debug((Object)"Unable to start up Common Network managers", (Throwable)exception6);
                object.add("NETWORK");
                exception = exception6;
            }
        } else {
            try {
                charSequence = InstalledProduct.getApplCode((int)10);
                installedProduct = InstalledProducts.getInstance().getInstalledProduct((String)charSequence, (BasicIdentifier)ProductIID.DIRECT_CONNECT);
                if (installedProduct != null && installedProduct.isInstalled()) {
                    this.loadNetworkManagers(installedProduct.getLibraryName());
                }
            }
            catch (Exception exception7) {
                logger.debug((Object)"Unable to start up Common Network managers", (Throwable)exception7);
                object.add("NETWORK");
                exception = exception7;
            }
        }
        if (object.size() > 0) {
            charSequence = new StringBuffer("The following managers failed to start: ");
            boolean bl = true;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                if (!bl) {
                    ((StringBuffer)charSequence).append(", ");
                }
                ((StringBuffer)charSequence).append(iterator.next());
                bl = false;
            }
            throw new ResourceUnavailableException(((StringBuffer)charSequence).toString(), (Throwable)exception);
        }
    }

    private void loadAlertManagers(String string) {
        EncodingManager encodingManager = (EncodingManager)ManagerRegistry.getManager((String)"COMMON.EncodingManager", (String)"ALERT");
        String string2 = "COMMON.RecipientDM";
        RecipientJDBC recipientJDBC = new RecipientJDBC(this.url, string, string2);
        recipientJDBC.setEncodingManager(encodingManager);
        this.registerManager(recipientJDBC);
        logger.trace((Object)("  Loaded Alert Common JDBC data manager: " + recipientJDBC.getName()));
    }

    private void loadScheduleManagers(String string) {
        EncodingManager encodingManager = (EncodingManager)ManagerRegistry.getManager((String)"COMMON.EncodingManager", (String)"SCHEDULE");
        String string2 = "COMMON.CommonScheduleJobListDM";
        AbstractDatabaseManager abstractDatabaseManager = new CommonScheduleJobListJDBC(this.url, string, string2);
        abstractDatabaseManager.setEncodingManager(encodingManager);
        this.registerManager(abstractDatabaseManager);
        logger.trace((Object)("  Loaded Schedule Common JDBC data manager: " + abstractDatabaseManager.getName()));
        string2 = "COMMON.CommonCalendarDM";
        abstractDatabaseManager = new CommonCalendarObjectDMJdbc(this.url, string, string2);
        this.registerManager(abstractDatabaseManager);
        logger.trace((Object)("  Loaded Calendar Common JDBC data manager: " + abstractDatabaseManager.getName()));
        string2 = "COMMON.ReservedCommandVariableDM";
        abstractDatabaseManager = new CommonReservedCommandVariableDMJdbc(this.url, string, string2);
        this.registerManager(abstractDatabaseManager);
        logger.trace((Object)("  Loaded Reserved Command Variable Common JDBC data manager: " + abstractDatabaseManager.getName()));
    }

    private void loadClientManagers(String string) {
        String string2 = "COMMON.ClientDM";
        ClientJDBC clientJDBC = new ClientJDBC(this.url, string, string2);
        this.registerManager(clientJDBC);
        logger.trace((Object)("  Loaded Client Common JDBC data manager: " + clientJDBC.getName()));
    }

    private void loadReportsManagers(String string) throws IOException {
        SQLManagerHelper sQLManagerHelper = new SQLManagerHelper("com/helpsystems/common/access/reports/dbmap.xml", true, ((Object)((Object)this)).getClass().getClassLoader());
        String string2 = "COMMON.ReportSetProxyDM";
        ReportSetProxyDMJdbc reportSetProxyDMJdbc = new ReportSetProxyDMJdbc(this.url, string, string2, sQLManagerHelper);
        this.registerManager(reportSetProxyDMJdbc);
        logger.trace((Object)("  Loaded Reports Common JDBC data manager: " + reportSetProxyDMJdbc.getName()));
    }

    private void loadNetworkManagers(String string) throws IOException, ResourceUnavailableException {
        String string2 = "NETWORK.RuntimeNodeProxyDM";
        try {
            RuntimeNodeProxyDMJdbc runtimeNodeProxyDMJdbc = new RuntimeNodeProxyDMJdbc(this.url, string, string2);
            this.registerManager(runtimeNodeProxyDMJdbc);
            logger.trace((Object)("  Loaded Network Node Common JDBC data manager: " + runtimeNodeProxyDMJdbc.getName()));
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to load Network Node Common JDBC data manager", (Throwable)exception);
        }
    }

    private void registerManager(AbstractManager abstractManager) {
        String string;
        abstractManager.setInterfaceVersion(this.interfaceVersion);
        if (this.suffix != null && this.suffix.length() > 0 && !(string = abstractManager.getName()).endsWith(this.suffix)) {
            abstractManager.setName(string + "." + this.suffix);
        }
        ManagerRegistry.registerManager((IAbstractManager)abstractManager);
        this.jdbcManagerIDs.add(abstractManager.getName());
    }

    public void unloadAll() throws ResourceUnavailableException {
        if (this.jdbcManagerIDs.size() < 1) {
            logger.trace((Object)"No common JDBC Data Managers exist to unload.");
        } else {
            logger.trace((Object)"Unloading JDBC Data Mangers.");
        }
        for (int i = 0; i < this.jdbcManagerIDs.size(); ++i) {
            String string = this.jdbcManagerIDs.get(i);
            IAbstractManager iAbstractManager = ManagerRegistry.removeManager((String)string);
            if (iAbstractManager == null) {
                logger.debug((Object)("  ** Failed removing manger: " + string + " **"));
                continue;
            }
            logger.trace((Object)("  Common JDBC Manager was removed: " + string));
        }
    }
}

