/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.SQLManagerHelper;
import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.TooManyUpdatedException;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class AbstractHelpingDatabaseManager
extends AbstractDatabaseManager {
    protected SQLManagerHelper sqlHelper;
    protected String library;

    public AbstractHelpingDatabaseManager(String string, String string2, SQLManagerHelper sQLManagerHelper) {
        super(string);
        this.library = string2;
        this.sqlHelper = sQLManagerHelper;
    }

    protected String qualifyLibrary() {
        if (this.library == null || this.library.length() == 0) {
            return "";
        }
        return this.library + ".";
    }

    protected int delete(Object object) throws ResourceUnavailableException, DataException {
        return this.delete(null, object);
    }

    protected int delete(Connection connection, Object object) throws ResourceUnavailableException, DataException {
        if (object == null) {
            throw new NullPointerException("The business object passed in is null.");
        }
        Connection connection2 = null;
        try {
            connection2 = connection == null ? this.getConnection() : connection;
            if (connection2 == null) {
                throw new NullPointerException("Unable to get a connection.");
            }
            int n = this.sqlHelper.deleteObject(connection2, object, this.library);
            return n;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to delete the record from the database.", (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
        }
    }

    protected Object get(Object object) throws ResourceUnavailableException, DataException {
        return this.get(null, object);
    }

    protected Object get(Connection connection, Object object) throws ResourceUnavailableException, DataException {
        if (object == null) {
            throw new NullPointerException("The business object passed in is null.");
        }
        Connection connection2 = null;
        try {
            connection2 = connection == null ? this.getConnection() : connection;
            if (connection2 == null) {
                throw new NullPointerException("Unable to get a connection.");
            }
            Object object2 = this.sqlHelper.fetchAndFill(connection2, object, this.library);
            return object2;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to retrieve the requested object.", (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
        }
    }

    protected void insert(Connection connection, Object object) throws SQLException, DataException {
        this.sqlHelper.insertObject(object, this.library, connection, false);
    }

    protected Object save(Object object) throws ResourceUnavailableException, DataException {
        return this.save(null, object);
    }

    protected Object save(Connection connection, Object object) throws ResourceUnavailableException, DataException {
        Connection connection2 = null;
        String string = "save";
        try {
            connection2 = connection == null ? this.getConnection() : connection;
            if (connection2 == null) {
                throw new NullPointerException("Unable to get a connection.");
            }
            int n = this.sqlHelper.countObject(connection2, object, this.library);
            if (n == 0) {
                string = "insert";
                this.insert(connection2, object);
            }
            if (n == 1) {
                string = "update";
                this.update(connection2, object);
            }
            if (n >= 2) {
                throw new TooManyUpdatedException("Cannot save the object because there are already " + n + " matching records present.");
            }
            Object object2 = object;
            return object2;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to " + string + " the record.", (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
        }
    }

    protected Object[] search(Object object, HashMap<String, Serializable> hashMap) throws ResourceUnavailableException, DataException {
        return this.search(null, object, hashMap);
    }

    protected Object[] search(Object object, Properties properties) throws ResourceUnavailableException, DataException {
        return this.search(null, object, properties);
    }

    protected Object[] search(Connection connection, Object object, Properties properties) throws ResourceUnavailableException, DataException {
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            hashMap.put((String)entry.getKey(), (Serializable)((Object)((String)entry.getValue())));
        }
        return this.search(connection, object, hashMap);
    }

    protected Object[] search(Connection connection, Object object, HashMap<String, Serializable> hashMap) throws ResourceUnavailableException, DataException {
        if (object == null) {
            throw new NullPointerException("The business object passed in is null.");
        }
        Connection connection2 = null;
        try {
            if (connection == null) {
                connection2 = this.getConnection();
                if (connection2 == null) {
                    throw new NullPointerException("Unable to get a connection.");
                }
            } else {
                connection2 = connection;
            }
            Object[] objectArray = this.sqlHelper.search(connection2, object, hashMap, this.library);
            return objectArray;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException("Unable to retrieve the requested objects.", (Throwable)sQLException);
        }
        finally {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
        }
    }

    protected void update(Connection connection, Object object) throws SQLException, DataException {
        this.sqlHelper.updateObject(connection, object, this.library);
    }

    protected DataSet getDataSet(Object object, DataFilter dataFilter, SortField sortField) throws SQLException, DataSetException {
        return this.getDataSet(object, dataFilter, sortField, false, -1);
    }

    protected DataSet getReloadableDataSet(Object object, DataFilter dataFilter, SortField sortField) throws SQLException, DataSetException {
        return this.getDataSet(object, dataFilter, sortField, true, -1);
    }

    protected DataSet getDataSet(Object object, DataFilter dataFilter, SortField sortField, boolean bl, int n) throws SQLException, DataSetException {
        return this.getDataSet(null, object, dataFilter, sortField, bl, n);
    }

    protected DataSet getDataSet(Connection connection, Object object, DataFilter dataFilter, SortField sortField, boolean bl, int n) throws SQLException, DataSetException {
        Connection connection2 = connection;
        try {
            if (connection2 == null) {
                connection2 = this.getConnectionOrFail();
            }
            return this.sqlHelper.getDataSet(connection2, object, dataFilter, sortField, this.library, bl, 200, n, true, 1004);
        }
        catch (SQLException sQLException) {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
            throw sQLException;
        }
        catch (DataSetException dataSetException) {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
            throw dataSetException;
        }
        catch (Exception exception) {
            if (connection == null) {
                AbstractHelpingDatabaseManager.closeEm(connection2, null, null);
            }
            throw new DataSetException("Unable to create a DataSet.", (Throwable)exception);
        }
    }
}

