/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl.busobj;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.RelMod;

public class DataManagerEntry
extends CommonVersionedObject {
    private static final long serialVersionUID = -5201599764471878131L;
    protected String name;
    protected String className;
    protected String interfaceName;
    private RelMod managerVersion;
    private RelMod interfaceVersion;

    public DataManagerEntry() {
    }

    public DataManagerEntry(IAbstractManager iAbstractManager) {
        this.readManagerInfo(iAbstractManager);
    }

    public DataManagerEntry(String string, String string2, String string3) {
        this.setName(string);
        this.setClassName(string2);
        this.setInterfaceName(string3);
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public RelMod getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public RelMod getManagerVersion() {
        return this.managerVersion;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    protected void readManagerInfo(IAbstractManager iAbstractManager) {
        if (iAbstractManager == null) {
            throw new NullPointerException("The manager passed in is null.");
        }
        this.setName(iAbstractManager.getName());
        if (iAbstractManager instanceof AbstractManager) {
            this.setClassName(iAbstractManager.getClass().getName());
        }
        Class<?> clazz = iAbstractManager.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            String string = classArray[i].getName();
            if (string.endsWith("IAbstractManager") || string.equals("java.lang.Runnable")) continue;
            this.interfaceName = string;
        }
        this.managerVersion = iAbstractManager.getManagerVersion();
        this.interfaceVersion = iAbstractManager.getInterfaceVersion();
    }

    public String toString() {
        return this.name + "= " + this.interfaceName + "[ " + this.className + "]";
    }
}

