/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.util.MorphClassLoader;
import com.helpsystems.common.core.util.RunnableThrottle;
import com.helpsystems.common.core.util.RunnableThrottleObject;
import com.helpsystems.common.core.util.RunnableThrottleRunner;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.DebugMarker;
import com.helpsystems.common.tl.DebugRunnerMarker;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.IPeer;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.PeerProtocolRunner;
import com.helpsystems.common.tl.PeerStats;
import com.helpsystems.common.tl.PeerStatsHelper;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.EnvelopeRefusedException;
import com.helpsystems.common.tl.ex.EnvelopeVerificationException;
import com.helpsystems.common.tl.ex.PeerDisconnectedException;
import com.helpsystems.common.tl.ex.UndeliverableEnvelopeException;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.DataManagerCommand;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class PeerRunner
extends Thread
implements IPeer {
    private static final RunnableThrottleRunner jcRunnableThrottleRunner = new PeerThrottleRunner();
    private static final RunnableThrottle jcRunnableThrottle = new RunnableThrottle(15, "JobCompleted", "peer.jobcompleted", jcRunnableThrottleRunner);
    private static final RunnableThrottleRunner gjhRunnableThrottleRunner = new PeerThrottleRunner();
    private static final RunnableThrottle gjhRunnableThrottle = new RunnableThrottle(15, "GetJobHist", "peer.getjobhist", gjhRunnableThrottleRunner);
    private static final RunnableThrottleRunner hjRunnableThrottleRunner = new PeerThrottleRunner();
    private static final RunnableThrottle hjRunnableThrottle = new RunnableThrottle(15, "HasJob", "peer.hasjob", hjRunnableThrottleRunner);
    private static final RunnableThrottleRunner mjarRunnableThrottleRunner = new PeerThrottleRunner();
    private static final RunnableThrottle mjarRunnableThrottle = new RunnableThrottle(15, "MarkJobAsRunning", "peer.markjobasrunning", mjarRunnableThrottleRunner);
    private static final RunnableThrottleRunner lodRunnableThrottleRunner = new PeerThrottleRunner();
    private static final RunnableThrottle lodRunnableThrottle = new RunnableThrottle(15, "LoadOutputDistribution", "peer.loadoutputdist", lodRunnableThrottleRunner);
    protected static final String ENVELOPE_RECEIVED_OK = "ok";
    protected static final int ENVELOPE_ACCEPTED = 1;
    protected static final int ENVELOPE_FORWARDING = 2;
    private static final Logger logger = Logger.getLogger(PeerRunner.class);
    protected Peer parentPeer;
    protected PeerID ourPeerID;
    protected String who;
    protected Hashtable<Object, Object> waitTable;
    private PeerStats peerStats;
    private static final String MARKER_CLASS_NAME = DebugRunnerMarker.class.getName();
    private static MorphClassLoader morphClassLoader;
    private ThreadLocal threadMarker;
    private PeerID theirPeerID;

    PeerRunner(Peer peer, String string) {
        this.initPeerRunner(peer, string);
    }

    PeerRunner(Peer peer, String string, long l) {
        super(null, null, "PeerRunner", l);
        this.initPeerRunner(peer, string);
    }

    private void initPeerRunner(Peer peer, String string) {
        ValidationHelper.checkForNull((String)"Parent peer", (Object)peer);
        this.parentPeer = peer;
        this.ourPeerID = peer.getRemotePeerID();
        this.waitTable = new Hashtable();
        this.peerStats = new PeerStats();
        this.who = string;
        this.threadMarker = new ThreadMarker();
    }

    @Override
    public void close() {
        this.notifyWaitingThreads();
    }

    @Override
    public PeerID getPeerID() {
        return this.theirPeerID;
    }

    void setPeerID(PeerID peerID) {
        this.theirPeerID = peerID;
        PeerStatsHelper.setRemotePeerID(this.peerStats, peerID);
        PeerStatsHelper.setWhenConnectionEstablished(this.peerStats, System.currentTimeMillis());
    }

    @Override
    public PeerStats getStats() {
        return this.peerStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int handleEnvelope(Envelope envelope) throws EnvelopeException {
        Object object;
        Object object2;
        PeerID[] peerIDArray;
        if (logger.isTraceEnabled()) {
            peerIDArray = (MarkerInfo)this.threadMarker.get();
            object2 = null;
            if (!peerIDArray.markedReceive) {
                object = " received " + envelope.getPayloadClassname() + " from " + this.buildSourceString(envelope.getSource().getPeerDescriptor(), envelope.getRoute());
                object2 = this.buildMarker((String)object);
                try {
                    peerIDArray.markedReceive = true;
                    if (object2 != null) {
                        int n = object2.handleEnvelope(this, envelope);
                        return n;
                    }
                }
                finally {
                    peerIDArray.markedReceive = false;
                }
            }
        }
        peerIDArray = this.peerStats;
        synchronized (peerIDArray) {
            PeerStatsHelper.incrementEnvelopeRXCount(this.peerStats);
            PeerStatsHelper.setQueueBacklog(this.peerStats, PeerStatsHelper.getQueueBacklog(this.peerStats) + 1);
        }
        try {
            int n;
            peerIDArray = envelope.getRoute();
            if (peerIDArray == null || peerIDArray.length == 0) {
                throw new EnvelopeVerificationException("The envelope's source could not be validated because the route is null/empty.", envelope);
            }
            object2 = peerIDArray[peerIDArray.length - 1];
            if (!((PeerID)object2).equals(this.getPeerID())) {
                throw new EnvelopeVerificationException("Unable to verify the envelope's sender.", envelope);
            }
            object = this.parentPeer.getPeerFromRoutingTable((PeerID)object2);
            if (object == null) {
                throw new EnvelopeRefusedException("A trusted connection has not been established.", envelope);
            }
            PeerID peerID = envelope.getDestination();
            if (peerID == null) {
                throw new EnvelopeRefusedException("The envelope's destination is missing.", envelope);
            }
            if (!peerID.equals(this.ourPeerID)) {
                int n2 = this.forwardEnvelope(envelope);
                return n2;
            }
            if (this.isWaitingForEnvelope(envelope)) {
                int n3 = 1;
                return n3;
            }
            IPeer[] iPeerArray = this.parentPeer.getPeerReferences();
            for (n = 0; n < iPeerArray.length; ++n) {
                if (!iPeerArray[n].isWaitingForEnvelope(envelope)) continue;
                int n4 = 1;
                return n4;
            }
            this.preprocessEnvelope(envelope);
            n = 1;
            return n;
        }
        catch (EnvelopeException envelopeException) {
            throw envelopeException;
        }
        catch (Throwable throwable) {
            throw new EnvelopeRefusedException("The peer " + this.ourPeerID + " was unable to enqueue the envelope " + envelope.getArbitraryID(), envelope, throwable);
        }
        finally {
            PeerStats peerStats = this.peerStats;
            synchronized (peerStats) {
                PeerStatsHelper.setQueueBacklog(this.peerStats, PeerStatsHelper.getQueueBacklog(this.peerStats) - 1);
            }
        }
    }

    private void preprocessEnvelope(Envelope envelope) {
        EnvelopeRoute envelopeRoute = EnvelopeRoute.DEFAULT;
        try {
            DataManagerCommand dataManagerCommand;
            String string;
            Processable processable = null;
            processable = envelope.getPayloadState() == 16 ? this.parentPeer.deserializeEnvelope(envelope) : envelope.getPayload();
            if (processable != null && processable instanceof DataManagerCommand && (string = (dataManagerCommand = (DataManagerCommand)processable).getDataManagerName()) != null && string.startsWith("ENTERPRISE.")) {
                String string2 = dataManagerCommand.getMethodName();
                String string3 = "";
                String string4 = "";
                Class[] classArray = dataManagerCommand.getParameterTypes();
                if (classArray != null) {
                    for (int i = 0; i < classArray.length; ++i) {
                        string3 = string3 + string4 + classArray[i].getName();
                        string4 = " ";
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("preprocessEnvelope: " + envelope.getArbitraryID() + " DataManagerCommand: " + string + "." + string2 + "(" + string3 + ")"));
                }
                if ("ENTERPRISE.JobCompletionDM".equalsIgnoreCase(string) && "jobCompleted".equalsIgnoreCase(string2) && "com.helpsystems.enterprise.core.exec.JobCompletionInfo".equalsIgnoreCase(string3)) {
                    envelopeRoute = EnvelopeRoute.JOB_COMPLETED;
                } else if ("ENTERPRISE.JobMarkRunningAM".equalsIgnoreCase(string) && "getJobHistory".equalsIgnoreCase(string2) && "long".equalsIgnoreCase(string3)) {
                    envelopeRoute = EnvelopeRoute.GET_JOB_HISTORY;
                } else if ("ENTERPRISE.JobCompletionDM".equalsIgnoreCase(string) && "hasJob".equalsIgnoreCase(string2) && "java.lang.String".equalsIgnoreCase(string3)) {
                    envelopeRoute = EnvelopeRoute.HAS_JOB;
                } else if ("ENTERPRISE.JobMarkRunningAM".equalsIgnoreCase(string) && "markJobAsRunning".equalsIgnoreCase(string2) && "com.helpsystems.enterprise.core.exec.ExecutableJob".equalsIgnoreCase(string3)) {
                    envelopeRoute = EnvelopeRoute.MARK_JOB_AS_RUNNING;
                } else if ("ENTERPRISE.OutputDistributiontDM".equalsIgnoreCase(string) && "getByJobId".equalsIgnoreCase(string2) && "long".equalsIgnoreCase(string3)) {
                    envelopeRoute = EnvelopeRoute.LOAD_OUTPUT_DIST;
                }
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Error pre-processing envelope.", (Throwable)exception);
        }
        switch (envelopeRoute) {
            case JOB_COMPLETED: {
                this.queueJobCompletedEnvelope(envelope);
                break;
            }
            case GET_JOB_HISTORY: {
                this.queueGetJobHistoryEnvelope(envelope);
                break;
            }
            case HAS_JOB: {
                this.queueHasJobEnvelope(envelope);
                break;
            }
            case MARK_JOB_AS_RUNNING: {
                this.queueMarkJobAsRunningEnvelope(envelope);
                break;
            }
            case LOAD_OUTPUT_DIST: {
                this.queueLoadOutputDistEnvelope(envelope);
                break;
            }
            default: {
                this.immediatelyRunEnvelope(envelope, null);
            }
        }
    }

    protected void immediatelyRunEnvelope(Envelope envelope, RunnableThrottle runnableThrottle) {
        Thread thread = null;
        long l = SkybotStackSize.getStackSize();
        ImmediateRunner immediateRunner = new ImmediateRunner(envelope, runnableThrottle);
        thread = l != 0L ? new Thread(null, immediateRunner, "ImmediateRunner", l) : new Thread(immediateRunner);
        thread.start();
    }

    private void queueJobCompletedEnvelope(Envelope envelope) {
        jcRunnableThrottle.queue(new RunnableThrottleObject(envelope.getArbitraryID(), (Object)new PeerEnvelopeRequest(this, envelope)));
    }

    private void queueGetJobHistoryEnvelope(Envelope envelope) {
        gjhRunnableThrottle.queue(new RunnableThrottleObject(envelope.getArbitraryID(), (Object)new PeerEnvelopeRequest(this, envelope)));
    }

    private void queueHasJobEnvelope(Envelope envelope) {
        hjRunnableThrottle.queue(new RunnableThrottleObject(envelope.getArbitraryID(), (Object)new PeerEnvelopeRequest(this, envelope)));
    }

    private void queueMarkJobAsRunningEnvelope(Envelope envelope) {
        mjarRunnableThrottle.queue(new RunnableThrottleObject(envelope.getArbitraryID(), (Object)new PeerEnvelopeRequest(this, envelope)));
    }

    private void queueLoadOutputDistEnvelope(Envelope envelope) {
        lodRunnableThrottle.queue(new RunnableThrottleObject(envelope.getArbitraryID(), (Object)new PeerEnvelopeRequest(this, envelope)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isWaitingForEnvelope(Envelope envelope) {
        boolean bl = false;
        String string = envelope.getResponseToEnvelopeID();
        if (string != null) {
            Hashtable<Object, Object> hashtable = this.waitTable;
            synchronized (hashtable) {
                LockObject lockObject = (LockObject)this.waitTable.get(string);
                if (lockObject != null) {
                    this.waitTable.put(string, (Object)envelope);
                    bl = true;
                    LockObject lockObject2 = lockObject;
                    synchronized (lockObject2) {
                        lockObject.notify();
                    }
                }
            }
        }
        return bl;
    }

    protected int forwardEnvelope(Envelope envelope) throws EnvelopeException {
        this.parentPeer.forwardEnvelope(envelope);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingThreads() {
        Object object;
        Object object2;
        ArrayList<LockObject> arrayList = new ArrayList<LockObject>();
        Object object3 = this.waitTable;
        synchronized (object3) {
            object2 = this.waitTable.values().iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof LockObject)) continue;
                LockObject lockObject = (LockObject)object;
                PeerDescriptor peerDescriptor = lockObject.getDestination().getPeerDescriptor();
                logger.trace((Object)("A thread is waiting for a response from peer " + peerDescriptor + ", but that peer is unreachable."));
                PeerDisconnectedException peerDisconnectedException = new PeerDisconnectedException("The peer " + peerDescriptor + " is no longer available.", null);
                this.waitTable.put(lockObject.getEnvelopeID(), peerDisconnectedException);
                arrayList.add(lockObject);
            }
        }
        object3 = arrayList.iterator();
        while (object3.hasNext()) {
            object = object2 = (LockObject)object3.next();
            synchronized (object) {
                object2.notifyAll();
            }
        }
    }

    protected abstract Serializable sendAndReceiveEnvelope(Envelope var1) throws EnvelopeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Envelope sendEnvelopeAndWait(Envelope envelope, int n) throws EnvelopeException {
        Object object;
        Serializable serializable;
        block35: {
            Object object2;
            block33: {
                Hashtable<Object, Object> hashtable;
                block34: {
                    Envelope envelope2;
                    Object object3;
                    if (logger.isTraceEnabled()) {
                        object3 = (MarkerInfo)this.threadMarker.get();
                        object2 = null;
                        if (!((MarkerInfo)object3).markedSend) {
                            hashtable = envelope.getPayloadClassname() + " to " + this.buildSourceString(envelope.getDestination().getPeerDescriptor(), null);
                            object2 = this.buildMarker((String)((Object)hashtable));
                            try {
                                ((MarkerInfo)object3).markedSend = true;
                                if (object2 != null) {
                                    Envelope envelope3 = object2.sendEnvelopeAndWait(this, envelope, n);
                                    return envelope3;
                                }
                            }
                            finally {
                                ((MarkerInfo)object3).markedSend = false;
                            }
                        }
                    }
                    object3 = Thread.currentThread();
                    object2 = this.peerStats;
                    // MONITORENTER : object2
                    PeerStatsHelper.incrementEnvelopeTXCount(this.peerStats);
                    // MONITOREXIT : object2
                    envelope.appendToRoute(this.ourPeerID);
                    object2 = envelope.getArbitraryID();
                    hashtable = null;
                    if (n != 0) {
                        if (object3 instanceof PeerProtocolRunner) {
                            throw new IllegalStateException("Can't use a peer runner to send-and-wait an envelope.");
                        }
                        hashtable = new LockObject(envelope.getDestination(), (String)object2);
                        serializable = this.waitTable;
                        // MONITORENTER : serializable
                        this.waitTable.put(object2, hashtable);
                        // MONITOREXIT : serializable
                    } else {
                        hashtable = new LockObject();
                    }
                    serializable = null;
                    try {
                        object = hashtable;
                        // MONITORENTER : object
                        serializable = this.sendAndReceiveEnvelope(envelope);
                        if (!ENVELOPE_RECEIVED_OK.equals(serializable)) break block33;
                        if (n != 0) break block34;
                        envelope2 = null;
                        // MONITOREXIT : object
                        Hashtable<Object, Object> hashtable2 = this.waitTable;
                    }
                    catch (Throwable throwable) {
                        Hashtable<Object, Object> hashtable3 = this.waitTable;
                        // MONITORENTER : hashtable3
                        this.waitTable.remove(object2);
                        // MONITOREXIT : hashtable3
                        throw throwable;
                    }
                    this.waitTable.remove(object2);
                    // MONITOREXIT : hashtable2
                    return envelope2;
                }
                Envelope envelope4 = this.waitForEnvelope(envelope, (LockObject)((Object)hashtable), n);
                // MONITOREXIT : object
                Hashtable<Object, Object> hashtable4 = this.waitTable;
                // MONITORENTER : hashtable4
                this.waitTable.remove(object2);
                // MONITOREXIT : hashtable4
                return envelope4;
            }
            object = this.waitTable;
            // MONITORENTER : object
            this.waitTable.remove(object2);
            // MONITOREXIT : object
            if (!(serializable instanceof UndeliverableEnvelopeException)) break block35;
            object = (Exception)serializable;
            throw new UndeliverableEnvelopeException(((Throwable)object).getMessage(), envelope, (Throwable)object);
        }
        if (serializable instanceof Throwable) {
            throw new UndeliverableEnvelopeException("The remote peer could not receive the envelope.", envelope, (Throwable)serializable);
        }
        if (logger.isDebugEnabled()) {
            object = null;
            if (serializable != null) {
                object = serializable.getClass().getName();
            }
            logger.debug((Object)("Sent envelope " + envelope.getArbitraryID() + " to peer " + envelope.getDestination().getPeerDescriptor() + " and it replied with " + (String)object + " : " + serializable));
        }
        if (serializable == null) {
            throw new UndeliverableEnvelopeException("Envelope delivery failed.  Reply was null.", envelope);
        }
        object = "Envelope delivery failed: (" + serializable.getClass().getName() + ") " + serializable.toString();
        throw new UndeliverableEnvelopeException((String)object, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Envelope waitForEnvelope(Envelope envelope, LockObject lockObject, int n) throws EnvelopeException {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        String string2 = envelope.getArbitraryID();
        PeerRunner.currentThread().setName("Waiting for a response to " + string2 + " from peer " + envelope.getDestination().getPeerDescriptor());
        try {
            lockObject.doWait(n);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            thread.setName(string);
        }
        Object object = null;
        Object object2 = this.waitTable;
        synchronized (object2) {
            object = this.waitTable.remove(string2);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof LockObject) {
            return null;
        }
        if (object instanceof Throwable) {
            object2 = (Throwable)object;
            EnvelopeException envelopeException = null;
            if (object2 instanceof PeerDisconnectedException) {
                envelopeException = (PeerDisconnectedException)object2;
            } else if (object2 instanceof EnvelopeException) {
                EnvelopeException envelopeException2 = (EnvelopeException)object2;
                envelopeException = envelopeException2.createLocalException();
            } else {
                envelopeException = new EnvelopeException("Error occurred while the remote peer was processing the envelope.", envelope, (Throwable)object2);
            }
            throw envelopeException;
        }
        if (object instanceof Envelope) {
            object2 = (Envelope)((Object)object);
            if (((Envelope)((Object)object2)).getPayloadState() == 16) {
                try {
                    ((Envelope)((Object)object2)).setPayload(this.parentPeer.deserializeEnvelope((Envelope)((Object)object2)));
                }
                catch (Exception exception) {
                    logger.warn((Object)("Cannot deserialize envolope payload " + ((Envelope)((Object)object2)).getPayloadClassname()), (Throwable)exception);
                }
            }
            return object2;
        }
        throw new EnvelopeException("The remote peer returned an object type " + object.getClass().getName() + ", but we were expecting an envelope.", envelope);
    }

    DebugMarker buildMarker(String string) {
        if (morphClassLoader != null) {
            try {
                Class clazz = morphClassLoader.buildClass(string);
                DebugMarker debugMarker = (DebugMarker)clazz.newInstance();
                return debugMarker;
            }
            catch (Throwable throwable) {
                logger.debug((Object)"Problem with stack-trace marking, disabling further use.", throwable);
                morphClassLoader = null;
            }
        }
        return null;
    }

    String buildSourceString(PeerDescriptor peerDescriptor, PeerID[] peerIDArray) {
        String string = peerDescriptor.toString();
        if (peerDescriptor.getType() == 3) {
            string = peerDescriptor.findPrintableAddress() + ":" + peerDescriptor.getPort();
        }
        if (peerIDArray != null && peerIDArray.length > 1) {
            string = string + " via " + peerIDArray[peerIDArray.length - 1].toString();
        }
        return string;
    }

    static {
        try {
            morphClassLoader = new MorphClassLoader(MARKER_CLASS_NAME);
        }
        catch (IOException iOException) {
            logger.debug((Object)"Unable to use stack-trace marker.", (Throwable)iOException);
        }
        Thread thread = new Thread((Runnable)jcRunnableThrottle);
        thread.start();
        Thread thread2 = new Thread((Runnable)gjhRunnableThrottle);
        thread2.start();
        Thread thread3 = new Thread((Runnable)hjRunnableThrottle);
        thread3.start();
        Thread thread4 = new Thread((Runnable)mjarRunnableThrottle);
        thread4.start();
        Thread thread5 = new Thread((Runnable)lodRunnableThrottle);
        thread5.start();
    }

    class ThreadMarker
    extends ThreadLocal {
        ThreadMarker() {
        }

        public Object initialValue() {
            return new MarkerInfo();
        }
    }

    class MarkerInfo {
        boolean markedSend;
        boolean markedReceive;
        boolean markedRun;

        MarkerInfo() {
        }
    }

    class LockObject {
        private boolean isSomeoneWaiting;
        private PeerID destination;
        private String envelopeID;

        public LockObject() {
        }

        public LockObject(PeerID peerID, String string) {
            this.destination = peerID;
            this.envelopeID = string;
        }

        public PeerID getDestination() {
            return this.destination;
        }

        public String getEnvelopeID() {
            return this.envelopeID;
        }

        public void doWait(int n) throws InterruptedException {
            this.isSomeoneWaiting = true;
            if (n > 0) {
                this.wait(n);
            } else {
                this.wait();
            }
        }

        public boolean isSomeoneWaiting() {
            return this.isSomeoneWaiting;
        }
    }

    class ImmediateRunner
    implements Runnable {
        Envelope envelope;
        RunnableThrottle throttle = null;

        ImmediateRunner(Envelope envelope, RunnableThrottle runnableThrottle) {
            this.envelope = envelope;
            this.throttle = runnableThrottle;
        }

        @Override
        public final void run() {
            try {
                this.runImmediateRunner();
            }
            catch (Exception exception) {
                logger.warn((Object)"Error processing envelope.", (Throwable)exception);
            }
            finally {
                if (this.throttle != null) {
                    this.throttle.releaseSemaphore();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImmediateRunner() {
            Object object;
            String string = "Immediately servicing " + this.envelope.getPayloadClassname() + " from " + PeerRunner.this.buildSourceString(this.envelope.getSource().getPeerDescriptor(), this.envelope.getRoute());
            Thread thread = Thread.currentThread();
            thread.setName(string);
            if (this.envelope.getPriority() < 0 || this.envelope.getSource().getPeerDescriptor().getType() == 3) {
                thread.setPriority(10);
            }
            if (logger.isTraceEnabled()) {
                MarkerInfo markerInfo = (MarkerInfo)PeerRunner.this.threadMarker.get();
                object = null;
                if (!markerInfo.markedRun) {
                    object = PeerRunner.this.buildMarker(string);
                    try {
                        markerInfo.markedRun = true;
                        if (object != null) {
                            object.run(this);
                            return;
                        }
                    }
                    finally {
                        markerInfo.markedRun = false;
                    }
                }
            }
            try {
                PeerRunner.this.parentPeer.processEnvelope(this.envelope);
            }
            catch (Exception exception) {
                object = "An exception was thrown when processing envelope (" + this.envelope.toVerboseString() + "): " + exception.getMessage();
                logger.info(object);
                if (logger.isDebugEnabled()) {
                    logger.debug(object, (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                logger.warn((Object)("An error was thrown when processing envelope (" + this.envelope.toVerboseString() + ")."), throwable);
            }
        }
    }

    protected static class PeerThrottleRunner
    implements RunnableThrottleRunner {
        protected PeerThrottleRunner() {
        }

        public void startThread(RunnableThrottleObject runnableThrottleObject, RunnableThrottle runnableThrottle) {
            PeerEnvelopeRequest peerEnvelopeRequest = (PeerEnvelopeRequest)runnableThrottleObject.getRequest();
            peerEnvelopeRequest.peerRunner.immediatelyRunEnvelope(peerEnvelopeRequest.envelope, runnableThrottle);
        }
    }

    private class PeerEnvelopeRequest {
        PeerRunner peerRunner;
        Envelope envelope;

        public PeerEnvelopeRequest(PeerRunner peerRunner2, Envelope envelope) {
            this.peerRunner = peerRunner2;
            this.envelope = envelope;
        }
    }

    private static enum EnvelopeRoute {
        DEFAULT,
        JOB_COMPLETED,
        GET_JOB_HISTORY,
        HAS_JOB,
        MARK_JOB_AS_RUNNING,
        LOAD_OUTPUT_DIST;

    }
}

