/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.tl;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.event.EventQueue;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.DaemonThreadFactory;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.Log4jInit;
import com.helpsystems.common.core.util.NativeSz;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.StreamCopier;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.ConnectRequest;
import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.ForwardingPeerRunner;
import com.helpsystems.common.tl.IPeer;
import com.helpsystems.common.tl.LingeringObjectRegistry;
import com.helpsystems.common.tl.LoopbackPeerRunner;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.PeerProtocolRunner;
import com.helpsystems.common.tl.PeerStats;
import com.helpsystems.common.tl.PeerStatsHelper;
import com.helpsystems.common.tl.SSLSocketAdjust;
import com.helpsystems.common.tl.SecureClientSocketFactory;
import com.helpsystems.common.tl.SecureServerSocketFactory;
import com.helpsystems.common.tl.SocketProtocol;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.busobj.DataManagerEntry;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.event.PeerConnectEvent;
import com.helpsystems.common.tl.event.PeerDisconnectEvent;
import com.helpsystems.common.tl.event.ServerSocketClosedEvent;
import com.helpsystems.common.tl.ex.EnvelopeException;
import com.helpsystems.common.tl.ex.ForwardingFailureException;
import com.helpsystems.common.tl.ex.InvalidCredentialsException;
import com.helpsystems.common.tl.ex.NotConnectedException;
import com.helpsystems.common.tl.ex.NotUniqueException;
import com.helpsystems.common.tl.ex.PeerConnectException;
import com.helpsystems.common.tl.ex.PeerInitialConnectException;
import com.helpsystems.common.tl.ex.PeerStartupException;
import com.helpsystems.common.tl.ex.SocketInUseException;
import com.helpsystems.common.tl.ex.SocketStartupException;
import com.helpsystems.common.tl.ex.UndeliverableEnvelopeException;
import com.helpsystems.common.tl.ex.UnknownPeerException;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.impl.PeerDisconnectCommand;
import com.helpsystems.common.tl.processor.impl.ThrowableCommandResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.swing.SwingUtilities;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public abstract class Peer {
    public static final int SOCKET_READ_TIMEOUT = 300000;
    public static final int NO_SERVER_SOCKET = -1234;
    public static final int ANY_SERVER_SOCKET = -1235;
    public static boolean USE_LOCAL_IP_ONLY = false;
    public static final String DIAGNOSTICS_URL = "/cp/HS_diagnostics.html";
    private static final int INITIAL_CONNECT_TIMEOUT = 180000;
    private static final Logger logger = Logger.getLogger(Peer.class);
    private static final boolean PLAINTEXT_CONNECTIONS;
    private static final ResourceBundleHandler rbh;
    protected static final String[] ALL_SECTIONS;
    private RMIClientSocketFactory csf;
    private RMIServerSocketFactory ssf;
    private Date whenStarted;
    private ServerSocket ss;
    private boolean shutdownStarted;
    private PeerDescriptor localPeerDescriptor;
    private PeerDescriptor remotePeerDescriptor;
    private Hashtable<PeerID, IPeer> routingTable;
    private EventQueue eventQueue;
    private PeerID ourLocalPeerID;
    private PeerID ourRemotePeerID;
    private boolean bypassSwingTest;
    private LingeringObjectRegistry remoteObjectRegistry;
    private HashMap<PeerID, PeerID> forwardingCache;
    private ThreadLocal<Socket> currentHttpSocket;
    private boolean allowDiagnosticRequests = true;

    public Peer(PeerDescriptor peerDescriptor, Serializable serializable) throws PeerStartupException {
        this.internalInit(peerDescriptor, serializable);
    }

    public void addEvent(GenericEvent genericEvent) {
        this.addEvent(genericEvent, false);
    }

    public void addEvent(GenericEvent genericEvent, boolean bl) {
        this.eventQueue.addEvent(genericEvent, bl);
    }

    public void addListener(SimpleEventListener simpleEventListener) {
        this.eventQueue.addListener(simpleEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPeerToRoutingTable(IPeer iPeer) {
        Object object;
        ValidationHelper.checkForNull((String)"Peer", (Object)iPeer);
        PeerID peerID = iPeer.getPeerID();
        ValidationHelper.checkForNull((String)"Peer ID", (Object)peerID);
        PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
        ValidationHelper.checkForNull((String)"PeerDescriptor", (Object)peerDescriptor);
        if (!peerDescriptor.isValid()) {
            throw new IllegalArgumentException("Invalid peer descriptor: " + peerDescriptor);
        }
        if (iPeer instanceof PeerProtocolRunner && (object = ((PeerProtocolRunner)iPeer).getInetAddress()) != null) {
            peerDescriptor.addAddress(((InetAddress)object).getHostAddress());
            peerDescriptor.addAddress(((InetAddress)object).getHostName());
        }
        object = null;
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            object = this.routingTable.get(peerID);
            if (object instanceof LoopbackPeerRunner) {
                throw new IllegalStateException("Cannot replace existing loopback entry.");
            }
            this.routingTable.remove(peerID);
            this.routingTable.put(peerID, iPeer);
            logger.trace((Object)("Peer added to routing table: " + peerDescriptor));
            this.addEvent(new PeerConnectEvent(peerID, this.ourRemotePeerID));
        }
        if (object != null) {
            object.close();
        }
    }

    protected abstract void checkCredentials(ConnectRequest var1) throws PeerConnectException, InvalidCredentialsException;

    public PeerID connectToPeer(PeerDescriptor peerDescriptor, Serializable serializable) throws PeerConnectException, InvalidCredentialsException {
        ValidationHelper.checkForNull((String)"Credentials", (Object)serializable);
        SocketProtocol socketProtocol = this.retrieveRemotePeerReference(peerDescriptor);
        PeerProtocolRunner peerProtocolRunner = this.startPeerRunner(socketProtocol, serializable);
        return peerProtocolRunner.waitForConnection(180000L);
    }

    public static int getPID() throws ActionFailedException {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf("@");
        if (n > 0) {
            try {
                return Integer.parseInt(string.substring(0, n));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to parse PID: " + string);
        }
    }

    protected String getHtmlRootPage() {
        return DIAGNOSTICS_URL;
    }

    protected Socket getCurrentHttpSocket() {
        return this.currentHttpSocket.get();
    }

    protected String getHtmlSection(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if ("routingTable".equals(string)) {
            return this.getRoutingTableHTML();
        }
        if ("general".equals(string)) {
            return this.getGeneralHTML();
        }
        if ("remoteObjects".equals(string)) {
            return this.getRemoteObjectsHTML();
        }
        if ("threads".equals(string)) {
            return this.getThreadHTML();
        }
        if ("listeners".equals(string)) {
            return this.getListenerHTML();
        }
        if ("managers".equals(string)) {
            return this.getManagerListingHTML();
        }
        if ("properties".equals(string)) {
            return this.getPropertiesHTML();
        }
        return null;
    }

    private String getGeneralHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Overview:</h2>\n");
        stringBuffer.append("<table border=0>\n");
        stringBuffer.append("<tr><td><b>Peer type:</b></td><td>\n");
        stringBuffer.append(this.localPeerDescriptor.getTypeAsString());
        stringBuffer.append("\n</td></tr>\n");
        stringBuffer.append("<tr><td><b>Peer name:</b></td><td>\n");
        stringBuffer.append(this.localPeerDescriptor.getPeerName());
        stringBuffer.append("\n</td></tr>\n");
        stringBuffer.append("<tr><td><b>Process ID:</b></td><td>\n");
        try {
            stringBuffer.append(Peer.getPID());
        }
        catch (Exception exception) {
            stringBuffer.append("Unknown");
        }
        stringBuffer.append("\n</td></tr>\n");
        stringBuffer.append("<tr><td><b>Started:</b></td><td>\n");
        stringBuffer.append(this.whenStarted);
        stringBuffer.append("\n</td></tr>\n");
        Runtime runtime = Runtime.getRuntime();
        float f = (float)((double)runtime.freeMemory() / 1024.0 / 1024.0);
        float f2 = (float)((double)runtime.maxMemory() / 1024.0 / 1024.0);
        float f3 = (float)((double)runtime.totalMemory() / 1024.0 / 1024.0);
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(2);
        stringBuffer.append("<tr><td><b>Allocated memory:</b></td><td>\n");
        stringBuffer.append(decimalFormat.format(f3));
        stringBuffer.append(" MB\n</td></tr>\n");
        stringBuffer.append("<tr><td><b>Memory used:</b></td><td>\n");
        stringBuffer.append(decimalFormat.format(f3 - f));
        stringBuffer.append(" MB\n</td></tr>\n");
        stringBuffer.append("<tr><td><b>Maximum memory:</b></td><td>\n");
        stringBuffer.append(decimalFormat.format(f2));
        stringBuffer.append(" MB\n</td></tr>\n");
        if (this.isShutdownStarted()) {
            stringBuffer.append("<tr><td><b><font color=\"red\">This process/peer is shutting down.</b></b></td><td>\n");
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    private String getRoutingTableHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Routing table entries:</h2>\n");
        PeerID[] peerIDArray = this.getPeersFromRoutingTable();
        if (peerIDArray.length == 0) {
            stringBuffer.append("No connections.<br>\n");
        } else {
            stringBuffer.append("<table border=\"1\" bordercolor=\"gray\" cellspacing=\"0\">\n");
            stringBuffer.append("<tr><td><b>Address</b></td>\n");
            stringBuffer.append("<td><b>Port</b></td>\n");
            stringBuffer.append("<td><b>Type</b></td>\n");
            stringBuffer.append("<td><b>OS</b></td>\n");
            stringBuffer.append("<td><b>Connect time</b></td>\n");
            stringBuffer.append("<td><b># RX</b></td>\n");
            stringBuffer.append("<td><b>Last RX</b></td>\n");
            stringBuffer.append("<td><b># TX</b></td>\n");
            stringBuffer.append("<td><b>Last TX</b></td>\n");
            stringBuffer.append("<td><b>Backlog</b></td>\n");
            stringBuffer.append("<td><b>Routing<br>Identifier</b></td></tr>\n");
            for (int i = 0; i < peerIDArray.length; ++i) {
                String string;
                PeerID peerID = peerIDArray[i];
                PeerDescriptor peerDescriptor = peerID.getPeerDescriptor();
                int n = peerDescriptor.getPort();
                PeerStats peerStats = null;
                IPeer iPeer = this.getPeerFromRoutingTable(peerID);
                if (iPeer == null) continue;
                peerStats = iPeer.getStats();
                stringBuffer.append("<tr><td>");
                if (iPeer instanceof ForwardingPeerRunner || iPeer instanceof LoopbackPeerRunner || n == -1234) {
                    string = peerDescriptor.getComputerName();
                    if (string == null || string.length() == 0) {
                        string = peerDescriptor.findPrintableAddress().replaceAll("\\.", ". ");
                    }
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append(this.makeBasicLink(peerDescriptor));
                }
                stringBuffer.append("</td>\n");
                string = null;
                string = n == -1234 ? "None" : Integer.toString(n);
                stringBuffer.append("<td>" + string + "</td>\n");
                stringBuffer.append("<td>" + peerDescriptor.getTypeAsString() + "</td>\n");
                stringBuffer.append("<td>" + peerDescriptor.getOSName() + "</td>\n");
                stringBuffer.append("<td>" + PeerStatsHelper.getWhenConnectionEstablished(peerStats) + "</td>\n");
                stringBuffer.append("<td>" + PeerStatsHelper.getEnvelopeRXCount(peerStats) + "</td>\n");
                stringBuffer.append("<td>" + this.nullToBlank(PeerStatsHelper.getWhenLastEnvelopeRX(peerStats)) + "</td>\n");
                stringBuffer.append("<td>" + PeerStatsHelper.getEnvelopeTXCount(peerStats) + "</td>\n");
                stringBuffer.append("<td>" + this.nullToBlank(PeerStatsHelper.getWhenLastEnvelopeTX(peerStats)) + "</td>\n");
                stringBuffer.append("<td>" + iPeer.getBacklog() + "</td>\n");
                String string2 = peerID.getHardwareKey();
                if (!string2.startsWith("I-") && string2.length() > 20) {
                    string2 = peerID.getHardwareHash();
                }
                string = peerID.getInstanceIdentifier() + "<br>" + string2;
                stringBuffer.append("<td>" + string + "</td></tr>\n");
            }
            stringBuffer.append("</table>\n");
        }
        return stringBuffer.toString();
    }

    private String getRemoteObjectsHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Remote Object Registry:</h2>\n");
        stringBuffer.append(this.remoteObjectRegistry.getInfoHTML());
        return stringBuffer.toString();
    }

    private String getThreadHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Thread[] threadArray = new Thread[5000];
        threadGroup.enumerate(threadArray, true);
        Arrays.sort(threadArray, new Comparator<Thread>(){

            @Override
            public int compare(Thread thread, Thread thread2) {
                if (thread == null && thread2 == null) {
                    return 0;
                }
                if (thread == null) {
                    return 1;
                }
                if (thread2 == null) {
                    return -1;
                }
                return thread.getName().compareTo(thread2.getName());
            }
        });
        Map map = this.getThreadStacks();
        stringBuffer.append("<h2>Threads:</h2>\n");
        for (int i = 0; i < threadArray.length; ++i) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread = threadArray[i];
            if (thread == null) continue;
            stringBuffer.append("<b>");
            stringBuffer.append(thread.getName());
            stringBuffer.append("</b>");
            stringBuffer.append(" [");
            String[] stringArray = thread.getClass().getName().replace('.', ' ').split(" ");
            stringBuffer.append(stringArray[stringArray.length - 1]);
            stringBuffer.append("]");
            if (thread.isDaemon()) {
                stringBuffer.append(" [Daemon]");
            } else {
                stringBuffer.append(" [Non-Daemon]");
            }
            stringBuffer.append("<br>\n");
            if (map == null || (stackTraceElementArray = (StackTraceElement[])map.get(thread)) == null) continue;
            stringBuffer.append("<pre>");
            for (int j = 0; j < stackTraceElementArray.length; ++j) {
                stringBuffer.append("   ");
                stringBuffer.append(stackTraceElementArray[j]);
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</pre><br>");
        }
        return stringBuffer.toString();
    }

    private String getListenerHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Peer Event Listeners:</h2>\n");
        stringBuffer.append(this.eventQueue.getInfoHTML());
        return stringBuffer.toString();
    }

    private String getManagerListingHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            IPeerInfoManager iPeerInfoManager = (IPeerInfoManager)ManagerRegistry.getManager((String)"PEER.PeerInfoManager");
            DataManagerEntry[] dataManagerEntryArray = iPeerInfoManager.listManagers();
            stringBuffer.append("<h2>Data Managers:</h2>\n");
            if (dataManagerEntryArray.length == 0) {
                stringBuffer.append("None.<br>\n");
            } else {
                stringBuffer.append("<table border=\"1\" bordercolor=\"gray\" cellspacing=\"0\">\n");
                stringBuffer.append("<tr><td><b>DM Name</b></td><td><b>Interface</b></td>");
                stringBuffer.append("<td><b>Implementation Class</b></td><td><b>DM Version</b></td>");
                stringBuffer.append("<td><b>Interface Version</b></td></tr>\n");
                for (int i = 0; i < dataManagerEntryArray.length; ++i) {
                    DataManagerEntry dataManagerEntry = dataManagerEntryArray[i];
                    stringBuffer.append("<tr><td>");
                    stringBuffer.append(dataManagerEntry.getName());
                    stringBuffer.append("</td><td>");
                    stringBuffer.append(dataManagerEntry.getInterfaceName());
                    stringBuffer.append("</td><td>");
                    stringBuffer.append(dataManagerEntry.getClassName());
                    stringBuffer.append("</td><td>");
                    RelMod relMod = dataManagerEntry.getManagerVersion();
                    if (relMod == null) {
                        stringBuffer.append("-");
                    } else {
                        stringBuffer.append(relMod.toString());
                    }
                    stringBuffer.append("</td><td>");
                    relMod = dataManagerEntry.getInterfaceVersion();
                    if (relMod == null) {
                        stringBuffer.append("-");
                    } else {
                        stringBuffer.append(relMod.toString());
                    }
                    stringBuffer.append("</td></tr>");
                }
                stringBuffer.append("</table>\n");
            }
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to get a listing of DMs for the diagnostic page.", (Throwable)exception);
            stringBuffer.append("Not currently available.<br>");
        }
        return stringBuffer.toString();
    }

    private String getPropertiesHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<h2>Java Properties:</h2>\n");
        Properties properties = System.getProperties();
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        for (Object map2 : treeMap.keySet()) {
            Object object = treeMap.get(map2);
            stringBuffer.append("<b>" + map2 + ":</b> " + object + "<br>\n");
        }
        stringBuffer.append("<hr><h2>System Environment:</h2>\n");
        Map<String, String> map = System.getenv();
        treeMap = new TreeMap<String, String>(map);
        for (Object object : treeMap.keySet()) {
            Object object2 = treeMap.get(object);
            stringBuffer.append("<b>" + object + ":</b> " + object2 + "<br>\n");
        }
        return stringBuffer.toString();
    }

    protected String makeBasicLink(PeerDescriptor peerDescriptor) {
        Object object;
        String string;
        String string2 = null;
        String string3 = null;
        InetAddress inetAddress = peerDescriptor.getPreferredInetAddress();
        if (inetAddress != null) {
            string2 = inetAddress.getHostAddress();
            string3 = inetAddress.getHostName();
            string = inetAddress.getHostAddress();
            if (PeerDescriptor.isLoopbackAddress(string) && (object = this.getCurrentHttpSocket()) != null) {
                string2 = ((Socket)object).getLocalAddress().getHostAddress();
            }
        } else {
            string2 = peerDescriptor.findIPAddress();
            string3 = peerDescriptor.findPrintableAddress();
        }
        string = peerDescriptor.getComputerName();
        if (string == null || string.length() == 0) {
            string = string3;
        }
        object = new StringBuilder();
        if (!string2.equals(string3)) {
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append("<br>");
        }
        ((StringBuilder)object).append("<a href=\"https://");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(":");
        ((StringBuilder)object).append(peerDescriptor.getPort());
        ((StringBuilder)object).append(DIAGNOSTICS_URL);
        ((StringBuilder)object).append("\">");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append("</a>");
        return ((StringBuilder)object).toString();
    }

    protected String makeLink(PeerDescriptor peerDescriptor) {
        String string = peerDescriptor.findIPAddress();
        InetAddress inetAddress = peerDescriptor.getPreferredInetAddress();
        if (inetAddress != null) {
            string = inetAddress.getHostAddress();
        }
        return this.makeLink(string, peerDescriptor.getPort(), peerDescriptor.toString());
    }

    protected String makeLink(String string, int n, String string2) {
        return this.makeLink(string, Integer.toString(n), string2);
    }

    protected String makeLink(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<a href=\"https://");
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        stringBuilder.append(DIAGNOSTICS_URL);
        stringBuilder.append("\">");
        stringBuilder.append(string3);
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    protected String nullToBlank(Object object) {
        if (object == null) {
            return "&nbsp;";
        }
        String string = object.toString();
        if (string == null || string.trim().length() == 0) {
            return "&nbsp;";
        }
        return string;
    }

    protected Processable deserializeEnvelope(Envelope envelope) throws ClassNotFoundException, IOException {
        return envelope.getPayload();
    }

    public void disconnectAll() {
        this.disconnectAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAll(boolean bl) {
        IPeer[] iPeerArray = null;
        IPeer[] iPeerArray2 = this.routingTable;
        synchronized (this.routingTable) {
            iPeerArray = this.getPeerReferences();
            IPeer iPeer = this.routingTable.get(this.ourRemotePeerID);
            this.routingTable.clear();
            if (!bl) {
                this.routingTable.put(this.ourRemotePeerID, iPeer);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (IPeer iPeer2 : iPeerArray) {
                if (iPeer2 instanceof LoopbackPeerRunner) continue;
                this.closeAndSendNotification(iPeer2);
            }
            return;
        }
    }

    public void disconnectFromPeer(PeerID peerID) {
        this.removePeerFromRoutingTable(peerID);
    }

    public PeerID findPeer(PeerDescriptor peerDescriptor) throws NotConnectedException, NotUniqueException {
        return this.findPeer(peerDescriptor, null);
    }

    public PeerID findPeer(PeerDescriptor peerDescriptor, PeerID[] peerIDArray) throws NotConnectedException, NotUniqueException {
        ValidationHelper.checkForNull((String)"PeerDescriptor", (Object)peerDescriptor);
        PeerID[] peerIDArray2 = this.searchRoutingTableFor(peerDescriptor);
        if (peerIDArray2.length == 1) {
            return peerIDArray2[0];
        }
        if (peerIDArray2.length > 1) {
            throw new NotUniqueException("The peer descriptor " + peerDescriptor.toString() + " matches " + peerIDArray2.length + " connected peers.");
        }
        ArrayList<PeerID> arrayList = new ArrayList<PeerID>();
        arrayList.add(this.getRemotePeerID());
        if (peerIDArray != null) {
            arrayList.addAll(Arrays.asList(peerIDArray));
        }
        PeerID[] peerIDArray3 = new PeerID[arrayList.size()];
        arrayList.toArray(peerIDArray3);
        PeerID[] peerIDArray4 = this.getGatewaysFromRoutingTable();
        PeerID peerID = null;
        IPeerInfoManager iPeerInfoManager = null;
        for (int i = 0; i < peerIDArray4.length; ++i) {
            PeerID peerID2 = peerIDArray4[i];
            if (arrayList.contains(peerID2)) continue;
            try {
                iPeerInfoManager = (IPeerInfoManager)TLManagerFactory.createProxy(IPeerInfoManager.class, this, peerID2, "PEER.PeerInfoManager", -1);
                peerID = iPeerInfoManager.findPeer(peerDescriptor, peerIDArray3);
                if (peerID == null) continue;
                return peerID;
            }
            catch (Exception exception) {
                logger.debug((Object)("Error when asking host " + peerID2.getPeerDescriptor().findPrintableAddress() + " for info about " + peerDescriptor), (Throwable)exception);
            }
        }
        throw new NotConnectedException("The peer " + peerDescriptor + " could not be found.");
    }

    protected void forwardEnvelope(Envelope envelope) throws EnvelopeException {
        PeerID peerID = envelope.getSource();
        PeerID peerID2 = envelope.getDestination();
        int n = envelope.getRemainingHops() - 1;
        if (n < 1) {
            CommonVersionedObject commonVersionedObject = peerID2.getPeerDescriptor();
            if (commonVersionedObject == null) {
                commonVersionedObject = peerID2;
            }
            logger.debug((Object)("Envelope expired, destined for " + peerID2));
            throw new ForwardingFailureException("Envelope forwarding expired.", envelope);
        }
        PeerID[] peerIDArray = envelope.getRoute();
        for (int i = 0; i < peerIDArray.length; ++i) {
            if (!peerIDArray[i].equals(this.ourRemotePeerID)) continue;
            throw new ForwardingFailureException("Circular route detected in envelope " + envelope.getArbitraryID(), envelope);
        }
        if (envelope.isUselessPeer(this.getRemotePeerID())) {
            throw new UndeliverableEnvelopeException("Peer " + this.ourRemotePeerID + " is unable to forward envelope " + envelope.getArbitraryID() + " to peer " + envelope.getDestination(), envelope);
        }
        envelope.setRemainingHops(n);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("FORWARDING envelope from " + peerID.getPeerDescriptor() + " to " + peerID2.getPeerDescriptor() + ", hops remaining: " + n));
        }
        this.sendEnvelope(envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerStats[] getAllStats() {
        PeerStats[] peerStatsArray = null;
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            peerStatsArray = new PeerStats[this.routingTable.size()];
            Iterator<IPeer> iterator = this.routingTable.values().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                IPeer iPeer = iterator.next();
                peerStatsArray[n] = iPeer.getStats();
                ++n;
            }
        }
        return peerStatsArray;
    }

    public PeerID[] getHostsFromRoutingTable() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(1);
        PeerID[] peerIDArray = this.searchRoutingTableFor(peerDescriptor);
        return peerIDArray;
    }

    public PeerID[] getGatewaysFromRoutingTable() {
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(6);
        PeerID[] peerIDArray = this.searchRoutingTableFor(peerDescriptor);
        PeerID[] peerIDArray2 = this.getHostsFromRoutingTable();
        if (peerIDArray.length == 0) {
            return peerIDArray2;
        }
        if (peerIDArray2.length == 0) {
            return peerIDArray;
        }
        PeerID[] peerIDArray3 = new PeerID[peerIDArray.length + peerIDArray2.length];
        int n = this.localPeerDescriptor.getType();
        if (n == 6) {
            System.arraycopy(peerIDArray, 0, peerIDArray3, 0, peerIDArray.length);
            System.arraycopy(peerIDArray2, 0, peerIDArray3, peerIDArray.length, peerIDArray2.length);
        } else {
            System.arraycopy(peerIDArray2, 0, peerIDArray3, 0, peerIDArray2.length);
            System.arraycopy(peerIDArray, 0, peerIDArray3, peerIDArray2.length, peerIDArray.length);
        }
        return peerIDArray3;
    }

    public PeerDescriptor getLocalPeerDescriptor() {
        return (PeerDescriptor)this.localPeerDescriptor.clone();
    }

    public PeerDescriptor getPeerDescriptor() {
        return (PeerDescriptor)this.remotePeerDescriptor.clone();
    }

    public PeerID getRemotePeerID() {
        while (this.ourRemotePeerID == null) {
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
        return (PeerID)this.ourRemotePeerID.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPeer getPeerFromRoutingTable(PeerID peerID) {
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            return this.routingTable.get(peerID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerID[] getPeersFromRoutingTable() {
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            Set<PeerID> set = this.routingTable.keySet();
            PeerID[] peerIDArray = new PeerID[set.size()];
            set.toArray(peerIDArray);
            return peerIDArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IPeer[] getPeerReferences() {
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            Collection<IPeer> collection = this.routingTable.values();
            IPeer[] iPeerArray = new IPeer[collection.size()];
            collection.toArray(iPeerArray);
            return iPeerArray;
        }
    }

    public Date getWhenStarted() {
        return this.whenStarted;
    }

    private void internalInit(PeerDescriptor peerDescriptor, Serializable serializable) throws PeerStartupException {
        this.localPeerDescriptor = (PeerDescriptor)peerDescriptor.clone();
        this.remotePeerDescriptor = (PeerDescriptor)peerDescriptor.clone();
        this.remotePeerDescriptor.removeLoopbackAddresses();
        this.forwardingCache = new HashMap();
        int n = peerDescriptor.getPort();
        if (n != -1234) {
            if (!PLAINTEXT_CONNECTIONS) {
                this.ssf = new SecureServerSocketFactory();
            }
            this.startServerSocket(n);
        }
        if (!PLAINTEXT_CONNECTIONS) {
            this.csf = new SecureClientSocketFactory();
        }
        this.routingTable = new Hashtable();
        this.eventQueue = new EventQueue();
        this.eventQueue.setThreadName("Local Peer Notification");
        String string = null;
        try {
            string = NativeSz.getStreamVersion();
        }
        catch (Throwable throwable) {
            throw new PeerStartupException("The NativeSz library could not be accessed.", throwable);
        }
        String string2 = System.getProperty("hwko");
        if (string2 != null && string2.length() > 0) {
            string = string2;
        }
        this.ourLocalPeerID = new PeerID(string, serializable);
        this.ourLocalPeerID.setPeerDescriptor(this.localPeerDescriptor);
        this.ourRemotePeerID = new PeerID(string, serializable);
        this.ourRemotePeerID.setPeerDescriptor(this.remotePeerDescriptor);
        this.whenStarted = new Date();
        LoopbackPeerRunner loopbackPeerRunner = null;
        long l = SkybotStackSize.getStackSize();
        loopbackPeerRunner = l != 0L ? new LoopbackPeerRunner(this, "Loopback", l) : new LoopbackPeerRunner(this, "Loopback");
        loopbackPeerRunner.start();
        this.addPeerToRoutingTable(loopbackPeerRunner);
        this.remoteObjectRegistry = new LingeringObjectRegistry(this);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PeerID[] peerIDArray;
                for (PeerID peerID : peerIDArray = Peer.this.getPeersFromRoutingTable()) {
                    IPeer iPeer = Peer.this.getPeerFromRoutingTable(peerID);
                    if (!(iPeer instanceof PeerProtocolRunner)) continue;
                    final PeerProtocolRunner peerProtocolRunner = (PeerProtocolRunner)iPeer;
                    PeerStats peerStats = iPeer.getStats();
                    long l = System.currentTimeMillis();
                    Date date = PeerStatsHelper.getWhenLastEnvelopeRX(peerStats);
                    if (date == null) {
                        date = new Date(l);
                        PeerStatsHelper.setWhenLastEnvelopeRX(peerStats, l);
                        continue;
                    }
                    long l2 = date.getTime();
                    if ((double)l2 + 486000.0 < (double)l) {
                        logger.debug((Object)("Connection inactivity timeout for peer " + peerID + ". Last data received at " + DateTranslator.formatDateTime((Date)date) + ", current time " + DateTranslator.formatDateTime((Date)new Date())));
                        Peer.this.removePeerFromRoutingTable(peerID);
                        continue;
                    }
                    if (l2 + 120000L >= l) continue;
                    final PeerID peerID2 = peerID;
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                long l = Peer.this.getConnectTime(peerID2);
                                Thread.currentThread().setName("Waiting for ping response from " + peerID2);
                                try {
                                    peerProtocolRunner.pingPeer(peerID2);
                                }
                                catch (Exception exception) {
                                    long l2 = Peer.this.getConnectTime(peerID2);
                                    if (l2 <= -1L || l2 != l) break block2;
                                    logger.debug((Object)("Socket ping failed: " + peerID2), (Throwable)exception);
                                    Peer.this.removePeerFromRoutingTable(peerID2);
                                }
                            }
                        }
                    });
                    thread.start();
                }
            }
        };
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new DaemonThreadFactory("PingRunner"));
        scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, 60L, TimeUnit.SECONDS);
        this.currentHttpSocket = new InheritableThreadLocal<Socket>();
    }

    private long getConnectTime(PeerID peerID) {
        IPeer iPeer = this.getPeerFromRoutingTable(peerID);
        if (iPeer == null) {
            return -1L;
        }
        PeerStats peerStats = iPeer.getStats();
        if (peerStats == null) {
            return -1L;
        }
        Date date = PeerStatsHelper.getWhenConnectionEstablished(peerStats);
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    public boolean isShutdownStarted() {
        return this.shutdownStarted;
    }

    public boolean isGateway() {
        return this.localPeerDescriptor.isGateway();
    }

    public boolean isAllowDiagnosticRequests() {
        return this.allowDiagnosticRequests;
    }

    public void setAllowDiagnosticRequests(boolean bl) {
        this.allowDiagnosticRequests = bl;
    }

    protected abstract void processEnvelope(Envelope var1);

    public void removeListener(SimpleEventListener simpleEventListener) {
        this.eventQueue.removeListener(simpleEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePeerFromRoutingTable(PeerID peerID) {
        if (peerID.equals(this.ourRemotePeerID)) {
            return;
        }
        IPeer iPeer = null;
        Hashtable<PeerID, IPeer> hashtable = this.routingTable;
        synchronized (hashtable) {
            iPeer = this.routingTable.remove(peerID);
            if (iPeer != null) {
                logger.trace((Object)("Removing peer from routing table: " + iPeer.getPeerID().getPeerDescriptor()));
            }
        }
        this.closeAndSendNotification(iPeer);
    }

    private void closeAndSendNotification(IPeer iPeer) {
        if (iPeer == null) {
            return;
        }
        iPeer.close();
        this.addEvent(new PeerDisconnectEvent(iPeer.getPeerID(), this.ourRemotePeerID));
        if (this.localPeerDescriptor.isGateway()) {
            PeerDisconnectCommand peerDisconnectCommand = new PeerDisconnectCommand();
            peerDisconnectCommand.setSource(iPeer.getPeerID());
            try {
                Envelope envelope = new Envelope();
                envelope.setPayload(peerDisconnectCommand);
                envelope.setSource(this.getRemotePeerID());
                envelope.setDestination(this.getRemotePeerID());
                this.sendEnvelope(envelope);
            }
            catch (Exception exception) {
                logger.debug((Object)"Unable to send a loopback peer disconnect notification", (Throwable)exception);
            }
        }
    }

    public void checkWaitingThreads(PeerID peerID) {
        IPeer[] iPeerArray = this.getPeerReferences();
        for (int i = 0; i < iPeerArray.length; ++i) {
            iPeerArray[i].testWaitingThreads(peerID);
        }
    }

    public LingeringObjectRegistry getRemoteObjectRegistry() {
        return this.remoteObjectRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketProtocol retrieveRemotePeerReference(PeerDescriptor peerDescriptor) throws PeerConnectException {
        int n;
        if (peerDescriptor == null) {
            throw new NullPointerException("The peer descriptor passed in is null.");
        }
        if (!peerDescriptor.isValid(false)) {
            throw new IllegalArgumentException("The peer descriptor passed in contains an invalid field.");
        }
        String string = peerDescriptor.findPrintableAddress();
        String string2 = this.localPeerDescriptor.findPrintableAddress();
        String[] stringArray = peerDescriptor.getAddresses();
        InetAddress[] inetAddressArray = new InetAddress[stringArray.length];
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            try {
                inetAddressArray[n] = InetAddress.getByName(stringArray[n]);
                bl = true;
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (!bl) {
            throw new UnknownPeerException(string2, string);
        }
        n = peerDescriptor.getPort();
        Exception exception = null;
        for (int i = 0; i < inetAddressArray.length; ++i) {
            Object object;
            Socket socket = null;
            try {
                socket = new Socket();
                object = new InetSocketAddress(inetAddressArray[i].getHostAddress(), n);
                socket.connect((SocketAddress)object, 5000);
            }
            catch (Exception exception2) {
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception3) {}
                }
            }
            object = null;
            try {
                object = this.csf == null ? new Socket(inetAddressArray[i].getHostAddress(), n) : this.csf.createSocket(inetAddressArray[i].getHostAddress(), n);
                logger.trace((Object)("Socket connected to peer: " + peerDescriptor));
                if (this.localPeerDescriptor.isIBMiAgent()) {
                    logger.debug((Object)"Found Local Agent is IBM i");
                    if (object instanceof SSLSocket) {
                        SSLSocket sSLSocket = (SSLSocket)object;
                        SSLSocketAdjust.setProtocolsForJavaVersion(sSLSocket);
                    }
                }
                return new SocketProtocol((Socket)object);
            }
            catch (Exception exception4) {
                if (exception != null) continue;
                exception = exception4;
            }
        }
        String string3 = rbh.getMsg("unableToConnect", (Object)string2, (Object)string, (Object)Integer.toString(n));
        throw new PeerInitialConnectException(string3, exception);
    }

    public PeerID[] searchRoutingTableFor(String string, Serializable serializable) {
        String string2 = null;
        if (string.length() == 0) {
            string2 = null;
        } else {
            try {
                string2 = MD5.shortHash((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList<PeerID> arrayList = new ArrayList<PeerID>();
        PeerID[] peerIDArray = this.getPeersFromRoutingTable();
        for (int i = 0; i < peerIDArray.length; ++i) {
            PeerID peerID = peerIDArray[i];
            String string3 = peerID.getHardwareHash();
            if (string3 == null) {
                string3 = peerID.getHardwareKey();
            }
            if (string2 != null && !Equal.isEqual((Object)string3, (Object)string2) || serializable != null && !Equal.isEqual((Object)serializable, (Object)peerID.getInstanceIdentifier())) continue;
            arrayList.add(peerID);
        }
        PeerID[] peerIDArray2 = new PeerID[arrayList.size()];
        arrayList.toArray(peerIDArray2);
        return peerIDArray2;
    }

    public PeerID[] searchRoutingTableFor(PeerDescriptor peerDescriptor) {
        ValidationHelper.checkForNull((String)"Peer Descriptor", (Object)peerDescriptor);
        if (this.routingTable.size() == 0) {
            return new PeerID[0];
        }
        String[] stringArray = peerDescriptor.getAddresses();
        int n = peerDescriptor.getType();
        int n2 = peerDescriptor.getPort();
        HashMap<PeerID, String> hashMap = new HashMap<PeerID, String>();
        PeerID[] peerIDArray = this.getPeersFromRoutingTable();
        for (int i = 0; i < peerIDArray.length; ++i) {
            boolean bl;
            PeerDescriptor peerDescriptor2 = peerIDArray[i].getPeerDescriptor();
            if (stringArray.length > 0 && !(bl = Peer.searchAddresses(peerDescriptor2.getAddresses(), stringArray)) || n != 0 && n != peerDescriptor2.getType() || n2 != 0 && n2 != peerDescriptor2.getPort()) continue;
            hashMap.put(peerIDArray[i], "hi");
        }
        PeerID[] peerIDArray2 = new PeerID[hashMap.size()];
        hashMap.keySet().toArray(peerIDArray2);
        return peerIDArray2;
    }

    public static boolean searchAddresses(String[] stringArray, String[] stringArray2) {
        ValidationHelper.checkForNull((String)"Available Addresses", (Object)stringArray);
        ValidationHelper.checkForNull((String)"Search for addresses", (Object)stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].toUpperCase();
            for (int j = 0; j < stringArray2.length; ++j) {
                String string2 = stringArray2[j].toUpperCase();
                if (string.equals(string2)) {
                    return true;
                }
                if (!string.startsWith(string2 + ".") && !string2.startsWith(string + ".")) continue;
                return true;
            }
        }
        return false;
    }

    public void sendEnvelope(Envelope envelope) throws EnvelopeException {
        this.sendEnvelopeAndWait(envelope, 0);
    }

    public Envelope sendEnvelopeAndWait(Envelope envelope) throws EnvelopeException {
        return this.sendEnvelopeAndWait(envelope, -1);
    }

    public Envelope sendEnvelopeAndWait(Envelope envelope, int n) throws EnvelopeException {
        IPeer iPeer;
        Object object;
        if (envelope == null) {
            throw new NullPointerException("The envelope passed in is null.");
        }
        PeerID peerID = envelope.getDestination();
        if (peerID == null) {
            throw new NullPointerException("The envelope doesn't have a destination - it's null.");
        }
        if (!this.bypassSwingTest) {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    object = new IllegalStateException("The EventDispatchThread should not be used to perform this action");
                    logger.debug((Object)"Event Dispatch Thread being used to perform a Transport Layer action", (Throwable)object);
                }
            }
            catch (Throwable throwable) {
                this.bypassSwingTest = true;
            }
        }
        if ((object = envelope.getFirstHop()) != null && ((PeerID)object).equals(this.ourRemotePeerID)) {
            envelope.setFirstHop(null);
            object = null;
        }
        if (object == null) {
            object = peerID;
        }
        if ((iPeer = this.getPeerFromRoutingTable((PeerID)object)) != null) {
            return this.sendEnvelopeToPeer(iPeer, envelope, n);
        }
        PeerID[] peerIDArray = this.getGatewaysFromRoutingTable();
        if (peerIDArray.length == 0) {
            throw new UndeliverableEnvelopeException("There are no gateways available to deliver the envelope to the destination " + peerID, envelope);
        }
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        hashSet.addAll(Arrays.asList(envelope.getRoute()));
        hashSet.add(this.ourLocalPeerID);
        for (int i = -1; i < peerIDArray.length; ++i) {
            PeerID peerID2 = null;
            if (i == -1) {
                peerID2 = this.forwardingCache.get(peerID);
                if (peerID2 == null) {
                    continue;
                }
            } else {
                peerID2 = peerIDArray[i];
            }
            if (hashSet.contains(peerID2) || envelope.getRemainingHops() == 0 && !peerID2.equals(peerID) || (iPeer = this.getPeerFromRoutingTable(peerID2)) == null || envelope.isUselessPeer(peerID2)) continue;
            try {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Attempting to forward the envelope " + envelope.getArbitraryID() + " from " + peerID.getPeerDescriptor() + " to peer " + iPeer.getPeerID()));
                }
                Envelope envelope2 = this.sendEnvelopeToPeer(iPeer, envelope, n);
                this.forwardingCache.put(peerID, peerID2);
                return envelope2;
            }
            catch (UndeliverableEnvelopeException undeliverableEnvelopeException) {
                Envelope envelope3 = undeliverableEnvelopeException.getEnvelope();
                PeerID[] peerIDArray2 = envelope3.getUselessPeers();
                for (int j = 0; j < peerIDArray2.length; ++j) {
                    envelope.addUselessPeer(peerIDArray2[j]);
                }
                continue;
            }
            catch (Throwable throwable) {
                logger.trace((Object)("Attempted to forward envelope " + envelope.getArbitraryID() + " from " + peerID.getPeerDescriptor() + " to peer " + iPeer.getPeerID() + " but an error occurred."), throwable);
            }
        }
        this.forwardingCache.remove(peerID);
        envelope.addUselessPeer(this.getRemotePeerID());
        throw new UndeliverableEnvelopeException("Unable to deliver the envelope " + envelope.getArbitraryID() + " to the destination " + envelope.getDestination(), envelope);
    }

    private Envelope sendEnvelopeToPeer(IPeer iPeer, Envelope envelope, int n) throws EnvelopeException {
        if (envelope.getSource() == null) {
            envelope.setSource(this.ourRemotePeerID);
        }
        if (logger.isTraceEnabled()) {
            PeerID peerID = envelope.getDestination();
            PeerID peerID2 = iPeer.getPeerID();
            String string = null;
            string = peerID2.equals(peerID) ? peerID.toString() : peerID + " via " + peerID2;
            logger.trace((Object)("Sending envelope to peer: " + string + "\n        Payload Class: " + envelope.getPayloadClassname() + "\n                   ID: " + envelope.getArbitraryID() + "\n    In Response to ID: " + envelope.getResponseToEnvelopeID()));
        }
        return iPeer.sendEnvelopeAndWait(envelope, n);
    }

    protected void sendExceptionResponse(Envelope envelope, Throwable throwable) {
        ThrowableCommandResponse throwableCommandResponse = new ThrowableCommandResponse(throwable);
        throwableCommandResponse.setSource(this.getRemotePeerID());
        Envelope envelope2 = new Envelope();
        envelope2.setDestination(envelope.getSource());
        envelope2.setResponseToEnvelopeID(envelope.getArbitraryID());
        try {
            envelope2.setPayload(throwableCommandResponse);
            this.sendEnvelope(envelope2);
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to send a Throwable response to " + envelope.getSource()), (Throwable)exception);
        }
    }

    private void startServerSocket(int n) throws SocketStartupException {
        if (this.ss != null) {
            throw new IllegalStateException("The server socket has already been created.");
        }
        if (n == -1234) {
            return;
        }
        if (n == -1235) {
            int n2 = (int)(Math.random() * 1000.0 + 44000.0);
            while (this.ss == null) {
                try {
                    this.switchListenPort(n2);
                }
                catch (SocketInUseException socketInUseException) {
                    ++n2;
                }
            }
        } else {
            this.switchListenPort(n);
        }
    }

    public void switchListenPort(int n) throws SocketStartupException {
        Object object;
        IOException iOException;
        ServerSocket serverSocket;
        block13: {
            if (this.ss != null && this.ss.getLocalPort() == n) {
                return;
            }
            serverSocket = null;
            Peer.testOpenSocket(n);
            iOException = null;
            if (this.ssf == null) {
                try {
                    if (USE_LOCAL_IP_ONLY) {
                        serverSocket = new ServerSocket(n, 0, InetAddress.getByName("127.0.0.1"));
                        break block13;
                    }
                    serverSocket = new ServerSocket(n);
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            } else {
                try {
                    serverSocket = this.ssf.createServerSocket(n);
                }
                catch (IOException iOException3) {
                    iOException = iOException3;
                }
            }
        }
        if (iOException != null) {
            throw new SocketStartupException(n, (Throwable)iOException);
        }
        if (this.ss == null) {
            this.ss = serverSocket;
            object = new Thread(new ServerSocketListener());
            ((Thread)object).setPriority(9);
            ((Thread)object).start();
        } else {
            object = this.ss;
            this.ss = serverSocket;
            try {
                ((ServerSocket)object).close();
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to close old socket listener on port " + ((ServerSocket)object).getLocalPort()), (Throwable)exception);
            }
        }
        this.localPeerDescriptor.setPort(n);
        this.remotePeerDescriptor.setPort(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int testOpenSocket(int n) throws SocketInUseException {
        Socket socket = null;
        try {
            try {
                socket = new Socket("localhost", n);
                throw new SocketInUseException(n);
            }
            catch (IOException iOException) {
                int n2 = n;
                return n2;
            }
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void shutdown() {
        this.shutdownStarted = true;
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disconnectAll(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLogTail(String string, int n) {
        Appendable appendable;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<pre>");
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = null;
        if (n > 0) {
            arrayList = new ArrayList<String>(n + 1);
        }
        try {
            fileInputStream = new FileInputStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((object = bufferedReader.readLine()) != null) {
                appendable = new StringBuffer();
                block27: for (int i = 0; i < ((String)object).length(); ++i) {
                    char c = ((String)object).charAt(i);
                    switch (c) {
                        case ' ': {
                            ((StringBuffer)appendable).append("&nbsp;");
                            continue block27;
                        }
                        case '<': {
                            ((StringBuffer)appendable).append("&lt;");
                            continue block27;
                        }
                        case '>': {
                            ((StringBuffer)appendable).append("&gt;");
                            continue block27;
                        }
                        case '&': {
                            ((StringBuffer)appendable).append("&amp;");
                            continue block27;
                        }
                        case '\t': {
                            ((StringBuffer)appendable).append("&nbsp;&nbsp;&nbsp;&nbsp;");
                            continue block27;
                        }
                        case '\n': {
                            ((StringBuffer)appendable).append("<br>");
                            continue block27;
                        }
                        case '\r': {
                            continue block27;
                        }
                        default: {
                            if (c < ' ') {
                                ((StringBuffer)appendable).append("<i>[");
                                ((StringBuffer)appendable).append(Integer.toHexString(c));
                                ((StringBuffer)appendable).append("]</i>");
                                continue block27;
                            }
                            ((StringBuffer)appendable).append(c);
                        }
                    }
                }
                ((StringBuffer)appendable).append("\n");
                if (arrayList == null) {
                    stringBuffer.append((StringBuffer)appendable);
                    continue;
                }
                if (arrayList.size() >= n) {
                    arrayList.remove(0);
                }
                arrayList.add(((StringBuffer)appendable).toString());
            }
        }
        catch (Exception exception) {
            stringBuffer.delete(0, stringBuffer.length() - 1);
            stringBuffer.append("Unavailable");
            object = new CharArrayWriter();
            appendable = new PrintWriter((Writer)object);
            exception.printStackTrace((PrintWriter)appendable);
            ((PrintWriter)appendable).close();
            stringBuffer.append(((CharArrayWriter)object).toString());
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        if (arrayList != null) {
            if (arrayList.size() < 20) {
                stringBuffer.append("<a name=\"log\">\n");
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (String)arrayList.get(i);
                if (arrayList.size() - i == 20) {
                    stringBuffer.append("<a name=\"log\">\n");
                }
                stringBuffer.append((String)object);
            }
        }
        stringBuffer.append("</pre>\n");
        return stringBuffer.toString();
    }

    String getContentType(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        if (string2.endsWith("JPG") || string2.endsWith("JPEG")) {
            return "image/jpeg";
        }
        if (string2.endsWith("GIF")) {
            return "image/gif";
        }
        if (string2.endsWith("PNG")) {
            return "image/png";
        }
        if (string2.endsWith("TXT") || string2.endsWith("HTML") || string2.endsWith("JS")) {
            return "text/html";
        }
        if (string2.endsWith("CSS")) {
            return "text/css";
        }
        if (string2.endsWith("ZIP")) {
            return "application/zip";
        }
        return null;
    }

    private Map getThreadStacks() {
        Map map = null;
        try {
            Method method = Thread.class.getDeclaredMethod("getAllStackTraces", new Class[0]);
            map = (Map)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    private PeerProtocolRunner startPeerRunner(SocketProtocol socketProtocol, Serializable serializable) {
        PeerProtocolRunner peerProtocolRunner = null;
        long l = SkybotStackSize.getStackSize();
        peerProtocolRunner = l != 0L ? new PeerProtocolRunner(this, socketProtocol, serializable, l) : new PeerProtocolRunner(this, socketProtocol, serializable);
        peerProtocolRunner.start();
        return peerProtocolRunner;
    }

    private static byte[] getContentBytes(String string, String string2) {
        if (string == null) {
            return new byte[0];
        }
        if (string2 == null) {
            return string.getBytes();
        }
        return string.getBytes(Charset.forName(string2));
    }

    static {
        if (!Log4jInit.isInitialized()) {
            Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("<%-5p %d{ISO8601} [%c] %t> %m\n"), "System.out"));
            Logger.getRootLogger().setLevel(Level.TRACE);
        }
        boolean bl = false;
        if ("plaintext".equals(System.getProperty("HSSocketMode")) || "plaintext".equals(System.getenv().get("HSSocketMode"))) {
            bl = true;
        }
        PLAINTEXT_CONNECTIONS = bl;
        rbh = ResourceBundleHandler.getHandler(Peer.class);
        ALL_SECTIONS = new String[]{"general", "config", "managers", "listeners", "log", "modules", "properties", "remoteObjects", "routingTable", "services", "threads"};
    }

    class Response {
        int statusCode = 500;
        String contentType;
        String requestPath;
        byte[] buf;
        boolean forceNoCache;

        Response(int n, String string, byte[] byArray) {
            this.statusCode = n;
            this.buf = byArray;
            this.contentType = Peer.this.getContentType(string);
            this.requestPath = string;
            if (this.contentType == null) {
                this.contentType = "text/html";
            }
        }

        Response(int n, String string) {
            this(n, null, Peer.getContentBytes(string, "UTF-8"));
            this.contentType = "text/html;charset=UTF-8";
        }

        public void setForceNoCache(boolean bl) {
            this.forceNoCache = bl;
        }

        void write(OutputStream outputStream) throws IOException {
            if (this.buf == null) {
                this.buf = new byte[0];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("HTTP/1.1 ");
            stringBuffer.append(this.statusCode);
            stringBuffer.append(" OK\n");
            if (this.statusCode == 302) {
                stringBuffer.append("Location: ");
                stringBuffer.append(new String(this.buf));
                stringBuffer.append("\r\n");
                this.buf = new byte[0];
            }
            if (this.contentType != null) {
                stringBuffer.append("Content-Type: ");
                stringBuffer.append(this.contentType);
                stringBuffer.append("\r\n");
            } else {
                stringBuffer.append("Content-Type: text/html;charset=UTF-8");
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("Content-Length: ");
            stringBuffer.append(this.buf.length);
            stringBuffer.append("\r\n");
            if (this.forceNoCache) {
                stringBuffer.append("Pragma: no-cache");
                stringBuffer.append("\r\n");
                stringBuffer.append("Cache-Control: no-cache");
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("Server: None of the above.");
            stringBuffer.append("\r\n");
            stringBuffer.append("\r\n");
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.write(this.buf);
            outputStream.flush();
        }
    }

    class WebBrowserRunner
    implements Runnable {
        Socket s;
        char firstChar;
        String who;

        WebBrowserRunner(String string, Socket socket, int n) {
            this.who = string;
            this.s = socket;
            this.firstChar = (char)n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block44: {
                boolean bl;
                OutputStream outputStream;
                Response response;
                block40: {
                    block41: {
                        int n;
                        Object object;
                        String[] stringArray;
                        Thread.currentThread().setName("Servicing web browser " + this.who);
                        Thread.currentThread().setPriority(1);
                        Peer.this.currentHttpSocket.set(this.s);
                        response = null;
                        BufferedReader bufferedReader = null;
                        outputStream = null;
                        bl = false;
                        bufferedReader = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                        outputStream = this.s.getOutputStream();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        while ((stringArray = bufferedReader.readLine()) != null && stringArray.length() != 0) {
                            if (arrayList.size() == 0) {
                                arrayList.add(this.firstChar + (String)stringArray);
                                continue;
                            }
                            arrayList.add(stringArray);
                        }
                        stringArray = new String[arrayList.size()];
                        arrayList.toArray(stringArray);
                        String string = null;
                        if (stringArray.length > 0 && ((String[])(object = stringArray[0].split(" "))).length > 1) {
                            string = object[1];
                        }
                        if (string != null && (n = string.indexOf("?")) > -1 && n < string.length() - 1) {
                            string = string.substring(0, n);
                        }
                        if (string == null) {
                            string = "/";
                        }
                        logger.trace((Object)("[HTTP] " + this.who + ": " + string));
                        object = "diagnostics_url.allowed";
                        File file = new File((String)object);
                        boolean bl2 = false;
                        if (!Peer.this.isAllowDiagnosticRequests()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Checking for diagnostics url permission file: " + file.getAbsolutePath()));
                            }
                            if (bl2 = file.exists()) {
                                logger.warn((Object)("Diagnostics are allowed by existing override file: " + file.getAbsolutePath()));
                            }
                        }
                        if (!Peer.this.isAllowDiagnosticRequests() && !bl2) {
                            response = new Response(403, "<h1>403: Diagnostics URL permission is denied.</h1>");
                        } else if (string.startsWith("/cp/")) {
                            string = string.substring(4);
                            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
                            if (inputStream == null) {
                                response = new Response(404, "<h1>404: Stream not found</h1>");
                            } else {
                                String string2 = Peer.this.getContentType(string);
                                if (string2 == null) {
                                    response = new Response(404, "<h1>403: Not allowed</h1>");
                                    inputStream.close();
                                } else {
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    StreamCopier.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream, (int)5000, (boolean)true);
                                    response = new Response(200, string, byteArrayOutputStream.toByteArray());
                                }
                            }
                        } else if (string.startsWith("/x/")) {
                            string = string.substring(3);
                            String string3 = null;
                            if ("all".equals(string)) {
                                StringBuffer stringBuffer = new StringBuffer();
                                for (int i = 0; i < ALL_SECTIONS.length; ++i) {
                                    stringBuffer.append(Peer.this.getHtmlSection(ALL_SECTIONS[i]));
                                }
                                string3 = stringBuffer.toString();
                                response = new Response(200, string3);
                            } else {
                                string3 = Peer.this.getHtmlSection(string);
                                response = new Response(200, string3);
                            }
                            if (string3 == null) {
                                response = new Response(404, "There is no information available for this section.");
                            }
                            response.setForceNoCache(true);
                        } else {
                            bl = true;
                        }
                        if (bl) break block40;
                        if (response != null) break block41;
                        response = new Response(500, "no data");
                    }
                    try {
                        response.write(outputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        this.s.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Peer.this.currentHttpSocket.remove();
                break block44;
                catch (Exception exception) {
                    block42: {
                        block43: {
                            try {
                                logger.debug((Object)("[HTTP] Error servicing web browser peer " + this.who), (Throwable)exception);
                                response = new Response(500, exception.getMessage());
                                if (bl) break block42;
                                if (response != null) break block43;
                                response = new Response(500, "no data");
                            }
                            catch (Throwable throwable) {
                                if (!bl) {
                                    if (response == null) {
                                        response = new Response(500, "no data");
                                    }
                                    try {
                                        response.write(outputStream);
                                    }
                                    catch (Exception exception2) {
                                        // empty catch block
                                    }
                                    try {
                                        this.s.close();
                                    }
                                    catch (Exception exception3) {
                                        // empty catch block
                                    }
                                }
                                Peer.this.currentHttpSocket.remove();
                                throw throwable;
                            }
                        }
                        try {
                            response.write(outputStream);
                        }
                        catch (Exception exception4) {
                            // empty catch block
                        }
                        try {
                            this.s.close();
                        }
                        catch (Exception exception5) {
                            // empty catch block
                        }
                    }
                    Peer.this.currentHttpSocket.remove();
                }
            }
        }
    }

    class ServerSocketListener
    implements Runnable {
        int myport;

        ServerSocketListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            if (Peer.this.ss == null) {
                logger.warn((Object)"Server Socket is null, listening thread will not run.");
                return;
            }
            try {
                while (Peer.this.ss != null && !Peer.this.ss.isClosed()) {
                    if (Peer.this.ss.getLocalPort() != this.myport) {
                        this.myport = Peer.this.ss.getLocalPort();
                        Thread.currentThread().setName("ServerSocket listening on port " + this.myport);
                        logger.trace((Object)("Listening for connects on port " + this.myport));
                    }
                    ServerSocket serverSocket = Peer.this.ss;
                    try {
                        final Socket socket = serverSocket.accept();
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ServerSocketListener.this.detectPeer(socket);
                            }
                        });
                        InetAddress inetAddress = socket.getInetAddress();
                        thread.setName("Detecting Peer type for " + inetAddress.getHostAddress() + ":" + socket.getPort());
                        thread.start();
                    }
                    catch (Exception exception) {
                        if (serverSocket != Peer.this.ss) continue;
                        throw exception;
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                if (Peer.this.shutdownStarted) return;
                logger.error((Object)"This peer's Server Socket has closed. No new connections will be possible  until this process is restarted.", throwable);
                Peer.this.addEvent(new ServerSocketClosedEvent(Peer.this.ourRemotePeerID));
            }
        }

        private void detectPeer(Socket socket) {
            String string = socket.getInetAddress().getHostAddress() + ":" + socket.getPort();
            try {
                Object object;
                SocketProtocol socketProtocol = new SocketProtocol(socket);
                String string2 = "";
                if (socket instanceof SSLSocket) {
                    object = (SSLSocket)socket;
                    if (Peer.this.localPeerDescriptor.isIBMiAgent()) {
                        SSLSocketAdjust.setProtocolsForJavaVersion((SSLSocket)object);
                    } else {
                        SSLSocketAdjust.adjustSSLSocketProtocols((SSLSocket)object);
                    }
                    string2 = " using SSL cipher " + ((SSLSocket)object).getSession().getCipherSuite();
                    String string3 = ((SSLSocket)object).getSession().getProtocol();
                    logger.trace((Object)("Connection started by peer " + string + " using protocol " + string3));
                }
                logger.trace((Object)("Connection started by peer " + string + string2));
                object = ByteBuffer.allocate(1);
                socketProtocol.readWithTimeout((ByteBuffer)object, System.currentTimeMillis(), 1000);
                ((ByteBuffer)object).flip();
                int n = ((ByteBuffer)object).get();
                socketProtocol.unread(n);
                if (n < 0) {
                    n += 256;
                }
                if (SocketProtocol.isHeaderByte(n)) {
                    Peer.this.startPeerRunner(socketProtocol, (Serializable)((Object)Peer.this.getRemotePeerID()));
                } else {
                    WebBrowserRunner webBrowserRunner = new WebBrowserRunner(string, socket, n);
                    webBrowserRunner.run();
                }
            }
            catch (SSLHandshakeException sSLHandshakeException) {
                Throwable throwable = sSLHandshakeException.getCause();
                if (!(throwable instanceof EOFException)) {
                    logger.trace((Object)("Ignoring handshake failure from " + string), (Throwable)sSLHandshakeException);
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            catch (SSLProtocolException sSLProtocolException) {
                logger.trace((Object)("Ignoring protocol failure from " + string), (Throwable)sSLProtocolException);
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            catch (SSLException sSLException) {
                String string4 = "SSLException communicating with " + string;
                boolean bl = false;
                if (sSLException.getCause() != null && sSLException.getCause() instanceof SSLHandshakeException && sSLException.getCause().getCause() != null && sSLException.getCause().getCause() instanceof EOFException) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)string4, (Throwable)sSLException);
                        bl = true;
                    } else {
                        logger.debug((Object)string4);
                        bl = true;
                    }
                }
                if (!bl) {
                    logger.debug((Object)string4, (Throwable)sSLException);
                }
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                String string5 = "Unable to communicate with socket " + string;
                logger.debug((Object)string5, (Throwable)exception);
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
    }
}

