/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import com.helpsystems.enterprise.peer.preconditions.CheckDriveSpace;
import com.helpsystems.enterprise.peer.preconditions.CheckFile;
import com.helpsystems.enterprise.peer.preconditions.CheckFolder;
import com.helpsystems.enterprise.peer.preconditions.CheckProcess;
import com.helpsystems.enterprise.peer.preconditions.CheckTCPService;
import org.apache.log4j.Logger;

public class JobConditionsExecutor {
    private PeerID agentPeerID;
    private static final Logger logger = Logger.getLogger(JobConditionsExecutor.class);

    public JobConditionsExecutor(PeerID peerID) {
        this.agentPeerID = peerID;
    }

    public boolean checkCondition(JobCondition jobCondition) {
        AbstractJobConditionValidator abstractJobConditionValidator = null;
        switch (jobCondition.getConditionType()) {
            case PROCESS: {
                abstractJobConditionValidator = new CheckProcess();
                abstractJobConditionValidator.setAgentPeerID(this.agentPeerID);
                break;
            }
            case DRIVE_SPACE: {
                abstractJobConditionValidator = new CheckDriveSpace();
                break;
            }
            case SERVER_SERVICE_TCP: 
            case FILE_TRANSFER_SYSTEM: {
                abstractJobConditionValidator = new CheckTCPService();
                break;
            }
            case FILE: {
                abstractJobConditionValidator = new CheckFile();
                break;
            }
            case FOLDER: {
                abstractJobConditionValidator = new CheckFolder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Job Condition Type is not valid: " + jobCondition.getConditionType());
            }
        }
        return abstractJobConditionValidator.checkCondition(jobCondition);
    }
}

